/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

public final class FloatingPointBitsConverterUtil {
    private FloatingPointBitsConverterUtil() {
    }

    public static long doubleToSortableLong(double value) {
        long bits = Double.doubleToLongBits(value);
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    public static double sortableLongToDouble(long value) {
        value ^= value >> 63 & Long.MAX_VALUE;
        return Double.longBitsToDouble(value);
    }

    public static int floatToSortableInt(float value) {
        int bits = Float.floatToIntBits(value);
        return bits ^ bits >> 31 & Integer.MAX_VALUE;
    }

    public static float sortableIntToFloat(int value) {
        value ^= value >> 31 & Integer.MAX_VALUE;
        return Float.intBitsToFloat(value);
    }
}

