/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.sql.analyzer.RelationId;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import java.util.Objects;

public final class FieldId {
    private final RelationId relationId;
    private final int fieldIndex;

    public static FieldId from(ResolvedField field) {
        Objects.requireNonNull(field, "field is null");
        Scope sourceScope = field.getScope();
        RelationType relationType = sourceScope.getRelationType();
        return new FieldId(sourceScope.getRelationId(), relationType.indexOf(field.getField()));
    }

    public FieldId(RelationId relationId, int fieldIndex) {
        this.relationId = Objects.requireNonNull(relationId, "relationId is null");
        Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (String)"fieldIndex must be non-negative, got: %s", (int)fieldIndex);
        this.fieldIndex = fieldIndex;
    }

    public RelationId getRelationId() {
        return this.relationId;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldId fieldId = (FieldId)o;
        return this.fieldIndex == fieldId.fieldIndex && Objects.equals(this.relationId, fieldId.relationId);
    }

    public int hashCode() {
        return Objects.hash(this.relationId, this.fieldIndex);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.relationId).addValue(this.fieldIndex).toString();
    }
}

