/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.commons.lang.SystemUtils;
import org.apache.distributedlog.BookKeeperClient;
import org.apache.distributedlog.BookKeeperClientBuilder;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientBuilder;
import org.apache.distributedlog.acl.AccessControlManager;
import org.apache.distributedlog.acl.DefaultAccessControlManager;
import org.apache.distributedlog.api.MetadataAccessor;
import org.apache.distributedlog.api.subscription.SubscriptionsStore;
import org.apache.distributedlog.bk.LedgerAllocator;
import org.apache.distributedlog.bk.LedgerAllocatorUtils;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.AlreadyClosedException;
import org.apache.distributedlog.exceptions.InvalidStreamNameException;
import org.apache.distributedlog.impl.ZKLogMetadataStore;
import org.apache.distributedlog.impl.ZKMetadataAccessor;
import org.apache.distributedlog.impl.acl.ZKAccessControlManager;
import org.apache.distributedlog.impl.federated.FederatedZKLogMetadataStore;
import org.apache.distributedlog.impl.logsegment.BKLogSegmentEntryStore;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.impl.metadata.ZKLogStreamMetadataStore;
import org.apache.distributedlog.impl.subscription.ZKSubscriptionsStore;
import org.apache.distributedlog.injector.AsyncFailureInjector;
import org.apache.distributedlog.logsegment.LogSegmentEntryStore;
import org.apache.distributedlog.metadata.LogMetadataForReader;
import org.apache.distributedlog.metadata.LogMetadataStore;
import org.apache.distributedlog.metadata.LogStreamMetadataStore;
import org.apache.distributedlog.namespace.NamespaceDriver;
import org.apache.distributedlog.namespace.NamespaceDriverManager;
import org.apache.distributedlog.util.DLUtils;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKNamespaceDriver
implements NamespaceDriver {
    private static Logger LOG = LoggerFactory.getLogger(BKNamespaceDriver.class);
    private DistributedLogConfiguration conf;
    private DynamicDistributedLogConfiguration dynConf;
    private URI namespace;
    private OrderedScheduler scheduler;
    private FeatureProvider featureProvider;
    private AsyncFailureInjector failureInjector;
    private StatsLogger statsLogger;
    private StatsLogger perLogStatsLogger;
    private String clientId;
    private int regionId;
    private BKDLConfig bkdlConfig;
    private ZooKeeperClientBuilder sharedWriterZKCBuilder;
    private ZooKeeperClient writerZKC;
    private ZooKeeperClientBuilder sharedReaderZKCBuilder;
    private ZooKeeperClient readerZKC;
    private EventLoopGroup eventLoopGroup;
    private HashedWheelTimer requestTimer;
    private BookKeeperClientBuilder sharedWriterBKCBuilder;
    private BookKeeperClient writerBKC;
    private BookKeeperClientBuilder sharedReaderBKCBuilder;
    private BookKeeperClient readerBKC;
    private LogMetadataStore metadataStore;
    private LogStreamMetadataStore writerStreamMetadataStore;
    private LogStreamMetadataStore readerStreamMetadataStore;
    private LedgerAllocator allocator;
    private LogSegmentEntryStore writerEntryStore;
    private LogSegmentEntryStore readerEntryStore;
    private AccessControlManager accessControlManager;
    protected boolean initialized = false;
    protected AtomicBoolean closed = new AtomicBoolean(false);

    public static String getZKServersFromDLUri(URI uri) {
        return uri.getAuthority().replace(";", ",");
    }

    @Override
    public synchronized NamespaceDriver initialize(DistributedLogConfiguration conf, DynamicDistributedLogConfiguration dynConf, URI namespace, OrderedScheduler scheduler, FeatureProvider featureProvider, AsyncFailureInjector failureInjector, StatsLogger statsLogger, StatsLogger perLogStatsLogger, String clientId, int regionId) throws IOException {
        if (this.initialized) {
            return this;
        }
        if (null == namespace || null == namespace.getAuthority() || null == namespace.getPath()) {
            throw new IOException("Incorrect distributedlog namespace : " + namespace);
        }
        this.conf = conf;
        this.dynConf = dynConf;
        this.namespace = namespace;
        this.scheduler = scheduler;
        this.featureProvider = featureProvider;
        this.failureInjector = failureInjector;
        this.statsLogger = statsLogger;
        this.perLogStatsLogger = perLogStatsLogger;
        this.clientId = clientId;
        this.regionId = regionId;
        this.initializeZooKeeperClients();
        this.initializeBookKeeperClients();
        BKDLConfig.propagateConfiguration(this.bkdlConfig, conf);
        this.initializeLogStreamMetadataStores();
        this.initializeOtherResources();
        this.initialized = true;
        LOG.info("Initialized BK namespace driver: clientId = {}, regionId = {}, federated = {}.", new Object[]{clientId, regionId, this.bkdlConfig.isFederatedNamespace()});
        return this;
    }

    private void initializeZooKeeperClients() throws IOException {
        this.sharedWriterZKCBuilder = BKNamespaceDriver.createZKClientBuilder(String.format("dlzk:%s:factory_writer_shared", this.namespace), this.conf, BKNamespaceDriver.getZKServersFromDLUri(this.namespace), this.statsLogger.scope("dlzk_factory_writer_shared"));
        this.writerZKC = this.sharedWriterZKCBuilder.build();
        this.bkdlConfig = BKDLConfig.resolveDLConfig(this.writerZKC, this.namespace);
        this.sharedReaderZKCBuilder = this.bkdlConfig.getDlZkServersForWriter().equals(this.bkdlConfig.getDlZkServersForReader()) ? this.sharedWriterZKCBuilder : BKNamespaceDriver.createZKClientBuilder(String.format("dlzk:%s:factory_reader_shared", this.namespace), this.conf, this.bkdlConfig.getDlZkServersForReader(), this.statsLogger.scope("dlzk_factory_reader_shared"));
        this.readerZKC = this.sharedReaderZKCBuilder.build();
    }

    private synchronized BKDLConfig getBkdlConfig() {
        return this.bkdlConfig;
    }

    static EventLoopGroup getDefaultEventLoopGroup(int numThreads) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("DL-io-%s").build();
        if (SystemUtils.IS_OS_LINUX) {
            try {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
            catch (Throwable t) {
                LOG.warn("Could not use Netty Epoll event loop for bookie server:", t);
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
        }
        return new NioEventLoopGroup(numThreads, threadFactory);
    }

    private void initializeBookKeeperClients() throws IOException {
        this.eventLoopGroup = BKNamespaceDriver.getDefaultEventLoopGroup(this.conf.getBKClientNumberIOThreads());
        this.requestTimer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("DLFactoryTimer-%d").build(), this.conf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, this.conf.getTimeoutTimerNumTicks());
        this.sharedWriterBKCBuilder = this.createBKCBuilder(String.format("bk:%s:factory_writer_shared", this.namespace), this.conf, this.bkdlConfig.getBkZkServersForWriter(), this.bkdlConfig.getBkLedgersPath(), this.eventLoopGroup, this.requestTimer, Optional.of(this.featureProvider.scope("bkc")), this.statsLogger);
        this.writerBKC = this.sharedWriterBKCBuilder.build();
        this.sharedReaderBKCBuilder = this.bkdlConfig.getBkZkServersForWriter().equals(this.bkdlConfig.getBkZkServersForReader()) ? this.sharedWriterBKCBuilder : this.createBKCBuilder(String.format("bk:%s:factory_reader_shared", this.namespace), this.conf, this.bkdlConfig.getBkZkServersForReader(), this.bkdlConfig.getBkLedgersPath(), this.eventLoopGroup, this.requestTimer, Optional.empty(), this.statsLogger);
        this.readerBKC = this.sharedReaderBKCBuilder.build();
    }

    private void initializeLogStreamMetadataStores() throws IOException {
        this.metadataStore = this.bkdlConfig.isFederatedNamespace() || this.conf.isFederatedNamespaceEnabled() ? new FederatedZKLogMetadataStore(this.conf, this.namespace, this.readerZKC, this.scheduler) : new ZKLogMetadataStore(this.conf, this.namespace, this.readerZKC, this.scheduler);
        this.writerStreamMetadataStore = new ZKLogStreamMetadataStore(this.clientId, this.conf, this.writerZKC, this.scheduler, this.statsLogger);
        this.readerStreamMetadataStore = new ZKLogStreamMetadataStore(this.clientId, this.conf, this.readerZKC, this.scheduler, this.statsLogger);
    }

    @VisibleForTesting
    public static String validateAndGetFullLedgerAllocatorPoolPath(DistributedLogConfiguration conf, URI uri) throws IOException {
        String poolPath = conf.getLedgerAllocatorPoolPath();
        LOG.info("PoolPath is {}", (Object)poolPath);
        if (null == poolPath || !poolPath.startsWith(".") || poolPath.endsWith("/")) {
            LOG.error("Invalid ledger allocator pool path specified when enabling ledger allocator pool: {}", (Object)poolPath);
            throw new IOException("Invalid ledger allocator pool path specified : " + poolPath);
        }
        String poolName = conf.getLedgerAllocatorPoolName();
        if (null == poolName) {
            LOG.error("No ledger allocator pool name specified when enabling ledger allocator pool.");
            throw new IOException("No ledger allocator name specified when enabling ledger allocator pool.");
        }
        String rootPath = uri.getPath() + "/" + poolPath + "/" + poolName;
        try {
            PathUtils.validatePath((String)rootPath);
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Invalid ledger allocator pool path specified when enabling ledger allocator pool: {}", (Object)poolPath);
            throw new IOException("Invalid ledger allocator pool path specified : " + poolPath);
        }
        return rootPath;
    }

    private void initializeOtherResources() throws IOException {
        if (this.conf.getEnableLedgerAllocatorPool()) {
            String allocatorPoolPath = BKNamespaceDriver.validateAndGetFullLedgerAllocatorPoolPath(this.conf, this.namespace);
            this.allocator = LedgerAllocatorUtils.createLedgerAllocatorPool(allocatorPoolPath, this.conf.getLedgerAllocatorPoolCoreSize(), this.conf, this.writerZKC, this.writerBKC, (ScheduledExecutorService)this.scheduler);
            if (null != this.allocator) {
                this.allocator.start();
            }
            LOG.info("Created ledger allocator pool under {} with size {}.", (Object)allocatorPoolPath, (Object)this.conf.getLedgerAllocatorPoolCoreSize());
        } else {
            this.allocator = null;
        }
    }

    private void checkState() throws IOException {
        if (this.closed.get()) {
            LOG.error("BK namespace driver {} is already closed", (Object)this.namespace);
            throw new AlreadyClosedException("BK namespace driver " + this.namespace + " is already closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.doClose();
    }

    private void doClose() {
        if (null != this.accessControlManager) {
            this.accessControlManager.close();
            LOG.info("Access Control Manager Stopped.");
        }
        if (null != this.allocator) {
            Utils.closeQuietly(this.allocator);
            LOG.info("Ledger Allocator stopped.");
        }
        Utils.close(this.writerStreamMetadataStore);
        Utils.close(this.readerStreamMetadataStore);
        this.writerBKC.close();
        this.readerBKC.close();
        this.writerZKC.close();
        this.readerZKC.close();
        this.eventLoopGroup.shutdownGracefully();
        LOG.info("Release external resources used by channel factory.");
        this.requestTimer.stop();
        LOG.info("Stopped request timer");
    }

    @Override
    public URI getUri() {
        return this.namespace;
    }

    @Override
    public String getScheme() {
        return "bk";
    }

    @Override
    public LogMetadataStore getLogMetadataStore() {
        return this.metadataStore;
    }

    @Override
    public LogStreamMetadataStore getLogStreamMetadataStore(NamespaceDriver.Role role) {
        if (NamespaceDriver.Role.WRITER == role) {
            return this.writerStreamMetadataStore;
        }
        return this.readerStreamMetadataStore;
    }

    @Override
    public LogSegmentEntryStore getLogSegmentEntryStore(NamespaceDriver.Role role) {
        if (NamespaceDriver.Role.WRITER == role) {
            return this.getWriterEntryStore();
        }
        return this.getReaderEntryStore();
    }

    private LogSegmentEntryStore getWriterEntryStore() {
        if (null == this.writerEntryStore) {
            this.writerEntryStore = new BKLogSegmentEntryStore(this.conf, this.dynConf, this.writerZKC, this.writerBKC, this.scheduler, this.allocator, this.statsLogger, this.failureInjector);
        }
        return this.writerEntryStore;
    }

    private LogSegmentEntryStore getReaderEntryStore() {
        if (null == this.readerEntryStore) {
            this.readerEntryStore = new BKLogSegmentEntryStore(this.conf, this.dynConf, this.writerZKC, this.readerBKC, this.scheduler, this.allocator, this.statsLogger, this.failureInjector);
        }
        return this.readerEntryStore;
    }

    @Override
    public AccessControlManager getAccessControlManager() throws IOException {
        if (null == this.accessControlManager) {
            String aclRootPath = this.getBkdlConfig().getACLRootPath();
            if (aclRootPath == null) {
                this.accessControlManager = DefaultAccessControlManager.INSTANCE;
                LOG.info("Created default access control manager for {}", (Object)this.namespace);
            } else {
                if (!DLUtils.isReservedStreamName(aclRootPath)) {
                    throw new IOException("Invalid Access Control List Root Path : " + aclRootPath);
                }
                String zkRootPath = this.namespace.getPath() + "/" + aclRootPath;
                LOG.info("Creating zk based access control manager @ {} for {}", (Object)zkRootPath, (Object)this.namespace);
                this.accessControlManager = new ZKAccessControlManager(this.conf, this.readerZKC, zkRootPath, (ScheduledExecutorService)this.scheduler);
                LOG.info("Created zk based access control manager @ {} for {}", (Object)zkRootPath, (Object)this.namespace);
            }
        }
        return this.accessControlManager;
    }

    @Override
    public SubscriptionsStore getSubscriptionsStore(String streamName) {
        return new ZKSubscriptionsStore(this.writerZKC, LogMetadataForReader.getSubscribersPath(this.namespace, streamName, this.conf.getUnpartitionedStreamName()));
    }

    @Override
    public MetadataAccessor getMetadataAccessor(String streamName) throws InvalidStreamNameException, IOException {
        if (this.getBkdlConfig().isFederatedNamespace()) {
            throw new UnsupportedOperationException();
        }
        this.checkState();
        streamName = DLUtils.validateAndNormalizeName(streamName);
        return new ZKMetadataAccessor(streamName, this.conf, this.namespace, this.sharedWriterZKCBuilder, this.sharedReaderZKCBuilder, this.statsLogger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, byte[]> enumerateLogsWithMetadataInNamespace() throws IOException, IllegalArgumentException {
        String namespaceRootPath = this.namespace.getPath();
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        ZooKeeperClient zkc = this.writerZKC;
        try (ZooKeeper zk = Utils.sync(zkc, namespaceRootPath);){
            Stat currentStat = zk.exists(namespaceRootPath, false);
            if (currentStat == null) {
                HashMap<String, byte[]> hashMap = result;
                return hashMap;
            }
            List children = zk.getChildren(namespaceRootPath, false);
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                String child = (String)iterator.next();
                if (DLUtils.isReservedStreamName(child)) continue;
                String zkPath = String.format("%s/%s", namespaceRootPath, child);
                currentStat = zk.exists(zkPath, false);
                if (currentStat == null) {
                    result.put(child, new byte[0]);
                    continue;
                }
                result.put(child, zk.getData(zkPath, false, currentStat));
            }
            return result;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted while deleting " + namespaceRootPath, (Throwable)ie);
            throw new IOException("Interrupted while reading " + namespaceRootPath, ie);
        }
        catch (KeeperException ke) {
            LOG.error("Error reading" + namespaceRootPath + "entry in zookeeper", (Throwable)ke);
            throw new IOException("Error reading" + namespaceRootPath + "entry in zookeeper", ke);
        }
    }

    public static ZooKeeperClientBuilder createZKClientBuilder(String zkcName, DistributedLogConfiguration conf, String zkServers, StatsLogger statsLogger) {
        BoundExponentialBackoffRetryPolicy retryPolicy = null;
        if (conf.getZKNumRetries() > 0) {
            retryPolicy = new BoundExponentialBackoffRetryPolicy((long)conf.getZKRetryBackoffStartMillis(), (long)conf.getZKRetryBackoffMaxMillis(), conf.getZKNumRetries());
        }
        ZooKeeperClientBuilder builder = ZooKeeperClientBuilder.newBuilder().name(zkcName).sessionTimeoutMs(conf.getZKSessionTimeoutMilliseconds()).retryThreadCount(conf.getZKClientNumberRetryThreads()).requestRateLimit(conf.getZKRequestRateLimit()).zkServers(zkServers).retryPolicy((RetryPolicy)retryPolicy).statsLogger(statsLogger).zkAclId(conf.getZkAclId());
        LOG.info("Created shared zooKeeper client builder {}: zkServers = {}, numRetries = {}, sessionTimeout = {}, retryBackoff = {}, maxRetryBackoff = {}, zkAclId = {}.", new Object[]{zkcName, zkServers, conf.getZKNumRetries(), conf.getZKSessionTimeoutMilliseconds(), conf.getZKRetryBackoffStartMillis(), conf.getZKRetryBackoffMaxMillis(), conf.getZkAclId()});
        return builder;
    }

    private BookKeeperClientBuilder createBKCBuilder(String bkcName, DistributedLogConfiguration conf, String zkServers, String ledgersPath, EventLoopGroup eventLoopGroup, HashedWheelTimer requestTimer, Optional<FeatureProvider> featureProviderOptional, StatsLogger statsLogger) {
        BookKeeperClientBuilder builder = BookKeeperClientBuilder.newBuilder().name(bkcName).dlConfig(conf).zkServers(zkServers).ledgersPath(ledgersPath).eventLoopGroup(eventLoopGroup).requestTimer(requestTimer).featureProvider(featureProviderOptional).statsLogger(statsLogger);
        LOG.info("Created shared client builder {} : zkServers = {}, ledgersPath = {}, numIOThreads = {}", new Object[]{bkcName, zkServers, ledgersPath, conf.getBKClientNumberIOThreads()});
        return builder;
    }

    @VisibleForTesting
    public ZooKeeperClient getWriterZKC() {
        return this.writerZKC;
    }

    @VisibleForTesting
    public BookKeeperClient getReaderBKC() {
        return this.readerBKC;
    }

    @VisibleForTesting
    public AsyncFailureInjector getFailureInjector() {
        return this.failureInjector;
    }

    @VisibleForTesting
    public LogStreamMetadataStore getWriterStreamMetadataStore() {
        return this.writerStreamMetadataStore;
    }

    @VisibleForTesting
    public LedgerAllocator getLedgerAllocator() {
        return this.allocator;
    }

    static {
        NamespaceDriverManager.registerDriver("bk", BKNamespaceDriver.class);
    }
}

