/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.ValueWindowFunction;
import io.trino.spi.function.WindowFunctionSignature;
import io.trino.util.Failures;
import java.util.List;

@WindowFunctionSignature(name="nth_value", typeVariable="T", returnType="T", argumentTypes={"T", "bigint"})
public class NthValueFunction
extends ValueWindowFunction {
    private final int valueChannel;
    private final int offsetChannel;
    private final boolean ignoreNulls;

    public NthValueFunction(List<Integer> argumentChannels, boolean ignoreNulls) {
        this.valueChannel = argumentChannels.get(0);
        this.offsetChannel = argumentChannels.get(1);
        this.ignoreNulls = ignoreNulls;
    }

    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        if (frameStart < 0 || this.windowIndex.isNull(this.offsetChannel, currentPosition)) {
            output.appendNull();
        } else {
            long valuePosition;
            long offset = this.windowIndex.getLong(this.offsetChannel, currentPosition);
            Failures.checkCondition(offset >= 1L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Offset must be at least 1", new Object[0]);
            if (this.ignoreNulls) {
                long count = 0L;
                for (valuePosition = (long)frameStart; valuePosition >= 0L && valuePosition <= (long)frameEnd && (this.windowIndex.isNull(this.valueChannel, Math.toIntExact(valuePosition)) || ++count != offset); ++valuePosition) {
                }
            } else {
                valuePosition = (long)frameStart + (offset - 1L);
            }
            if (valuePosition >= (long)frameStart && valuePosition <= (long)frameEnd) {
                this.windowIndex.appendTo(this.valueChannel, Math.toIntExact(valuePosition), output);
            } else {
                output.appendNull();
            }
        }
    }
}

