/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.matcher.Captures;
import io.trino.operator.window.matcher.Instruction;
import io.trino.operator.window.matcher.IntList;
import io.trino.operator.window.matcher.IntMultimap;
import io.trino.operator.window.matcher.IntStack;
import io.trino.operator.window.matcher.Jump;
import io.trino.operator.window.matcher.MatchAggregations;
import io.trino.operator.window.matcher.MatchLabel;
import io.trino.operator.window.matcher.MatchResult;
import io.trino.operator.window.matcher.Program;
import io.trino.operator.window.matcher.Split;
import io.trino.operator.window.matcher.ThreadEquivalence;
import io.trino.operator.window.pattern.LabelEvaluator;
import io.trino.operator.window.pattern.MatchAggregation;
import io.trino.operator.window.pattern.PhysicalValueAccessor;
import io.trino.sql.planner.LocalExecutionPlanner;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class Matcher {
    private final Program program;
    private final ThreadEquivalence threadEquivalence;
    private final List<MatchAggregation.MatchAggregationInstantiator> aggregations;

    public Matcher(Program program, List<List<PhysicalValueAccessor>> accessors, List<LocalExecutionPlanner.MatchAggregationLabelDependency> labelDependencies, List<MatchAggregation.MatchAggregationInstantiator> aggregations) {
        this.program = program;
        this.threadEquivalence = new ThreadEquivalence(program, accessors, labelDependencies);
        this.aggregations = aggregations;
    }

    public MatchResult run(LabelEvaluator labelEvaluator, LocalMemoryContext memoryContext, AggregatedMemoryContext aggregationsMemoryContext) {
        IntList current = new IntList(this.program.size());
        IntList next = new IntList(this.program.size());
        int inputLength = labelEvaluator.getInputLength();
        boolean matchingAtPartitionStart = labelEvaluator.isMatchingAtPartitionStart();
        Runtime runtime = new Runtime(this.program, inputLength, matchingAtPartitionStart, this.aggregations, aggregationsMemoryContext);
        this.advanceAndSchedule(current, runtime.newThread(), 0, 0, runtime);
        MatchResult result = MatchResult.NO_MATCH;
        for (int index = 0; index < inputLength && current.size() != 0; ++index) {
            boolean matched = false;
            runtime.threadsAtInstructions.clear();
            for (int i = 0; i < current.size(); ++i) {
                int threadId = current.get(i);
                int pointer = runtime.threads.get(threadId);
                Instruction instruction = this.program.at(pointer);
                switch (instruction.type()) {
                    case MATCH_LABEL: {
                        int label = ((MatchLabel)instruction).getLabel();
                        runtime.captures.saveLabel(threadId, label);
                        if (labelEvaluator.evaluateLabel(runtime.captures.getLabels(threadId), runtime.aggregations.get(threadId))) {
                            this.advanceAndSchedule(next, threadId, pointer + 1, index + 1, runtime);
                            break;
                        }
                        runtime.killThread(threadId);
                        break;
                    }
                    case DONE: {
                        matched = true;
                        result = new MatchResult(true, runtime.captures.getLabels(threadId), runtime.captures.getCaptures(threadId));
                        runtime.killThread(threadId);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("not yet implemented");
                    }
                }
                if (!matched) continue;
                for (int j = i + 1; j < current.size(); ++j) {
                    runtime.killThread(current.get(j));
                }
                break;
            }
            memoryContext.setBytes(runtime.getSizeInBytes() + current.getSizeInBytes() + next.getSizeInBytes());
            IntList temp = current;
            temp.clear();
            current = next;
            next = temp;
        }
        for (int i = 0; i < current.size(); ++i) {
            int threadId = current.get(i);
            if (this.program.at(runtime.threads.get(threadId)).type() != Instruction.Type.DONE) continue;
            result = new MatchResult(true, runtime.captures.getLabels(threadId), runtime.captures.getCaptures(threadId));
            break;
        }
        return result;
    }

    private void advanceAndSchedule(IntList next, int threadId, int pointer, int inputIndex, Runtime runtime) {
        ArrayView threadsAtInstruction = runtime.threadsAtInstructions.getArrayView(pointer);
        for (int i = 0; i < threadsAtInstruction.length(); ++i) {
            int thread = threadsAtInstruction.get(i);
            if (!this.threadEquivalence.equivalent(thread, runtime.captures.getLabels(thread), runtime.aggregations.get(thread), threadId, runtime.captures.getLabels(threadId), runtime.aggregations.get(threadId), pointer)) continue;
            runtime.killThread(threadId);
            return;
        }
        runtime.threadsAtInstructions.add(pointer, threadId);
        Instruction instruction = this.program.at(pointer);
        switch (instruction.type()) {
            case MATCH_START: {
                if (inputIndex == 0 && runtime.matchingAtPartitionStart) {
                    this.advanceAndSchedule(next, threadId, pointer + 1, inputIndex, runtime);
                    break;
                }
                runtime.killThread(threadId);
                break;
            }
            case MATCH_END: {
                if (inputIndex == runtime.inputLength) {
                    this.advanceAndSchedule(next, threadId, pointer + 1, inputIndex, runtime);
                    break;
                }
                runtime.killThread(threadId);
                break;
            }
            case JUMP: {
                this.advanceAndSchedule(next, threadId, ((Jump)instruction).getTarget(), inputIndex, runtime);
                break;
            }
            case SPLIT: {
                int forked = runtime.forkThread(threadId);
                this.advanceAndSchedule(next, threadId, ((Split)instruction).getFirst(), inputIndex, runtime);
                this.advanceAndSchedule(next, forked, ((Split)instruction).getSecond(), inputIndex, runtime);
                break;
            }
            case SAVE: {
                runtime.captures.save(threadId, inputIndex);
                this.advanceAndSchedule(next, threadId, pointer + 1, inputIndex, runtime);
                break;
            }
            default: {
                runtime.threads.set(threadId, pointer);
                next.add(threadId);
            }
        }
    }

    private static class Runtime {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(Runtime.class).instanceSize();
        private final IntMultimap threadsAtInstructions;
        private final IntList threads;
        private final IntStack freeThreadIds;
        private int newThreadId;
        private final int inputLength;
        private final boolean matchingAtPartitionStart;
        private final Captures captures;
        private final MatchAggregations aggregations;

        public Runtime(Program program, int inputLength, boolean matchingAtPartitionStart, List<MatchAggregation.MatchAggregationInstantiator> aggregationInstantiators, AggregatedMemoryContext aggregationsMemoryContext) {
            int initialCapacity = 2 * program.size();
            this.threads = new IntList(initialCapacity);
            this.freeThreadIds = new IntStack(initialCapacity);
            this.captures = new Captures(initialCapacity, program.getMinSlotCount(), program.getMinLabelCount());
            this.inputLength = inputLength;
            this.matchingAtPartitionStart = matchingAtPartitionStart;
            this.aggregations = new MatchAggregations(initialCapacity, aggregationInstantiators, aggregationsMemoryContext);
            this.threadsAtInstructions = new IntMultimap(program.size(), program.size());
        }

        private int forkThread(int parent) {
            int child = this.newThread();
            this.captures.copy(parent, child);
            this.aggregations.copy(parent, child);
            return child;
        }

        private int newThread() {
            if (this.freeThreadIds.size() > 0) {
                return this.freeThreadIds.pop();
            }
            return this.newThreadId++;
        }

        private void killThread(int threadId) {
            this.freeThreadIds.push(threadId);
            this.captures.release(threadId);
            this.aggregations.release(threadId);
        }

        private long getSizeInBytes() {
            return (long)INSTANCE_SIZE + this.threadsAtInstructions.getSizeInBytes() + this.threads.getSizeInBytes() + this.freeThreadIds.getSizeInBytes() + this.captures.getSizeInBytes() + this.aggregations.getSizeInBytes();
        }
    }
}

