/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import io.trino.sql.planner.optimizations.OptimizerStats;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class OptimizerStatsRecorder {
    private final Map<Class<?>, OptimizerStats> stats = new HashMap();

    public void register(PlanOptimizer optimizer) {
        Objects.requireNonNull(optimizer, "optimizer is null");
        Preconditions.checkArgument((!optimizer.getClass().isAnonymousClass() ? 1 : 0) != 0);
        this.stats.put(optimizer.getClass(), new OptimizerStats());
    }

    public Map<Class<?>, OptimizerStats> getStats() {
        return Collections.unmodifiableMap(this.stats);
    }

    public void record(PlanOptimizer optimizer, long nanos) {
        Objects.requireNonNull(optimizer, "optimizer is null");
        OptimizerStats optimizerStats = Objects.requireNonNull(this.stats.get(optimizer.getClass()), "optimizer is not registered");
        optimizerStats.record(nanos);
    }

    public void recordFailure(PlanOptimizer optimizer) {
        Objects.requireNonNull(optimizer, "optimizer is null");
        OptimizerStats optimizerStats = Objects.requireNonNull(this.stats.get(optimizer.getClass()), "optimizer is not registered");
        optimizerStats.recordFailure();
    }
}

