/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class TypeAnalyzer {
    private final PlannerContext plannerContext;
    private final StatementAnalyzerFactory statementAnalyzerFactory;

    @Inject
    public TypeAnalyzer(PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
    }

    public Map<NodeRef<Expression>, Type> getTypes(Session session, TypeProvider inputTypes, Iterable<Expression> expressions) {
        return ExpressionAnalyzer.analyzeExpressions(session, this.plannerContext, this.statementAnalyzerFactory, new AllowAllAccessControl(), inputTypes, expressions, (Map<NodeRef<Parameter>, Expression>)ImmutableMap.of(), WarningCollector.NOOP, QueryType.OTHERS).getExpressionTypes();
    }

    public Map<NodeRef<Expression>, Type> getTypes(Session session, TypeProvider inputTypes, Expression expression) {
        return this.getTypes(session, inputTypes, (Iterable<Expression>)ImmutableList.of((Object)expression));
    }

    public Type getType(Session session, TypeProvider inputTypes, Expression expression) {
        return this.getTypes(session, inputTypes, expression).get(NodeRef.of((Node)expression));
    }

    public static TypeAnalyzer createTestingTypeAnalyzer(PlannerContext plannerContext) {
        return new TypeAnalyzer(plannerContext, StatementAnalyzerFactory.createTestingStatementAnalyzerFactory(plannerContext, new AllowAllAccessControl(), new TablePropertyManager(), new AnalyzePropertyManager()));
    }
}

