/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.replication.AuditorStats;
import org.apache.bookkeeper.replication.AuditorTask;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.zookeeper.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditorPlacementPolicyCheckTask
extends AuditorTask {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorPlacementPolicyCheckTask.class);
    private final long underreplicatedLedgerRecoveryGracePeriod;
    private final AtomicInteger numOfLedgersFoundNotAdheringInPlacementPolicyCheck;
    private final AtomicInteger numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheck;
    private final AtomicInteger numOfClosedLedgersAuditedInPlacementPolicyCheck;
    private final AtomicInteger numOfURLedgersElapsedRecoveryGracePeriod;

    AuditorPlacementPolicyCheckTask(ServerConfiguration conf, AuditorStats auditorStats, BookKeeperAdmin admin, LedgerManager ledgerManager, LedgerUnderreplicationManager ledgerUnderreplicationManager, AuditorTask.ShutdownTaskHandler shutdownTaskHandler, BiConsumer<AtomicBoolean, Throwable> hasAuditCheckTask) {
        super(conf, auditorStats, admin, ledgerManager, ledgerUnderreplicationManager, shutdownTaskHandler, hasAuditCheckTask);
        this.underreplicatedLedgerRecoveryGracePeriod = conf.getUnderreplicatedLedgerRecoveryGracePeriod();
        this.numOfLedgersFoundNotAdheringInPlacementPolicyCheck = new AtomicInteger(0);
        this.numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheck = new AtomicInteger(0);
        this.numOfClosedLedgersAuditedInPlacementPolicyCheck = new AtomicInteger(0);
        this.numOfURLedgersElapsedRecoveryGracePeriod = new AtomicInteger(0);
    }

    @Override
    protected void runTask() {
        if (this.hasBookieCheckTask()) {
            LOG.info("Audit bookie task already scheduled; skipping periodic placement policy check task");
            return;
        }
        try {
            if (!this.isLedgerReplicationEnabled()) {
                LOG.info("Ledger replication disabled, skipping placementPolicyCheck");
                return;
            }
            Stopwatch stopwatch = Stopwatch.createStarted();
            LOG.info("Starting PlacementPolicyCheck");
            this.placementPolicyCheck();
            long placementPolicyCheckDuration = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
            int numOfLedgersFoundNotAdheringInPlacementPolicyCheckValue = this.numOfLedgersFoundNotAdheringInPlacementPolicyCheck.get();
            int numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheckValue = this.numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheck.get();
            int numOfClosedLedgersAuditedInPlacementPolicyCheckValue = this.numOfClosedLedgersAuditedInPlacementPolicyCheck.get();
            int numOfURLedgersElapsedRecoveryGracePeriodValue = this.numOfURLedgersElapsedRecoveryGracePeriod.get();
            LOG.info("Completed placementPolicyCheck in {} milliSeconds. numOfClosedLedgersAuditedInPlacementPolicyCheck {} numOfLedgersNotAdheringToPlacementPolicy {} numOfLedgersSoftlyAdheringToPlacementPolicy {} numOfURLedgersElapsedRecoveryGracePeriod {}", new Object[]{placementPolicyCheckDuration, numOfClosedLedgersAuditedInPlacementPolicyCheckValue, numOfLedgersFoundNotAdheringInPlacementPolicyCheckValue, numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheckValue, numOfURLedgersElapsedRecoveryGracePeriodValue});
            this.auditorStats.getLedgersNotAdheringToPlacementPolicyGuageValue().set(numOfLedgersFoundNotAdheringInPlacementPolicyCheckValue);
            this.auditorStats.getLedgersSoftlyAdheringToPlacementPolicyGuageValue().set(numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheckValue);
            this.auditorStats.getNumOfURLedgersElapsedRecoveryGracePeriodGuageValue().set(numOfURLedgersElapsedRecoveryGracePeriodValue);
            this.auditorStats.getPlacementPolicyCheckTime().registerSuccessfulEvent(placementPolicyCheckDuration, TimeUnit.MILLISECONDS);
        }
        catch (ReplicationException.BKAuditException e) {
            int numOfURLedgersElapsedRecoveryGracePeriodValue;
            int numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheckValue;
            int numOfLedgersFoundInPlacementPolicyCheckValue = this.numOfLedgersFoundNotAdheringInPlacementPolicyCheck.get();
            if (numOfLedgersFoundInPlacementPolicyCheckValue > 0) {
                this.auditorStats.getLedgersNotAdheringToPlacementPolicyGuageValue().set(numOfLedgersFoundInPlacementPolicyCheckValue);
            }
            if ((numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheckValue = this.numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheck.get()) > 0) {
                this.auditorStats.getLedgersSoftlyAdheringToPlacementPolicyGuageValue().set(numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheckValue);
            }
            if ((numOfURLedgersElapsedRecoveryGracePeriodValue = this.numOfURLedgersElapsedRecoveryGracePeriod.get()) > 0) {
                this.auditorStats.getNumOfURLedgersElapsedRecoveryGracePeriodGuageValue().set(numOfURLedgersElapsedRecoveryGracePeriodValue);
            }
            LOG.error("BKAuditException running periodic placementPolicy check.numOfLedgersNotAdheringToPlacementPolicy {}, numOfLedgersSoftlyAdheringToPlacementPolicy {},numOfURLedgersElapsedRecoveryGracePeriod {}", new Object[]{numOfLedgersFoundInPlacementPolicyCheckValue, numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheckValue, numOfURLedgersElapsedRecoveryGracePeriodValue, e});
        }
        catch (ReplicationException.UnavailableException ue) {
            LOG.error("Underreplication manager unavailable running periodic check", (Throwable)ue);
        }
    }

    @Override
    public void shutdown() {
    }

    void placementPolicyCheck() throws ReplicationException.BKAuditException {
        final CountDownLatch placementPolicyCheckLatch = new CountDownLatch(1);
        this.numOfLedgersFoundNotAdheringInPlacementPolicyCheck.set(0);
        this.numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheck.set(0);
        this.numOfClosedLedgersAuditedInPlacementPolicyCheck.set(0);
        this.numOfURLedgersElapsedRecoveryGracePeriod.set(0);
        if (this.underreplicatedLedgerRecoveryGracePeriod > 0L) {
            Iterator<UnderreplicatedLedger> underreplicatedLedgersInfo = this.ledgerUnderreplicationManager.listLedgersToRereplicate(null);
            ArrayList<Long> urLedgersElapsedRecoveryGracePeriod = new ArrayList<Long>();
            while (underreplicatedLedgersInfo.hasNext()) {
                long elapsedTimeInSecs;
                UnderreplicatedLedger underreplicatedLedger = underreplicatedLedgersInfo.next();
                long underreplicatedLedgerMarkTimeInMilSecs = underreplicatedLedger.getCtime();
                if (underreplicatedLedgerMarkTimeInMilSecs == -1L || (elapsedTimeInSecs = (System.currentTimeMillis() - underreplicatedLedgerMarkTimeInMilSecs) / 1000L) <= this.underreplicatedLedgerRecoveryGracePeriod) continue;
                urLedgersElapsedRecoveryGracePeriod.add(underreplicatedLedger.getLedgerId());
                this.numOfURLedgersElapsedRecoveryGracePeriod.incrementAndGet();
            }
            if (urLedgersElapsedRecoveryGracePeriod.isEmpty()) {
                LOG.info("No Underreplicated ledger has elapsed recovery graceperiod: {}", urLedgersElapsedRecoveryGracePeriod);
            } else {
                LOG.error("Following Underreplicated ledgers have elapsed recovery graceperiod: {}", urLedgersElapsedRecoveryGracePeriod);
            }
        }
        BookkeeperInternalCallbacks.Processor<Long> ledgerProcessor = new BookkeeperInternalCallbacks.Processor<Long>(){

            @Override
            public void process(Long ledgerId, AsyncCallback.VoidCallback iterCallback) {
                AuditorPlacementPolicyCheckTask.this.ledgerManager.readLedgerMetadata(ledgerId).whenComplete((metadataVer, exception) -> {
                    if (exception == null) {
                        AuditorPlacementPolicyCheckTask.this.doPlacementPolicyCheck(ledgerId, iterCallback, (Versioned<LedgerMetadata>)metadataVer);
                    } else if (BKException.getExceptionCode(exception) == -25) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Ignoring replication of already deleted ledger {}", (Object)ledgerId);
                        }
                        iterCallback.processResult(0, null, null);
                    } else {
                        LOG.warn("Unable to read the ledger: {} information", (Object)ledgerId);
                        iterCallback.processResult(BKException.getExceptionCode(exception), null, null);
                    }
                });
            }
        };
        final ArrayList resultCode = new ArrayList(1);
        this.ledgerManager.asyncProcessLedgers(ledgerProcessor, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String s, Object obj) {
                resultCode.add(rc);
                placementPolicyCheckLatch.countDown();
            }
        }, null, 0, -1);
        try {
            placementPolicyCheckLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ReplicationException.BKAuditException("Exception while doing placementPolicy check", e);
        }
        if (!resultCode.contains(0)) {
            throw new ReplicationException.BKAuditException("Exception while doing placementPolicy check", BKException.create((Integer)resultCode.get(0)));
        }
        try {
            this.ledgerUnderreplicationManager.setPlacementPolicyCheckCTime(System.currentTimeMillis());
        }
        catch (ReplicationException.NonRecoverableReplicationException nre) {
            LOG.error("Non Recoverable Exception while reading from ZK", (Throwable)nre);
            this.submitShutdownTask();
        }
        catch (ReplicationException.UnavailableException ue) {
            LOG.error("Got exception while trying to set PlacementPolicyCheckCTime", (Throwable)ue);
        }
    }

    void doPlacementPolicyCheck(Long ledgerId, AsyncCallback.VoidCallback iterCallback, Versioned<LedgerMetadata> metadataVer) {
        LedgerMetadata metadata = metadataVer.getValue();
        int writeQuorumSize = metadata.getWriteQuorumSize();
        int ackQuorumSize = metadata.getAckQuorumSize();
        if (metadata.isClosed()) {
            boolean foundSegmentNotAdheringToPlacementPolicy = false;
            boolean foundSegmentSoftlyAdheringToPlacementPolicy = false;
            for (Map.Entry ensemble : metadata.getAllEnsembles().entrySet()) {
                long startEntryIdOfSegment = (Long)ensemble.getKey();
                List ensembleOfSegment = (List)ensemble.getValue();
                EnsemblePlacementPolicy.PlacementPolicyAdherence segmentAdheringToPlacementPolicy = this.admin.isEnsembleAdheringToPlacementPolicy(ensembleOfSegment, writeQuorumSize, ackQuorumSize);
                if (segmentAdheringToPlacementPolicy == EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL) {
                    foundSegmentNotAdheringToPlacementPolicy = true;
                    LOG.warn("For ledger: {}, Segment starting at entry: {}, with ensemble: {} having writeQuorumSize: {} and ackQuorumSize: {} is not adhering to EnsemblePlacementPolicy", new Object[]{ledgerId, startEntryIdOfSegment, ensembleOfSegment, writeQuorumSize, ackQuorumSize});
                    continue;
                }
                if (segmentAdheringToPlacementPolicy != EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_SOFT) continue;
                foundSegmentSoftlyAdheringToPlacementPolicy = true;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("For ledger: {}, Segment starting at entry: {}, with ensemble: {} having writeQuorumSize: {} and ackQuorumSize: {} is softly adhering to EnsemblePlacementPolicy", new Object[]{ledgerId, startEntryIdOfSegment, ensembleOfSegment, writeQuorumSize, ackQuorumSize});
            }
            if (foundSegmentNotAdheringToPlacementPolicy) {
                this.numOfLedgersFoundNotAdheringInPlacementPolicyCheck.incrementAndGet();
                if (this.conf.isRepairedPlacementPolicyNotAdheringBookieEnable()) {
                    this.ledgerUnderreplicationManager.markLedgerUnderreplicatedAsync(ledgerId, Collections.emptyList()).whenComplete((res, e) -> {
                        if (e != null) {
                            LOG.error("For ledger: {}, the placement policy not adhering bookie storage, mark it to under replication manager failed.", (Object)ledgerId, e);
                            return;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("For ledger: {}, the placement policy not adhering bookie storage, mark it to under replication manager", (Object)ledgerId);
                        }
                    });
                }
            } else if (foundSegmentSoftlyAdheringToPlacementPolicy) {
                this.numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheck.incrementAndGet();
            }
            this.numOfClosedLedgersAuditedInPlacementPolicyCheck.incrementAndGet();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Ledger: {} is not yet closed, so skipping the placementPolicycheck analysis for now", (Object)ledgerId);
        }
        iterCallback.processResult(0, null, null);
    }

    public long getUnderreplicatedLedgerRecoveryGracePeriod() {
        return this.underreplicatedLedgerRecoveryGracePeriod;
    }

    public AtomicInteger getNumOfLedgersFoundNotAdheringInPlacementPolicyCheck() {
        return this.numOfLedgersFoundNotAdheringInPlacementPolicyCheck;
    }

    public AtomicInteger getNumOfLedgersFoundSoftlyAdheringInPlacementPolicyCheck() {
        return this.numOfLedgersFoundSoftlyAdheringInPlacementPolicyCheck;
    }

    public AtomicInteger getNumOfClosedLedgersAuditedInPlacementPolicyCheck() {
        return this.numOfClosedLedgersAuditedInPlacementPolicyCheck;
    }

    public AtomicInteger getNumOfURLedgersElapsedRecoveryGracePeriod() {
        return this.numOfURLedgersElapsedRecoveryGracePeriod;
    }
}

