/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.util.RFC3339DateFormat;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;

public final class DateRFC3339TypeAdapter
extends TypeAdapter<Date> {
    private final boolean serializeTime;
    private final TimeZone serializationTimezone;
    private final ThreadLocal<DateFormat> dateFormatThreadLocal = new ThreadLocal();

    public DateRFC3339TypeAdapter(boolean serializeTime) {
        this(TimeZone.getDefault(), serializeTime);
    }

    public DateRFC3339TypeAdapter(TimeZone serializationTimezone, boolean serializeTime) {
        this.serializationTimezone = serializationTimezone;
        this.serializeTime = serializeTime;
    }

    private DateFormat getDateFormat() {
        DateFormat existingDateFormat = this.dateFormatThreadLocal.get();
        if (existingDateFormat == null) {
            RFC3339DateFormat newDateFormat = new RFC3339DateFormat(this.serializationTimezone, this.serializeTime);
            this.dateFormatThreadLocal.set(newDateFormat);
            return newDateFormat;
        }
        return existingDateFormat;
    }

    public void write(JsonWriter out, Date value) throws IOException {
        out.value(this.getDateFormat().format(value));
    }

    public Date read(JsonReader in) throws IOException {
        String dateStr = in.nextString();
        try {
            return this.getDateFormat().parse(dateStr);
        }
        catch (ParseException e) {
            throw new IOException("Could not parse date " + dateStr, e);
        }
    }
}

