/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.Int128ArrayBlockBuilder;

public class Int128ArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "INT128_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        if (!block.mayHaveNull()) {
            sliceOutput.writeBytes(this.getValuesSlice(block));
        } else {
            long[] valuesWithoutNull = new long[positionCount * 2];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = block.getLong(i, 0);
                valuesWithoutNull[nonNullPositionCount + 1] = block.getLong(i, 8);
                if (block.isNull(i)) continue;
                nonNullPositionCount += 2;
            }
            sliceOutput.writeInt(nonNullPositionCount / 2);
            sliceOutput.writeBytes(Slices.wrappedLongArray((long[])valuesWithoutNull, (int)0, (int)nonNullPositionCount));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        long[] values = new long[positionCount * 2];
        if (valueIsNull == null) {
            sliceInput.readBytes(Slices.wrappedLongArray((long[])values));
        } else {
            int nonNullPositionCount = sliceInput.readInt();
            sliceInput.readBytes(Slices.wrappedLongArray((long[])values, (int)0, (int)(nonNullPositionCount * 2)));
            int position = 2 * (nonNullPositionCount - 1);
            for (int i = positionCount - 1; i >= 0 && position >= 0; --i) {
                System.arraycopy(values, position, values, 2 * i, 2);
                if (valueIsNull[i]) continue;
                position -= 2;
            }
        }
        return new Int128ArrayBlock(0, positionCount, valueIsNull, values);
    }

    private Slice getValuesSlice(Block block) {
        if (block instanceof Int128ArrayBlock) {
            return ((Int128ArrayBlock)block).getValuesSlice();
        }
        if (block instanceof Int128ArrayBlockBuilder) {
            return ((Int128ArrayBlockBuilder)block).getValuesSlice();
        }
        throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
    }
}

