/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.broker.loadbalance.ResourceDescription;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;

public class PulsarResourceDescription
extends ResourceDescription {
    private Map<String, ResourceUsage> resourceUsageByName = new HashMap<String, ResourceUsage>();

    @Override
    public int compareTo(ResourceDescription o) {
        if (o.getResourceUsage().size() > this.resourceUsageByName.size()) {
            return -1;
        }
        if (this.exactlyEquals(o.getResourceUsage())) {
            return 0;
        }
        for (Map.Entry<String, ResourceUsage> entry : o.getResourceUsage().entrySet()) {
            String resourceName = entry.getKey();
            if (this.resourceUsageByName.containsKey(resourceName)) {
                int less = this.resourceUsageByName.get(resourceName).compareTo(entry.getValue());
                if (less > 0) continue;
                return -1;
            }
            return -1;
        }
        return 1;
    }

    private boolean exactlyEquals(Map<String, ResourceUsage> o) {
        if (this.resourceUsageByName.size() != o.size()) {
            return false;
        }
        return this.resourceUsageByName.entrySet().stream().allMatch(e -> ((ResourceUsage)e.getValue()).equals(o.get(e.getKey())));
    }

    @Override
    public void removeUsage(ResourceDescription rd) {
    }

    @Override
    public void addUsage(ResourceDescription rd) {
    }

    @Override
    public int getUsagePct() {
        return 0;
    }

    @Override
    public Map<String, ResourceUsage> getResourceUsage() {
        return this.resourceUsageByName;
    }

    public void put(String resourceType, ResourceUsage resourceUsage) {
        this.resourceUsageByName.put(resourceType, resourceUsage);
    }

    public long calculateRank() {
        float weight = 1.0f;
        if (this.resourceUsageByName.size() > 1) {
            weight = 1.0f / (float)this.resourceUsageByName.size();
        }
        long rank = 0L;
        int resourcesWithHighUsage = 0;
        int throttle = 75;
        for (Map.Entry<String, ResourceUsage> entry : this.resourceUsageByName.entrySet()) {
            double percentageUsage = 0.0;
            if (entry.getValue().limit > 0.0) {
                percentageUsage = entry.getValue().usage / entry.getValue().limit * 100.0;
            }
            double resourceWeight = (double)weight * percentageUsage;
            if (percentageUsage > (double)throttle) {
                int n = resourcesWithHighUsage++;
            }
            rank = (long)((double)rank + resourceWeight);
        }
        if (resourcesWithHighUsage > 0) {
            rank = rank * (long)resourcesWithHighUsage * 2L;
        }
        return rank;
    }
}

