/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.storage;

import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public interface ManagedLedgerStorage
extends AutoCloseable {
    public void initialize(ServiceConfiguration var1, MetadataStoreExtended var2, BookKeeperClientFactory var3, EventLoopGroup var4) throws Exception;

    public ManagedLedgerFactory getManagedLedgerFactory();

    public StatsProvider getStatsProvider();

    public BookKeeper getBookKeeperClient();

    @Override
    public void close() throws IOException;

    public static ManagedLedgerStorage create(ServiceConfiguration conf, MetadataStoreExtended metadataStore, BookKeeperClientFactory bkProvider, EventLoopGroup eventLoopGroup) throws Exception {
        ManagedLedgerStorage storage = (ManagedLedgerStorage)Reflections.createInstance((String)conf.getManagedLedgerStorageClassName(), ManagedLedgerStorage.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
        storage.initialize(conf, metadataStore, bkProvider, eventLoopGroup);
        return storage;
    }
}

