/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.functions.worker.ErrorNotifier;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionAssignmentTailer
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FunctionAssignmentTailer.class);
    private final FunctionRuntimeManager functionRuntimeManager;
    private final ReaderBuilder readerBuilder;
    private final WorkerConfig workerConfig;
    private final ErrorNotifier errorNotifier;
    private Reader<byte[]> reader;
    private volatile boolean isRunning = false;
    private volatile boolean exitOnEndOfTopic = false;
    private CompletableFuture<Void> exitFuture;
    private Thread tailerThread;
    private MessageId lastMessageId = null;

    public FunctionAssignmentTailer(FunctionRuntimeManager functionRuntimeManager, ReaderBuilder readerBuilder, WorkerConfig workerConfig, ErrorNotifier errorNotifier) {
        this.functionRuntimeManager = functionRuntimeManager;
        this.exitFuture = new CompletableFuture();
        this.readerBuilder = readerBuilder;
        this.workerConfig = workerConfig;
        this.errorNotifier = errorNotifier;
    }

    public synchronized CompletableFuture<Void> triggerReadToTheEndAndExit() {
        this.exitOnEndOfTopic = true;
        return this.exitFuture;
    }

    public void startFromMessage(MessageId startMessageId) throws PulsarClientException {
        if (!this.isRunning) {
            this.isRunning = true;
            if (this.reader == null) {
                this.reader = this.createReader(startMessageId);
            }
            if (this.tailerThread == null || !this.tailerThread.isAlive()) {
                this.tailerThread = this.getTailerThread();
            }
            this.tailerThread.start();
        }
    }

    public synchronized void start() throws PulsarClientException {
        MessageId startMessageId = this.lastMessageId == null ? MessageId.earliest : this.lastMessageId;
        this.startFromMessage(startMessageId);
    }

    @Override
    public synchronized void close() {
        log.info("Closing function assignment tailer");
        try {
            this.isRunning = false;
            if (this.tailerThread != null) {
                while (true) {
                    this.tailerThread.interrupt();
                    try {
                        this.tailerThread.join(5000L, 0);
                    }
                    catch (InterruptedException e) {
                        log.warn("Waiting for assignment tailer thread to stop is interrupted", (Throwable)e);
                    }
                    if (!this.tailerThread.isAlive()) break;
                    log.warn("Assignment tailer thread is still alive.  Will attempt to interrupt again.");
                }
                this.tailerThread = null;
                this.exitFuture.complete(null);
                this.exitFuture = new CompletableFuture();
            }
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.exitOnEndOfTopic = false;
        }
        catch (IOException e) {
            log.error("Failed to stop function assignment tailer", (Throwable)e);
        }
    }

    private Reader<byte[]> createReader(MessageId startMessageId) throws PulsarClientException {
        log.info("Assignment tailer will start reading from message id {}", (Object)startMessageId);
        return WorkerUtils.createReader(this.readerBuilder, this.workerConfig.getWorkerId() + "-function-assignment-tailer", this.workerConfig.getFunctionAssignmentTopic(), startMessageId);
    }

    private Thread getTailerThread() {
        Thread t = new Thread(() -> {
            while (this.isRunning) {
                try {
                    Message msg = this.reader.readNext(1, TimeUnit.SECONDS);
                    if (msg == null) {
                        if (!this.exitOnEndOfTopic || ((Boolean)this.reader.hasMessageAvailableAsync().get(10L, TimeUnit.SECONDS)).booleanValue()) continue;
                        break;
                    }
                    this.functionRuntimeManager.processAssignmentMessage((Message<byte[]>)msg);
                    this.lastMessageId = msg.getMessageId();
                }
                catch (Throwable th) {
                    if (this.isRunning) {
                        log.error("Encountered error in assignment tailer", th);
                        this.isRunning = false;
                        this.errorNotifier.triggerError(th);
                        continue;
                    }
                    if (th instanceof InterruptedException || th.getCause() instanceof InterruptedException) continue;
                    log.warn("Encountered error when assignment tailer is not running", th);
                }
            }
            log.info("assignment tailer thread exiting");
            this.exitFuture.complete(null);
        });
        t.setName("assignment-tailer-thread");
        return t;
    }

    Thread getThread() {
        return this.tailerThread;
    }

    @Generated
    public MessageId getLastMessageId() {
        return this.lastMessageId;
    }
}

