/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.api;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.common.util.BackoffBuilder;

public class MetadataCacheConfig {
    private static final long DEFAULT_CACHE_REFRESH_TIME_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    public static final BackoffBuilder DEFAULT_RETRY_BACKOFF_BUILDER = new BackoffBuilder().setInitialTime(5L, TimeUnit.MILLISECONDS).setMax(3L, TimeUnit.SECONDS).setMandatoryStop(30L, TimeUnit.SECONDS);
    private final long refreshAfterWriteMillis;
    private final long expireAfterWriteMillis;
    private final BackoffBuilder retryBackoff;

    @Generated
    private static long $default$refreshAfterWriteMillis() {
        return DEFAULT_CACHE_REFRESH_TIME_MILLIS;
    }

    @Generated
    private static long $default$expireAfterWriteMillis() {
        return 2L * DEFAULT_CACHE_REFRESH_TIME_MILLIS;
    }

    @Generated
    private static BackoffBuilder $default$retryBackoff() {
        return DEFAULT_RETRY_BACKOFF_BUILDER;
    }

    @Generated
    MetadataCacheConfig(long refreshAfterWriteMillis, long expireAfterWriteMillis, BackoffBuilder retryBackoff) {
        this.refreshAfterWriteMillis = refreshAfterWriteMillis;
        this.expireAfterWriteMillis = expireAfterWriteMillis;
        this.retryBackoff = retryBackoff;
    }

    @Generated
    public static MetadataCacheConfigBuilder builder() {
        return new MetadataCacheConfigBuilder();
    }

    @Generated
    public long getRefreshAfterWriteMillis() {
        return this.refreshAfterWriteMillis;
    }

    @Generated
    public long getExpireAfterWriteMillis() {
        return this.expireAfterWriteMillis;
    }

    @Generated
    public BackoffBuilder getRetryBackoff() {
        return this.retryBackoff;
    }

    @Generated
    public String toString() {
        return "MetadataCacheConfig(refreshAfterWriteMillis=" + this.getRefreshAfterWriteMillis() + ", expireAfterWriteMillis=" + this.getExpireAfterWriteMillis() + ", retryBackoff=" + String.valueOf(this.getRetryBackoff()) + ")";
    }

    @Generated
    public static class MetadataCacheConfigBuilder {
        @Generated
        private boolean refreshAfterWriteMillis$set;
        @Generated
        private long refreshAfterWriteMillis$value;
        @Generated
        private boolean expireAfterWriteMillis$set;
        @Generated
        private long expireAfterWriteMillis$value;
        @Generated
        private boolean retryBackoff$set;
        @Generated
        private BackoffBuilder retryBackoff$value;

        @Generated
        MetadataCacheConfigBuilder() {
        }

        @Generated
        public MetadataCacheConfigBuilder refreshAfterWriteMillis(long refreshAfterWriteMillis) {
            this.refreshAfterWriteMillis$value = refreshAfterWriteMillis;
            this.refreshAfterWriteMillis$set = true;
            return this;
        }

        @Generated
        public MetadataCacheConfigBuilder expireAfterWriteMillis(long expireAfterWriteMillis) {
            this.expireAfterWriteMillis$value = expireAfterWriteMillis;
            this.expireAfterWriteMillis$set = true;
            return this;
        }

        @Generated
        public MetadataCacheConfigBuilder retryBackoff(BackoffBuilder retryBackoff) {
            this.retryBackoff$value = retryBackoff;
            this.retryBackoff$set = true;
            return this;
        }

        @Generated
        public MetadataCacheConfig build() {
            long refreshAfterWriteMillis$value = this.refreshAfterWriteMillis$value;
            if (!this.refreshAfterWriteMillis$set) {
                refreshAfterWriteMillis$value = MetadataCacheConfig.$default$refreshAfterWriteMillis();
            }
            long expireAfterWriteMillis$value = this.expireAfterWriteMillis$value;
            if (!this.expireAfterWriteMillis$set) {
                expireAfterWriteMillis$value = MetadataCacheConfig.$default$expireAfterWriteMillis();
            }
            BackoffBuilder retryBackoff$value = this.retryBackoff$value;
            if (!this.retryBackoff$set) {
                retryBackoff$value = MetadataCacheConfig.$default$retryBackoff();
            }
            return new MetadataCacheConfig(refreshAfterWriteMillis$value, expireAfterWriteMillis$value, retryBackoff$value);
        }

        @Generated
        public String toString() {
            return "MetadataCacheConfig.MetadataCacheConfigBuilder(refreshAfterWriteMillis$value=" + this.refreshAfterWriteMillis$value + ", expireAfterWriteMillis$value=" + this.expireAfterWriteMillis$value + ", retryBackoff$value=" + String.valueOf(this.retryBackoff$value) + ")";
        }
    }
}

