/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.DataObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.json.annotations.JsonGen;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.DeploymentOptionsConverter;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.ThreadingModel;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.VertxOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@DataObject
@JsonGen(publicConverter=false)
public class DeploymentOptions {
    public static final ThreadingModel DEFAULT_MODE = ThreadingModel.EVENT_LOOP;
    public static final boolean DEFAULT_WORKER = false;
    public static final boolean DEFAULT_HA = false;
    public static final int DEFAULT_INSTANCES = 1;
    private JsonObject config;
    private ThreadingModel threadingModel;
    private boolean ha;
    private int instances;
    private ClassLoader classLoader;
    private String workerPoolName;
    private int workerPoolSize;
    private long maxWorkerExecuteTime;
    private TimeUnit maxWorkerExecuteTimeUnit;

    public DeploymentOptions() {
        this.threadingModel = DEFAULT_MODE;
        this.config = null;
        this.ha = false;
        this.instances = 1;
        this.workerPoolSize = 20;
        this.maxWorkerExecuteTime = VertxOptions.DEFAULT_MAX_WORKER_EXECUTE_TIME;
        this.maxWorkerExecuteTimeUnit = VertxOptions.DEFAULT_MAX_WORKER_EXECUTE_TIME_UNIT;
    }

    public DeploymentOptions(DeploymentOptions other) {
        this.config = other.getConfig() == null ? null : other.getConfig().copy();
        this.threadingModel = other.getThreadingModel();
        this.ha = other.isHa();
        this.instances = other.instances;
        this.workerPoolName = other.workerPoolName;
        this.workerPoolSize = other.workerPoolSize;
        this.maxWorkerExecuteTime = other.maxWorkerExecuteTime;
        this.maxWorkerExecuteTimeUnit = other.maxWorkerExecuteTimeUnit;
    }

    public DeploymentOptions(JsonObject json) {
        this();
        DeploymentOptionsConverter.fromJson(json, this);
    }

    public void fromJson(JsonObject json) {
        this.config = json.getJsonObject("config");
        this.ha = json.getBoolean("ha", false);
        this.instances = json.getInteger("instances", 1);
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public DeploymentOptions setConfig(JsonObject config) {
        this.config = config;
        return this;
    }

    public ThreadingModel getThreadingModel() {
        return this.threadingModel;
    }

    public DeploymentOptions setThreadingModel(ThreadingModel threadingModel) {
        this.threadingModel = threadingModel;
        return this;
    }

    @Deprecated
    public boolean isWorker() {
        return this.threadingModel == ThreadingModel.WORKER;
    }

    @Deprecated
    public DeploymentOptions setWorker(boolean worker) {
        this.threadingModel = worker ? ThreadingModel.WORKER : ThreadingModel.EVENT_LOOP;
        return this;
    }

    public boolean isHa() {
        return this.ha;
    }

    public DeploymentOptions setHa(boolean ha) {
        this.ha = ha;
        return this;
    }

    public int getInstances() {
        return this.instances;
    }

    public DeploymentOptions setInstances(int instances) {
        this.instances = instances;
        return this;
    }

    public String getWorkerPoolName() {
        return this.workerPoolName;
    }

    public DeploymentOptions setWorkerPoolName(String workerPoolName) {
        this.workerPoolName = workerPoolName;
        return this;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public DeploymentOptions setWorkerPoolSize(int workerPoolSize) {
        if (workerPoolSize < 1) {
            throw new IllegalArgumentException("size must be > 0");
        }
        this.workerPoolSize = workerPoolSize;
        return this;
    }

    public long getMaxWorkerExecuteTime() {
        return this.maxWorkerExecuteTime;
    }

    public DeploymentOptions setMaxWorkerExecuteTime(long maxWorkerExecuteTime) {
        if (maxWorkerExecuteTime < 1L) {
            throw new IllegalArgumentException("maxExecuteTime must be > 0");
        }
        this.maxWorkerExecuteTime = maxWorkerExecuteTime;
        return this;
    }

    public TimeUnit getMaxWorkerExecuteTimeUnit() {
        return this.maxWorkerExecuteTimeUnit;
    }

    public DeploymentOptions setMaxWorkerExecuteTimeUnit(TimeUnit maxWorkerExecuteTimeUnit) {
        this.maxWorkerExecuteTimeUnit = maxWorkerExecuteTimeUnit;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DeploymentOptions setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public void checkIsolationNotDefined() {
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        DeploymentOptionsConverter.toJson(this, json);
        return json;
    }
}

