/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.config;

import org.apache.distributedlog.bk.QuorumConfig;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;

public class DynamicDistributedLogConfiguration
extends ConcurrentBaseConfiguration {
    private final ConcurrentBaseConfiguration defaultConfig;

    public DynamicDistributedLogConfiguration(ConcurrentBaseConfiguration defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    private static int getInt(ConcurrentBaseConfiguration configuration, String newKey, String oldKey, int defaultValue) {
        return configuration.getInt(newKey, configuration.getInt(oldKey, defaultValue));
    }

    public int getRetentionPeriodHours() {
        return DynamicDistributedLogConfiguration.getInt(this, "logSegmentRetentionHours", "retention-size", DynamicDistributedLogConfiguration.getInt(this.defaultConfig, "logSegmentRetentionHours", "retention-size", 72));
    }

    public int getBpsSoftWriteLimit() {
        return this.getInt("bpsSoftWriteLimit", this.defaultConfig.getInt("bpsSoftWriteLimit", -1));
    }

    public int getBpsHardWriteLimit() {
        return this.getInt("bpsHardWriteLimit", this.defaultConfig.getInt("bpsHardWriteLimit", -1));
    }

    public int getRpsSoftWriteLimit() {
        return this.getInt("rpsSoftWriteLimit", this.defaultConfig.getInt("rpsSoftWriteLimit", -1));
    }

    public int getRpsHardWriteLimit() {
        return this.getInt("rpsHardWriteLimit", this.defaultConfig.getInt("rpsHardWriteLimit", -1));
    }

    public int getRpsSoftServiceLimit() {
        return this.getInt("rpsSoftServiceLimit", this.defaultConfig.getInt("rpsSoftServiceLimit", -1));
    }

    public int getRpsHardServiceLimit() {
        return this.getInt("rpsHardServiceLimit", this.defaultConfig.getInt("rpsHardServiceLimit", -1));
    }

    public int getRpsStreamAcquireServiceLimit() {
        return this.getInt("rpsStreamAcquireServiceLimit", this.defaultConfig.getInt("rpsStreamAcquireServiceLimit", -1));
    }

    public int getBpsSoftServiceLimit() {
        return this.getInt("bpsSoftServiceLimit", this.defaultConfig.getInt("bpsSoftServiceLimit", -1));
    }

    public int getBpsHardServiceLimit() {
        return this.getInt("bpsHardServiceLimit", this.defaultConfig.getInt("bpsHardServiceLimit", -1));
    }

    public int getBpsStreamAcquireServiceLimit() {
        return this.getInt("bpsStreamAcquireServiceLimit", this.defaultConfig.getInt("bpsStreamAcquireServiceLimit", -1));
    }

    public double getEIInjectedWriteDelayPercent() {
        return this.getDouble("eiInjectedWriteDelayPercent", this.defaultConfig.getDouble("eiInjectedWriteDelayPercent", 0.0));
    }

    public int getEIInjectedWriteDelayMs() {
        return this.getInt("eiInjectedWriteDelayMs", this.defaultConfig.getInt("eiInjectedWriteDelayMs", 0));
    }

    public int getOutputBufferSize() {
        return DynamicDistributedLogConfiguration.getInt(this, "writerOutputBufferSize", "output-buffer-size", DynamicDistributedLogConfiguration.getInt(this.defaultConfig, "writerOutputBufferSize", "output-buffer-size", 1024));
    }

    public int getPeriodicFlushFrequencyMilliSeconds() {
        return this.getInt("periodicFlushFrequencyMilliSeconds", this.defaultConfig.getInt("periodicFlushFrequencyMilliSeconds", 0));
    }

    public int getReadAheadBatchSize() {
        return DynamicDistributedLogConfiguration.getInt(this, "readAheadBatchSize", "ReadAheadBatchSize", DynamicDistributedLogConfiguration.getInt(this.defaultConfig, "readAheadBatchSize", "ReadAheadBatchSize", 2));
    }

    public int getReadAheadMaxRecords() {
        return DynamicDistributedLogConfiguration.getInt(this, "readAheadMaxRecords", "ReadAheadMaxEntries", DynamicDistributedLogConfiguration.getInt(this.defaultConfig, "readAheadMaxRecords", "ReadAheadMaxEntries", 10));
    }

    public boolean getEnableLedgerAllocatorPool() {
        return this.getBoolean("enableLedgerAllocatorPool", this.defaultConfig.getBoolean("enableLedgerAllocatorPool", false));
    }

    public QuorumConfig getQuorumConfig() {
        int ensembleSize = DynamicDistributedLogConfiguration.getInt(this, "bkcEnsembleSize", "ensemble-size", DynamicDistributedLogConfiguration.getInt(this.defaultConfig, "bkcEnsembleSize", "ensemble-size", 3));
        int writeQuorumSize = DynamicDistributedLogConfiguration.getInt(this, "bkcWriteQuorumSize", "write-quorum-size", DynamicDistributedLogConfiguration.getInt(this.defaultConfig, "bkcWriteQuorumSize", "write-quorum-size", 3));
        int ackQuorumSize = DynamicDistributedLogConfiguration.getInt(this, "bkcAckQuorumSize", "ack-quorum-size", DynamicDistributedLogConfiguration.getInt(this.defaultConfig, "bkcAckQuorumSize", "ack-quorum-size", 2));
        return new QuorumConfig(ensembleSize, writeQuorumSize, ackQuorumSize);
    }

    public int getMaxAcquiredPartitionsPerProxy() {
        return this.getInt("maxAcquiredPartitionsPerProxy", this.defaultConfig.getInt("maxAcquiredPartitionsPerProxy", -1));
    }

    public int getMaxCachedPartitionsPerProxy() {
        return this.getInt("maxCachedPartitionsPerProxy", this.defaultConfig.getInt("maxCachedPartitionsPerProxy", -1));
    }

    public boolean isDurableWriteEnabled() {
        return this.getBoolean("isDurableWriteEnabled", this.defaultConfig.getBoolean("isDurableWriteEnabled", true));
    }

    public boolean getDeserializeRecordSetOnReads() {
        return this.getBoolean("deserializeRecordSetOnReads", this.defaultConfig.getBoolean("deserializeRecordSetOnReads", true));
    }
}

