/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.common.api.proto.MessageIdData;

public final class CommandMessage {
    private long consumerId;
    private static final int _CONSUMER_ID_FIELD_NUMBER = 1;
    private static final int _CONSUMER_ID_TAG = 8;
    private static final int _CONSUMER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _CONSUMER_ID_MASK = 1;
    private MessageIdData messageId;
    private static final int _MESSAGE_ID_FIELD_NUMBER = 2;
    private static final int _MESSAGE_ID_TAG = 18;
    private static final int _MESSAGE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(18);
    private static final int _MESSAGE_ID_MASK = 2;
    private int redeliveryCount = 0;
    private static final int _REDELIVERY_COUNT_FIELD_NUMBER = 3;
    private static final int _REDELIVERY_COUNT_TAG = 24;
    private static final int _REDELIVERY_COUNT_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _REDELIVERY_COUNT_MASK = 4;
    private long[] ackSets = null;
    private int _ackSetsCount = 0;
    private static final int _ACK_SET_FIELD_NUMBER = 4;
    private static final int _ACK_SET_TAG = 32;
    private static final int _ACK_SET_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _ACK_SET_TAG_PACKED = 34;
    private long consumerEpoch;
    private static final int _CONSUMER_EPOCH_FIELD_NUMBER = 5;
    private static final int _CONSUMER_EPOCH_TAG = 40;
    private static final int _CONSUMER_EPOCH_TAG_SIZE = LightProtoCodec.computeVarIntSize(40);
    private static final int _CONSUMER_EPOCH_MASK = 16;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 3;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasConsumerId() {
        return (this._bitField0 & 1) != 0;
    }

    public long getConsumerId() {
        if (!this.hasConsumerId()) {
            throw new IllegalStateException("Field 'consumer_id' is not set");
        }
        return this.consumerId;
    }

    public CommandMessage setConsumerId(long consumerId) {
        this.consumerId = consumerId;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public CommandMessage clearConsumerId() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasMessageId() {
        return (this._bitField0 & 2) != 0;
    }

    public MessageIdData getMessageId() {
        if (!this.hasMessageId()) {
            throw new IllegalStateException("Field 'message_id' is not set");
        }
        return this.messageId;
    }

    public MessageIdData setMessageId() {
        if (this.messageId == null) {
            this.messageId = new MessageIdData();
        }
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this.messageId;
    }

    public CommandMessage clearMessageId() {
        this._bitField0 &= 0xFFFFFFFD;
        if (this.hasMessageId()) {
            this.messageId.clear();
        }
        return this;
    }

    public boolean hasRedeliveryCount() {
        return (this._bitField0 & 4) != 0;
    }

    public int getRedeliveryCount() {
        return this.redeliveryCount;
    }

    public CommandMessage setRedeliveryCount(int redeliveryCount) {
        this.redeliveryCount = redeliveryCount;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public CommandMessage clearRedeliveryCount() {
        this._bitField0 &= 0xFFFFFFFB;
        this.redeliveryCount = 0;
        return this;
    }

    public int getAckSetsCount() {
        return this._ackSetsCount;
    }

    public long getAckSetAt(int idx) {
        if (idx < 0 || idx >= this._ackSetsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._ackSetsCount + ") for field 'ack_set'");
        }
        return this.ackSets[idx];
    }

    public void addAckSet(long ackSet) {
        if (this.ackSets == null) {
            this.ackSets = new long[4];
        }
        if (this.ackSets.length == this._ackSetsCount) {
            this.ackSets = Arrays.copyOf(this.ackSets, this._ackSetsCount * 2);
        }
        this._cachedSize = -1;
        this.ackSets[this._ackSetsCount++] = ackSet;
    }

    public CommandMessage clearAckSet() {
        this._ackSetsCount = 0;
        return this;
    }

    public boolean hasConsumerEpoch() {
        return (this._bitField0 & 0x10) != 0;
    }

    public long getConsumerEpoch() {
        if (!this.hasConsumerEpoch()) {
            throw new IllegalStateException("Field 'consumer_epoch' is not set");
        }
        return this.consumerEpoch;
    }

    public CommandMessage setConsumerEpoch(long consumerEpoch) {
        this.consumerEpoch = consumerEpoch;
        this._bitField0 |= 0x10;
        this._cachedSize = -1;
        return this;
    }

    public CommandMessage clearConsumerEpoch() {
        this._bitField0 &= 0xFFFFFFEF;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.consumerId);
        LightProtoCodec.writeVarInt(_b, 18);
        LightProtoCodec.writeVarInt(_b, this.messageId.getSerializedSize());
        this.messageId.writeTo(_b);
        if (this.hasRedeliveryCount()) {
            LightProtoCodec.writeVarInt(_b, 24);
            LightProtoCodec.writeVarInt(_b, this.redeliveryCount);
        }
        for (int i = 0; i < this._ackSetsCount; ++i) {
            long _item = this.ackSets[i];
            LightProtoCodec.writeVarInt(_b, 32);
            LightProtoCodec.writeVarInt64(_b, _item);
        }
        if (this.hasConsumerEpoch()) {
            LightProtoCodec.writeVarInt(_b, 40);
            LightProtoCodec.writeVarInt64(_b, this.consumerEpoch);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _CONSUMER_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.consumerId);
        _size += LightProtoCodec.computeVarIntSize(18);
        int MsgsizeMessageId = this.messageId.getSerializedSize();
        _size += LightProtoCodec.computeVarIntSize(MsgsizeMessageId) + MsgsizeMessageId;
        if (this.hasRedeliveryCount()) {
            _size += _REDELIVERY_COUNT_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.redeliveryCount);
        }
        for (int i = 0; i < this._ackSetsCount; ++i) {
            long _item = this.ackSets[i];
            _size += _ACK_SET_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(_item);
        }
        if (this.hasConsumerEpoch()) {
            _size += _CONSUMER_EPOCH_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.consumerEpoch);
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block8: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.consumerId = LightProtoCodec.readVarInt64(_buffer);
                    continue block8;
                }
                case 18: {
                    this._bitField0 |= 2;
                    int messageIdSize = LightProtoCodec.readVarInt(_buffer);
                    this.setMessageId().parseFrom(_buffer, messageIdSize);
                    continue block8;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.redeliveryCount = LightProtoCodec.readVarInt(_buffer);
                    continue block8;
                }
                case 32: {
                    this.addAckSet(LightProtoCodec.readVarInt64(_buffer));
                    continue block8;
                }
                case 40: {
                    this._bitField0 |= 0x10;
                    this.consumerEpoch = LightProtoCodec.readVarInt64(_buffer);
                    continue block8;
                }
                case 34: {
                    int _ackSetSize = LightProtoCodec.readVarInt(_buffer);
                    int _ackSetEndIdx = _buffer.readerIndex() + _ackSetSize;
                    while (_buffer.readerIndex() < _ackSetEndIdx) {
                        this.addAckSet(LightProtoCodec.readVarInt64(_buffer));
                    }
                    continue block8;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 3) != 3) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandMessage clear() {
        if (this.hasMessageId()) {
            this.messageId.clear();
        }
        this.redeliveryCount = 0;
        this._ackSetsCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandMessage copyFrom(CommandMessage _other) {
        this._cachedSize = -1;
        if (_other.hasConsumerId()) {
            this.setConsumerId(_other.consumerId);
        }
        if (_other.hasMessageId()) {
            this.setMessageId().copyFrom(_other.messageId);
        }
        if (_other.hasRedeliveryCount()) {
            this.setRedeliveryCount(_other.redeliveryCount);
        }
        for (int i = 0; i < _other.getAckSetsCount(); ++i) {
            this.addAckSet(_other.getAckSetAt(i));
        }
        if (_other.hasConsumerEpoch()) {
            this.setConsumerEpoch(_other.consumerEpoch);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a);
        this.parseFrom(b, b.readableBytes());
    }
}

