/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.SchedulerManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MembershipManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MembershipManager.class);
    private final WorkerConfig workerConfig;
    private PulsarAdmin pulsarAdmin;
    static final String COORDINATION_TOPIC_SUBSCRIPTION = "participants";
    private static final String WORKER_IDENTIFIER = "id";
    @VisibleForTesting
    Map<Function.Instance, Long> unsignedFunctionDurations = new HashMap<Function.Instance, Long>();

    MembershipManager(WorkerService workerService, PulsarClient pulsarClient, PulsarAdmin pulsarAdmin) {
        this.workerConfig = workerService.getWorkerConfig();
        this.pulsarAdmin = pulsarAdmin;
    }

    public List<WorkerInfo> getCurrentMembership() {
        LinkedList<WorkerInfo> workerIds = new LinkedList<WorkerInfo>();
        TopicStats topicStats = null;
        try {
            topicStats = this.pulsarAdmin.topics().getStats(this.workerConfig.getClusterCoordinationTopic());
        }
        catch (PulsarAdminException e) {
            log.error("Failed to get status of coordinate topic {}", (Object)this.workerConfig.getClusterCoordinationTopic(), (Object)e);
            throw new RuntimeException(e);
        }
        for (ConsumerStats consumerStats : ((SubscriptionStats)topicStats.getSubscriptions().get(COORDINATION_TOPIC_SUBSCRIPTION)).getConsumers()) {
            WorkerInfo workerInfo = WorkerInfo.parseFrom((String)((String)consumerStats.getMetadata().get(WORKER_IDENTIFIER)));
            workerIds.add(workerInfo);
        }
        return workerIds;
    }

    public WorkerInfo getLeader() {
        TopicStats topicStats = null;
        try {
            topicStats = this.pulsarAdmin.topics().getStats(this.workerConfig.getClusterCoordinationTopic());
        }
        catch (PulsarAdminException e) {
            log.error("Failed to get status of coordinate topic {}", (Object)this.workerConfig.getClusterCoordinationTopic(), (Object)e);
            throw new RuntimeException(e);
        }
        String activeConsumerName = ((SubscriptionStats)topicStats.getSubscriptions().get(COORDINATION_TOPIC_SUBSCRIPTION)).getActiveConsumerName();
        WorkerInfo leader = null;
        for (ConsumerStats consumerStats : ((SubscriptionStats)topicStats.getSubscriptions().get(COORDINATION_TOPIC_SUBSCRIPTION)).getConsumers()) {
            if (!consumerStats.getConsumerName().equals(activeConsumerName)) continue;
            leader = WorkerInfo.parseFrom((String)((String)consumerStats.getMetadata().get(WORKER_IDENTIFIER)));
        }
        if (leader == null) {
            log.warn("Failed to determine leader in functions cluster");
        }
        return leader;
    }

    @Override
    public void close() {
    }

    public void checkFailures(FunctionMetaDataManager functionMetaDataManager, FunctionRuntimeManager functionRuntimeManager, SchedulerManager schedulerManager) {
        Function.Instance instance2;
        Set currentMembership = this.getCurrentMembership().stream().map(entry -> entry.getWorkerId()).collect(Collectors.toSet());
        List<Function.FunctionMetaData> functionMetaDataList = functionMetaDataManager.getAllFunctionMetaData();
        HashMap<String, Function.FunctionMetaData> functionMetaDataMap = new HashMap<String, Function.FunctionMetaData>();
        for (Function.FunctionMetaData entry2 : functionMetaDataList) {
            functionMetaDataMap.put(FunctionCommon.getFullyQualifiedName((Function.FunctionDetails)entry2.getFunctionDetails()), entry2);
        }
        Map<String, Map<String, Function.Assignment>> currentAssignments = functionRuntimeManager.getCurrentAssignments();
        HashMap<String, Function.Assignment> assignmentMap = new HashMap<String, Function.Assignment>();
        for (Map<String, Function.Assignment> entry3 : currentAssignments.values()) {
            assignmentMap.putAll(entry3);
        }
        long currentTimeMs = System.currentTimeMillis();
        Iterator<Map.Entry<Function.Instance, Long>> it = this.unsignedFunctionDurations.entrySet().iterator();
        while (it.hasNext()) {
            String assignedWorkerId;
            Iterator<Map.Entry<String, Map<String, Function.Assignment>>> entry4 = it.next();
            String fullyQualifiedFunctionName = FunctionCommon.getFullyQualifiedName((Function.FunctionDetails)((Function.Instance)entry4.getKey()).getFunctionMetaData().getFunctionDetails());
            String fullyQualifiedInstanceId = FunctionCommon.getFullyQualifiedInstanceId((Function.Instance)((Function.Instance)entry4.getKey()));
            if (!functionMetaDataMap.containsKey(fullyQualifiedFunctionName)) {
                it.remove();
                continue;
            }
            Function.Assignment assignment2 = (Function.Assignment)assignmentMap.get(fullyQualifiedInstanceId);
            if (assignment2 == null || !currentMembership.contains(assignedWorkerId = assignment2.getWorkerId())) continue;
            it.remove();
        }
        for (Function.FunctionMetaData functionMetaData : functionMetaDataList) {
            Collection<Function.Assignment> assignments = FunctionRuntimeManager.findFunctionAssignments(functionMetaData.getFunctionDetails().getTenant(), functionMetaData.getFunctionDetails().getNamespace(), functionMetaData.getFunctionDetails().getName(), currentAssignments);
            Set assignedInstances = assignments.stream().map(assignment -> assignment.getInstance()).collect(Collectors.toSet());
            HashSet<Function.Instance> instances = new HashSet<Function.Instance>(SchedulerManager.computeInstances(functionMetaData, functionRuntimeManager.getRuntimeFactory().externallyManaged()));
            for (Function.Instance instance2 : instances) {
                if (assignedInstances.contains(instance2) || this.unsignedFunctionDurations.containsKey(instance2)) continue;
                this.unsignedFunctionDurations.put(instance2, currentTimeMs);
            }
        }
        for (Map.Entry<String, Map<String, Function.Assignment>> entry5 : currentAssignments.entrySet()) {
            String workerId = entry5.getKey();
            Map<String, Function.Assignment> assignmentEntries = entry5.getValue();
            if (currentMembership.contains(workerId)) continue;
            for (Function.Assignment assignmentEntry : assignmentEntries.values()) {
                instance2 = assignmentEntry.getInstance();
                if (SchedulerManager.checkHeartBeatFunction(instance2) != null || this.unsignedFunctionDurations.containsKey(instance2)) continue;
                this.unsignedFunctionDurations.put(instance2, currentTimeMs);
            }
        }
        boolean triggerScheduler = false;
        LinkedList<Function.Instance> needSchedule = new LinkedList<Function.Instance>();
        LinkedList<Function.Assignment> needRemove = new LinkedList<Function.Assignment>();
        HashMap<String, Integer> numRemoved = new HashMap<String, Integer>();
        for (Map.Entry<Function.Instance, Long> entry6 : this.unsignedFunctionDurations.entrySet()) {
            instance2 = entry6.getKey();
            long unassignedDurationMs = entry6.getValue();
            if (currentTimeMs - unassignedDurationMs <= this.workerConfig.getRescheduleTimeoutMs()) continue;
            needSchedule.add(instance2);
            Function.Assignment assignment3 = (Function.Assignment)assignmentMap.get(FunctionCommon.getFullyQualifiedInstanceId((Function.Instance)instance2));
            if (assignment3 != null) {
                needRemove.add(assignment3);
                Integer count = (Integer)numRemoved.get(assignment3.getWorkerId());
                if (count == null) {
                    count = 0;
                }
                numRemoved.put(assignment3.getWorkerId(), count + 1);
            }
            triggerScheduler = true;
        }
        if (!needRemove.isEmpty()) {
            functionRuntimeManager.removeAssignments(needRemove);
        }
        if (triggerScheduler) {
            log.info("Failure check - Total number of instances that need to be scheduled/rescheduled: {} | Number of unassigned instances that need to be scheduled: {} | Number of instances on dead workers that need to be reassigned {}", new Object[]{needSchedule.size(), needSchedule.size() - needRemove.size(), numRemoved});
            schedulerManager.schedule();
        }
    }
}

