/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.cluster;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.bookkeeper.stream.proto.cluster.ClusterAssignmentData;
import org.apache.bookkeeper.stream.proto.cluster.ClusterMetadata;
import org.apache.bookkeeper.stream.storage.StorageConstants;
import org.apache.bookkeeper.stream.storage.api.cluster.ClusterMetadataStore;
import org.apache.bookkeeper.stream.storage.exceptions.StorageRuntimeException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.metadata.DLMetadata;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClusterMetadataStore
implements ClusterMetadataStore {
    private static final Logger log = LoggerFactory.getLogger(ZkClusterMetadataStore.class);
    private final CuratorFramework client;
    private final String zkServers;
    private final String zkRootPath;
    private final String zkClusterMetadataPath;
    private final String zkClusterAssignmentPath;
    private final Map<Consumer<Void>, NodeCacheListener> assignmentDataConsumers;
    private NodeCache assignmentDataCache;
    private volatile boolean closed = false;

    public ZkClusterMetadataStore(CuratorFramework client, String zkServers, String zkRootPath) {
        this.client = client;
        this.zkServers = zkServers;
        this.zkRootPath = zkRootPath;
        this.zkClusterMetadataPath = StorageConstants.getClusterMetadataPath(zkRootPath);
        this.zkClusterAssignmentPath = StorageConstants.getClusterAssignmentPath(zkRootPath);
        this.assignmentDataConsumers = new HashMap<Consumer<Void>, NodeCacheListener>();
    }

    synchronized int getNumWatchers() {
        return this.assignmentDataConsumers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ZkClusterMetadataStore zkClusterMetadataStore = this;
        synchronized (zkClusterMetadataStore) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (null != this.assignmentDataCache) {
                try {
                    this.assignmentDataCache.close();
                }
                catch (IOException e) {
                    log.warn("Failed to close assignment data cache", (Throwable)e);
                }
            }
        }
    }

    public boolean initializeCluster(int numStorageContainers, Optional<String> segmentStorePath) {
        ClusterMetadata metadata = ClusterMetadata.newBuilder().setNumStorageContainers((long)numStorageContainers).build();
        ClusterAssignmentData assigmentData = ClusterAssignmentData.newBuilder().build();
        try {
            BKDLConfig dlogConfig = new BKDLConfig(this.zkServers, segmentStorePath.orElse(StorageConstants.getSegmentsRootPath(this.zkRootPath)));
            DLMetadata dlogMetadata = DLMetadata.create((BKDLConfig)dlogConfig);
            this.client.transaction().forOperations(new CuratorOp[]{(CuratorOp)this.client.transactionOp().create().forPath(this.zkRootPath), (CuratorOp)this.client.transactionOp().create().forPath(this.zkClusterMetadataPath, metadata.toByteArray()), (CuratorOp)this.client.transactionOp().create().forPath(this.zkClusterAssignmentPath, assigmentData.toByteArray()), (CuratorOp)this.client.transactionOp().create().forPath(StorageConstants.getServersPath(this.zkRootPath)), (CuratorOp)this.client.transactionOp().create().forPath(StorageConstants.getWritableServersPath(this.zkRootPath)), (CuratorOp)this.client.transactionOp().create().forPath(StorageConstants.getStoragePath(this.zkRootPath), dlogMetadata.serialize())});
            return true;
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NodeExistsException) {
                log.info("Stream storage cluster is already initialized.");
                return false;
            }
            throw new StorageRuntimeException("Failed to initialize storage cluster with " + numStorageContainers + " storage containers", (Throwable)e);
        }
    }

    public ClusterAssignmentData getClusterAssignmentData() {
        try {
            byte[] data = (byte[])this.client.getData().forPath(this.zkClusterAssignmentPath);
            return ClusterAssignmentData.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ie) {
            throw new StorageRuntimeException("The cluster assignment data from zookeeper @" + this.zkClusterAssignmentPath + " is corrupted", (Throwable)ie);
        }
        catch (Exception e) {
            throw new StorageRuntimeException("Failed to fetch cluster assignment data from zookeeper @" + this.zkClusterAssignmentPath, (Throwable)e);
        }
    }

    public void updateClusterAssignmentData(ClusterAssignmentData assigmentData) {
        byte[] data = assigmentData.toByteArray();
        try {
            this.client.setData().forPath(this.zkClusterAssignmentPath, data);
        }
        catch (Exception e) {
            throw new StorageRuntimeException("Failed to update cluster assignment data to zookeeper @" + this.zkClusterAssignmentPath, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchClusterAssignmentData(Consumer<Void> watcher, Executor executor) {
        ZkClusterMetadataStore zkClusterMetadataStore = this;
        synchronized (zkClusterMetadataStore) {
            NodeCacheListener listener;
            if (this.assignmentDataCache == null) {
                this.assignmentDataCache = new NodeCache(this.client, this.zkClusterAssignmentPath);
                try {
                    this.assignmentDataCache.start();
                }
                catch (Exception e) {
                    throw new StorageRuntimeException("Failed to watch cluster assignment data", (Throwable)e);
                }
            }
            if (null == (listener = this.assignmentDataConsumers.get(watcher))) {
                listener = () -> watcher.accept(null);
                this.assignmentDataConsumers.put(watcher, listener);
                this.assignmentDataCache.getListenable().addListener((Object)listener, executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unwatchClusterAssignmentData(Consumer<Void> watcher) {
        ZkClusterMetadataStore zkClusterMetadataStore = this;
        synchronized (zkClusterMetadataStore) {
            NodeCacheListener listener = this.assignmentDataConsumers.remove(watcher);
            if (null != listener && null != this.assignmentDataCache) {
                this.assignmentDataCache.getListenable().removeListener((Object)listener);
            }
            if (this.assignmentDataConsumers.isEmpty() && null != this.assignmentDataCache) {
                try {
                    this.assignmentDataCache.close();
                }
                catch (IOException e) {
                    log.warn("Failed to close assignment data cache when there is no watcher", (Throwable)e);
                }
            }
        }
    }

    public ClusterMetadata getClusterMetadata() {
        try {
            byte[] data = (byte[])this.client.getData().forPath(this.zkClusterMetadataPath);
            return ClusterMetadata.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ie) {
            throw new StorageRuntimeException("The cluster metadata from zookeeper @" + this.zkClusterMetadataPath + " is corrupted", (Throwable)ie);
        }
        catch (Exception e) {
            throw new StorageRuntimeException("Failed to fetch cluster metadata from zookeeper @" + this.zkClusterMetadataPath, (Throwable)e);
        }
    }

    public void updateClusterMetadata(ClusterMetadata metadata) {
        byte[] data = metadata.toByteArray();
        try {
            this.client.setData().forPath(this.zkClusterMetadataPath, data);
        }
        catch (Exception e) {
            throw new StorageRuntimeException("Failed to update cluster metadata to zookeeper @" + this.zkClusterMetadataPath, (Throwable)e);
        }
    }
}

