/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import lombok.Generated;
import org.apache.pulsar.broker.resources.BookieResources;
import org.apache.pulsar.broker.resources.ClusterResources;
import org.apache.pulsar.broker.resources.DynamicConfigurationResources;
import org.apache.pulsar.broker.resources.LoadBalanceResources;
import org.apache.pulsar.broker.resources.LoadManagerReportResources;
import org.apache.pulsar.broker.resources.LocalPoliciesResources;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.resources.ResourceGroupResources;
import org.apache.pulsar.broker.resources.TenantResources;
import org.apache.pulsar.broker.resources.TopicResources;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;

public class PulsarResources {
    public static final int DEFAULT_OPERATION_TIMEOUT_SEC = 30;
    private final TenantResources tenantResources;
    private final ClusterResources clusterResources;
    private final ResourceGroupResources resourcegroupResources;
    private final NamespaceResources namespaceResources;
    private final DynamicConfigurationResources dynamicConfigResources;
    private final LocalPoliciesResources localPolicies;
    private final LoadManagerReportResources loadReportResources;
    private final BookieResources bookieResources;
    private final TopicResources topicResources;
    private final LoadBalanceResources loadBalanceResources;
    private final Optional<MetadataStoreExtended> localMetadataStore;
    private final Optional<MetadataStore> configurationMetadataStore;

    public PulsarResources(MetadataStoreExtended localMetadataStore, MetadataStore configurationMetadataStore) {
        this(localMetadataStore, configurationMetadataStore, 30);
    }

    public PulsarResources(MetadataStoreExtended localMetadataStore, MetadataStore configurationMetadataStore, int operationTimeoutSec) {
        this(localMetadataStore, configurationMetadataStore, operationTimeoutSec, ForkJoinPool.commonPool());
    }

    public PulsarResources(MetadataStoreExtended localMetadataStore, MetadataStore configurationMetadataStore, int operationTimeoutSec, Executor executor) {
        if (configurationMetadataStore != null) {
            this.tenantResources = new TenantResources(configurationMetadataStore, operationTimeoutSec);
            this.clusterResources = new ClusterResources((MetadataStore)localMetadataStore, configurationMetadataStore, operationTimeoutSec);
            this.namespaceResources = new NamespaceResources(configurationMetadataStore, operationTimeoutSec, executor);
            this.resourcegroupResources = new ResourceGroupResources(configurationMetadataStore, operationTimeoutSec);
        } else {
            this.tenantResources = null;
            this.clusterResources = null;
            this.namespaceResources = null;
            this.resourcegroupResources = null;
        }
        if (localMetadataStore != null) {
            this.dynamicConfigResources = new DynamicConfigurationResources((MetadataStore)localMetadataStore, operationTimeoutSec);
            this.localPolicies = new LocalPoliciesResources((MetadataStore)localMetadataStore, operationTimeoutSec);
            this.loadReportResources = new LoadManagerReportResources((MetadataStore)localMetadataStore, operationTimeoutSec);
            this.bookieResources = new BookieResources((MetadataStore)localMetadataStore, operationTimeoutSec);
            this.topicResources = new TopicResources(localMetadataStore);
            this.loadBalanceResources = new LoadBalanceResources((MetadataStore)localMetadataStore, operationTimeoutSec);
        } else {
            this.dynamicConfigResources = null;
            this.localPolicies = null;
            this.loadReportResources = null;
            this.bookieResources = null;
            this.topicResources = null;
            this.loadBalanceResources = null;
        }
        this.localMetadataStore = Optional.ofNullable(localMetadataStore);
        this.configurationMetadataStore = Optional.ofNullable(configurationMetadataStore);
    }

    public static MetadataStoreExtended createLocalMetadataStore(String serverUrls, int sessionTimeoutMs, boolean allowReadOnlyOperations) throws MetadataStoreException {
        return MetadataStoreExtended.create((String)serverUrls, (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis(sessionTimeoutMs).allowReadOnlyOperations(allowReadOnlyOperations).metadataStoreName("metadata-store").build());
    }

    public static MetadataStoreExtended createConfigMetadataStore(String serverUrls, int sessionTimeoutMs, boolean allowReadOnlyOperations) throws MetadataStoreException {
        return MetadataStoreExtended.create((String)serverUrls, (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis(sessionTimeoutMs).allowReadOnlyOperations(allowReadOnlyOperations).metadataStoreName("configuration-metadata-store").build());
    }

    @Generated
    public TenantResources getTenantResources() {
        return this.tenantResources;
    }

    @Generated
    public ClusterResources getClusterResources() {
        return this.clusterResources;
    }

    @Generated
    public ResourceGroupResources getResourcegroupResources() {
        return this.resourcegroupResources;
    }

    @Generated
    public NamespaceResources getNamespaceResources() {
        return this.namespaceResources;
    }

    @Generated
    public DynamicConfigurationResources getDynamicConfigResources() {
        return this.dynamicConfigResources;
    }

    @Generated
    public LocalPoliciesResources getLocalPolicies() {
        return this.localPolicies;
    }

    @Generated
    public LoadManagerReportResources getLoadReportResources() {
        return this.loadReportResources;
    }

    @Generated
    public BookieResources getBookieResources() {
        return this.bookieResources;
    }

    @Generated
    public TopicResources getTopicResources() {
        return this.topicResources;
    }

    @Generated
    public LoadBalanceResources getLoadBalanceResources() {
        return this.loadBalanceResources;
    }

    @Generated
    public Optional<MetadataStoreExtended> getLocalMetadataStore() {
        return this.localMetadataStore;
    }

    @Generated
    public Optional<MetadataStore> getConfigurationMetadataStore() {
        return this.configurationMetadataStore;
    }
}

