/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client;

import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.oxia.client.ClientConfig;
import io.oxia.client.CompareWithSlash;
import io.oxia.client.OptionsUtils;
import io.oxia.client.ProtoUtil;
import io.oxia.client.SequenceUpdates;
import io.oxia.client.api.AsyncOxiaClient;
import io.oxia.client.api.GetResult;
import io.oxia.client.api.Notification;
import io.oxia.client.api.PutResult;
import io.oxia.client.api.RangeScanConsumer;
import io.oxia.client.api.options.DeleteOption;
import io.oxia.client.api.options.DeleteRangeOption;
import io.oxia.client.api.options.GetOption;
import io.oxia.client.api.options.GetSequenceUpdatesOption;
import io.oxia.client.api.options.ListOption;
import io.oxia.client.api.options.PutOption;
import io.oxia.client.api.options.RangeScanOption;
import io.oxia.client.api.options.defs.OptionSecondaryIndex;
import io.oxia.client.batch.BatchManager;
import io.oxia.client.batch.Operation;
import io.oxia.client.grpc.OxiaStub;
import io.oxia.client.grpc.OxiaStubManager;
import io.oxia.client.grpc.OxiaStubProvider;
import io.oxia.client.metrics.Counter;
import io.oxia.client.metrics.InstrumentProvider;
import io.oxia.client.metrics.LatencyHistogram;
import io.oxia.client.metrics.Unit;
import io.oxia.client.metrics.UpDownCounter;
import io.oxia.client.notify.NotificationManager;
import io.oxia.client.options.GetOptions;
import io.oxia.client.session.SessionManager;
import io.oxia.client.shard.ShardManager;
import io.oxia.proto.KeyComparisonType;
import io.oxia.proto.ListRequest;
import io.oxia.proto.ListResponse;
import io.oxia.proto.RangeScanRequest;
import io.oxia.proto.RangeScanResponse;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import lombok.NonNull;

class AsyncOxiaClientImpl
implements AsyncOxiaClient {
    @NonNull
    private final String clientIdentifier;
    @NonNull
    private final InstrumentProvider instrumentProvider;
    @NonNull
    private final OxiaStubManager stubManager;
    @NonNull
    private final ShardManager shardManager;
    @NonNull
    private final NotificationManager notificationManager;
    @NonNull
    private final BatchManager readBatchManager;
    @NonNull
    private final BatchManager writeBatchManager;
    @NonNull
    private final SessionManager sessionManager;
    private final long requestTimeoutMs;
    private volatile boolean closed;
    private final Counter counterPutBytes;
    private final Counter counterGetBytes;
    private final Counter counterListBytes;
    private final Counter counterRangeScanBytes;
    private final UpDownCounter gaugePendingPutRequests;
    private final UpDownCounter gaugePendingGetRequests;
    private final UpDownCounter gaugePendingListRequests;
    private final UpDownCounter gaugePendingRangeScanRequests;
    private final UpDownCounter gaugePendingDeleteRequests;
    private final UpDownCounter gaugePendingDeleteRangeRequests;
    private final UpDownCounter gaugePendingPutBytes;
    private final LatencyHistogram histogramPutLatency;
    private final LatencyHistogram histogramGetLatency;
    private final LatencyHistogram histogramDeleteLatency;
    private final LatencyHistogram histogramDeleteRangeLatency;
    private final LatencyHistogram histogramListLatency;
    private final LatencyHistogram histogramRangeScanLatency;
    private final ScheduledExecutorService scheduledExecutor;

    @NonNull
    static CompletableFuture<AsyncOxiaClient> newInstance(@NonNull ClientConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("oxia-client"));
        OxiaStubManager stubManager = new OxiaStubManager(config);
        InstrumentProvider instrumentProvider = new InstrumentProvider(config.openTelemetry(), config.namespace());
        OxiaStub serviceAddrStub = stubManager.getStub(config.serviceAddress());
        ShardManager shardManager = new ShardManager(executor, serviceAddrStub, instrumentProvider, config.namespace());
        NotificationManager notificationManager = new NotificationManager(executor, stubManager, shardManager, instrumentProvider);
        OxiaStubProvider stubProvider = new OxiaStubProvider(config.namespace(), stubManager, shardManager);
        shardManager.addCallback(notificationManager);
        BatchManager readBatchManager = BatchManager.newReadBatchManager(config, stubProvider, instrumentProvider);
        SessionManager sessionManager = new SessionManager(executor, config, stubProvider, instrumentProvider);
        shardManager.addCallback(sessionManager);
        BatchManager writeBatchManager = BatchManager.newWriteBatchManager(config, stubProvider, sessionManager, instrumentProvider);
        AsyncOxiaClientImpl client = new AsyncOxiaClientImpl(config.clientIdentifier(), executor, instrumentProvider, stubManager, shardManager, notificationManager, readBatchManager, writeBatchManager, sessionManager, config.requestTimeout());
        return shardManager.start().thenApply(v -> client);
    }

    AsyncOxiaClientImpl(@NonNull String clientIdentifier, @NonNull ScheduledExecutorService scheduledExecutor, @NonNull InstrumentProvider instrumentProvider, @NonNull OxiaStubManager stubManager, @NonNull ShardManager shardManager, @NonNull NotificationManager notificationManager, @NonNull BatchManager readBatchManager, @NonNull BatchManager writeBatchManager, @NonNull SessionManager sessionManager, Duration requestTimeout) {
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier is marked non-null but is null");
        }
        if (scheduledExecutor == null) {
            throw new NullPointerException("scheduledExecutor is marked non-null but is null");
        }
        if (instrumentProvider == null) {
            throw new NullPointerException("instrumentProvider is marked non-null but is null");
        }
        if (stubManager == null) {
            throw new NullPointerException("stubManager is marked non-null but is null");
        }
        if (shardManager == null) {
            throw new NullPointerException("shardManager is marked non-null but is null");
        }
        if (notificationManager == null) {
            throw new NullPointerException("notificationManager is marked non-null but is null");
        }
        if (readBatchManager == null) {
            throw new NullPointerException("readBatchManager is marked non-null but is null");
        }
        if (writeBatchManager == null) {
            throw new NullPointerException("writeBatchManager is marked non-null but is null");
        }
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        this.clientIdentifier = clientIdentifier;
        this.instrumentProvider = instrumentProvider;
        this.stubManager = stubManager;
        this.shardManager = shardManager;
        this.notificationManager = notificationManager;
        this.readBatchManager = readBatchManager;
        this.writeBatchManager = writeBatchManager;
        this.sessionManager = sessionManager;
        this.scheduledExecutor = scheduledExecutor;
        this.requestTimeoutMs = requestTimeout.toMillis();
        this.counterPutBytes = instrumentProvider.newCounter("oxia.client.ops.size", Unit.Bytes, "Total number of bytes in operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.counterGetBytes = instrumentProvider.newCounter("oxia.client.ops.size", Unit.Bytes, "Total number of bytes in operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"get"));
        this.counterListBytes = instrumentProvider.newCounter("oxia.client.ops.size", Unit.Bytes, "Total number of bytes in operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"list"));
        this.counterRangeScanBytes = instrumentProvider.newCounter("oxia.client.ops.size", Unit.Bytes, "Total number of bytes in operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"range-scan"));
        this.gaugePendingPutRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.gaugePendingGetRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"get"));
        this.gaugePendingListRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"list"));
        this.gaugePendingRangeScanRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"range-scan"));
        this.gaugePendingDeleteRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete"));
        this.gaugePendingDeleteRangeRequests = instrumentProvider.newUpDownCounter("oxia.client.ops.pending", Unit.Events, "Current number of outstanding requests", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete-range"));
        this.gaugePendingPutBytes = instrumentProvider.newUpDownCounter("oxia.client.ops.outstanding", Unit.Bytes, "Current number of outstanding bytes in put operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.histogramPutLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"put"));
        this.histogramGetLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"get"));
        this.histogramDeleteLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete"));
        this.histogramDeleteRangeLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"delete-range"));
        this.histogramListLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"list"));
        this.histogramRangeScanLatency = instrumentProvider.newLatencyHistogram("oxia.client.ops", "Duration of operations", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"oxia.op"), (Object)"range-scan"));
    }

    @NonNull
    public CompletableFuture<PutResult> put(String key, byte[] value) {
        return this.put(key, value, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<PutResult> put(String key, byte[] value, Set<PutOption> options) {
        CompletableFuture<Object> callback;
        long startTime = System.nanoTime();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            callback = this.internalPut(key, value, options);
        }
        catch (RuntimeException e) {
            callback = CompletableFuture.failedFuture(e);
        }
        return callback.orTimeout(this.requestTimeoutMs, TimeUnit.MILLISECONDS).whenComplete((putResult, throwable) -> {
            this.gaugePendingPutRequests.decrement();
            this.gaugePendingPutBytes.add(-value.length);
            if (throwable == null) {
                this.counterPutBytes.add(value.length);
                this.histogramPutLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramPutLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    private CompletableFuture<PutResult> internalPut(String key, byte[] value, Set<PutOption> options) {
        this.gaugePendingPutRequests.increment();
        this.gaugePendingPutBytes.add(value.length);
        Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
        long shardId = this.shardManager.getShardForKey(partitionKey.orElse(key));
        OptionalLong versionId = OptionsUtils.getVersionId(options);
        Optional<List<Long>> sequenceKeysDeltas = OptionsUtils.getSequenceKeysDeltas(options);
        List<OptionSecondaryIndex> secondaryIndexes = OptionsUtils.getSecondaryIndexes(options);
        CompletableFuture<PutResult> future = new CompletableFuture<PutResult>();
        if (!OptionsUtils.isEphemeral(options)) {
            Operation.WriteOperation.PutOperation op = new Operation.WriteOperation.PutOperation(future, key, partitionKey, sequenceKeysDeltas, value, versionId, OptionalLong.empty(), Optional.empty(), secondaryIndexes);
            this.writeBatchManager.getBatcher(shardId).add(op);
        } else {
            ((CompletableFuture)this.sessionManager.getSession(shardId).thenAccept(session -> {
                Operation.WriteOperation.PutOperation op = new Operation.WriteOperation.PutOperation(future, key, partitionKey, sequenceKeysDeltas, value, versionId, OptionalLong.of(session.getSessionId()), Optional.of(this.clientIdentifier), secondaryIndexes);
                this.writeBatchManager.getBatcher(shardId).add(op);
            })).exceptionally(ex -> {
                future.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        return future.orTimeout(this.requestTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @NonNull
    public CompletableFuture<Boolean> delete(String key) {
        return this.delete(key, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<Boolean> delete(String key, Set<DeleteOption> options) {
        long startTime = System.nanoTime();
        this.gaugePendingDeleteRequests.increment();
        CompletableFuture<Boolean> callback = new CompletableFuture<Boolean>();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(key);
            OptionalLong versionId = OptionsUtils.getVersionId(options);
            Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
            long shardId = this.shardManager.getShardForKey(partitionKey.orElse(key));
            this.writeBatchManager.getBatcher(shardId).add(new Operation.WriteOperation.DeleteOperation(callback, key, versionId));
        }
        catch (RuntimeException e) {
            callback.completeExceptionally(e);
        }
        return callback.orTimeout(this.requestTimeoutMs, TimeUnit.MILLISECONDS).whenComplete((putResult, throwable) -> {
            this.gaugePendingDeleteRequests.decrement();
            if (throwable == null) {
                this.histogramDeleteLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramDeleteLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    @NonNull
    public CompletableFuture<Void> deleteRange(String startKeyInclusive, String endKeyExclusive) {
        return this.deleteRange(startKeyInclusive, endKeyExclusive, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<Void> deleteRange(String startKeyInclusive, String endKeyExclusive, Set<DeleteRangeOption> options) {
        CompletableFuture<Void> callback;
        long startTime = System.nanoTime();
        this.gaugePendingDeleteRangeRequests.increment();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(startKeyInclusive);
            Objects.requireNonNull(endKeyExclusive);
            Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
            if (partitionKey.isPresent()) {
                long shardId = this.shardManager.getShardForKey(partitionKey.get());
                callback = new CompletableFuture();
                this.writeBatchManager.getBatcher(shardId).add(new Operation.WriteOperation.DeleteRangeOperation(callback, startKeyInclusive, endKeyExclusive));
            } else {
                CompletableFuture[] shardDeletes = (CompletableFuture[])this.shardManager.allShardIds().stream().map(this.writeBatchManager::getBatcher).map(b -> {
                    CompletableFuture<Void> shardCallback = new CompletableFuture<Void>();
                    b.add(new Operation.WriteOperation.DeleteRangeOperation(shardCallback, startKeyInclusive, endKeyExclusive));
                    return shardCallback;
                }).toArray(CompletableFuture[]::new);
                callback = CompletableFuture.allOf(shardDeletes);
            }
        }
        catch (RuntimeException e) {
            callback = CompletableFuture.failedFuture(e);
        }
        return callback.orTimeout(this.requestTimeoutMs, TimeUnit.MILLISECONDS).whenComplete((putResult, throwable) -> {
            this.gaugePendingDeleteRangeRequests.decrement();
            if (throwable == null) {
                this.histogramDeleteRangeLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramDeleteRangeLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    @NonNull
    public CompletableFuture<GetResult> get(String key) {
        return this.get(key, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<GetResult> get(String key, Set<GetOption> options) {
        GetOptions internalOptions = GetOptions.parseFrom(options);
        long startTime = System.nanoTime();
        this.gaugePendingGetRequests.increment();
        CompletableFuture<GetResult> callback = new CompletableFuture<GetResult>();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(key);
            this.internalGet(key, internalOptions, callback);
        }
        catch (RuntimeException e) {
            callback.completeExceptionally(e);
        }
        return callback.orTimeout(this.requestTimeoutMs, TimeUnit.MILLISECONDS).whenComplete((getResult, throwable) -> {
            this.gaugePendingGetRequests.decrement();
            if (throwable == null) {
                if (getResult != null) {
                    this.counterGetBytes.add(getResult.value().length);
                }
                this.histogramGetLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramGetLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    private void internalGet(String key, GetOptions options, CompletableFuture<GetResult> result) {
        if (options.partitionKey() == null && (options.comparisonType() != KeyComparisonType.EQUAL || options.secondaryIndexName() != null)) {
            this.internalGetMultiShards(key, options, result);
        } else {
            long shardId = this.shardManager.getShardForKey(Optional.ofNullable(options.partitionKey()).orElse(key));
            this.readBatchManager.getBatcher(shardId).add(new Operation.ReadOperation.GetOperation(result, key, options));
        }
    }

    private void internalGetMultiShards(String key, GetOptions options, CompletableFuture<GetResult> result) {
        ArrayList<CompletableFuture<GetResult>> futures = new ArrayList<CompletableFuture<GetResult>>();
        for (long shardId : this.shardManager.allShardIds()) {
            CompletableFuture<GetResult> f = new CompletableFuture<GetResult>();
            this.readBatchManager.getBatcher(shardId).add(new Operation.ReadOperation.GetOperation(f, key, options));
            futures.add(f);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((v, ex) -> {
            if (ex != null) {
                result.completeExceptionally((Throwable)ex);
                return;
            }
            try {
                List<GetResult> results = futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).sorted((o1, o2) -> CompareWithSlash.INSTANCE.compare(o1.key(), o2.key())).toList();
                if (results.isEmpty()) {
                    result.complete(null);
                    return;
                }
                GetResult gr = switch (options.comparisonType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case KeyComparisonType.EQUAL, KeyComparisonType.CEILING, KeyComparisonType.HIGHER -> results.get(0);
                    case KeyComparisonType.FLOOR, KeyComparisonType.LOWER -> results.get(results.size() - 1);
                    case KeyComparisonType.UNRECOGNIZED -> null;
                };
                result.complete(gr);
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        });
    }

    @NonNull
    public CompletableFuture<List<String>> list(String startKeyInclusive, String endKeyExclusive) {
        return this.list(startKeyInclusive, endKeyExclusive, Collections.emptySet());
    }

    @NonNull
    public CompletableFuture<List<String>> list(String startKeyInclusive, String endKeyExclusive, Set<ListOption> options) {
        CompletableFuture<Object> callback;
        long startTime = System.nanoTime();
        this.gaugePendingListRequests.increment();
        try {
            this.checkIfClosed();
            Objects.requireNonNull(startKeyInclusive);
            Objects.requireNonNull(endKeyExclusive);
            Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
            Optional<String> secondaryIndex = OptionsUtils.getSecondaryIndexName(options);
            if (partitionKey.isPresent()) {
                long shardId = this.shardManager.getShardForKey(partitionKey.get());
                callback = this.internalShardlist(shardId, startKeyInclusive, endKeyExclusive, secondaryIndex);
            } else {
                callback = this.internalListMultiShards(startKeyInclusive, endKeyExclusive, secondaryIndex);
            }
        }
        catch (Exception e) {
            callback = CompletableFuture.failedFuture(e);
        }
        return callback.orTimeout(this.requestTimeoutMs, TimeUnit.MILLISECONDS).whenComplete((listResult, throwable) -> {
            this.gaugePendingListRequests.decrement();
            if (throwable == null) {
                this.counterListBytes.add(listResult.stream().mapToInt(String::length).sum());
                this.histogramListLatency.recordSuccess(System.nanoTime() - startTime);
            } else {
                this.histogramListLatency.recordFailure(System.nanoTime() - startTime);
            }
        });
    }

    public void notifications(@NonNull Consumer<Notification> notificationCallback) {
        if (notificationCallback == null) {
            throw new NullPointerException("notificationCallback is marked non-null but is null");
        }
        this.checkIfClosed();
        this.notificationManager.registerCallback(notificationCallback);
    }

    private CompletableFuture<List<String>> internalListMultiShards(String startKeyInclusive, String endKeyExclusive, Optional<String> secondaryIndex) {
        ArrayList<CompletableFuture<List<String>>> futures = new ArrayList<CompletableFuture<List<String>>>();
        for (long shardId : this.shardManager.allShardIds()) {
            futures.add(this.internalShardlist(shardId, startKeyInclusive, endKeyExclusive, secondaryIndex));
        }
        CompletableFuture<List<String>> result = new CompletableFuture<List<String>>();
        ArrayList list = new ArrayList();
        ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
            for (CompletableFuture future : futures) {
                list.addAll((Collection)future.join());
            }
            list.sort(CompareWithSlash.INSTANCE);
            result.complete(list);
        })).exceptionally(ex -> {
            result.completeExceptionally((Throwable)ex);
            return null;
        });
        return result;
    }

    private CompletableFuture<List<String>> internalShardlist(long shardId, String startKeyInclusive, String endKeyExclusive, Optional<String> secondaryIndexName) {
        String leader = this.shardManager.leader(shardId);
        OxiaStub stub = this.stubManager.getStub(leader);
        ListRequest.Builder requestBuilder = ListRequest.newBuilder().setShard(shardId).setStartInclusive(startKeyInclusive).setEndExclusive(endKeyExclusive);
        secondaryIndexName.ifPresent(requestBuilder::setSecondaryIndexName);
        ListRequest request = requestBuilder.build();
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        final ArrayList result = new ArrayList();
        stub.async().list(request, new StreamObserver<ListResponse>(){

            public void onNext(ListResponse response) {
                for (int i = 0; i < response.getKeysCount(); ++i) {
                    result.add(response.getKeys(i));
                }
            }

            public void onError(Throwable t) {
                future.completeExceptionally(t);
            }

            public void onCompleted() {
                future.complete(result);
            }
        });
        return future;
    }

    public Closeable getSequenceUpdates(@NonNull String key, @NonNull Consumer<String> listener, @NonNull Set<GetSequenceUpdatesOption> options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.checkIfClosed();
        Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
        if (partitionKey.isEmpty()) {
            throw new IllegalArgumentException("partitionKey must be present");
        }
        return new SequenceUpdates(key, partitionKey.get(), listener, this.stubManager, this.shardManager, this.instrumentProvider, x -> this.closed);
    }

    public void rangeScan(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive, @NonNull RangeScanConsumer consumer) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        this.rangeScan(startKeyInclusive, endKeyExclusive, consumer, Collections.emptySet());
    }

    public void rangeScan(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive, final @NonNull RangeScanConsumer consumer, @NonNull Set<RangeScanOption> options) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.gaugePendingRangeScanRequests.increment();
        RangeScanConsumer timedConsumer = new RangeScanConsumer(){
            final long startTime = System.nanoTime();
            final AtomicLong totalSize = new AtomicLong();

            public void onNext(GetResult result) {
                this.totalSize.addAndGet(result.value().length);
                consumer.onNext(result);
            }

            public void onError(Throwable throwable) {
                AsyncOxiaClientImpl.this.gaugePendingRangeScanRequests.decrement();
                AsyncOxiaClientImpl.this.histogramRangeScanLatency.recordFailure(System.nanoTime() - this.startTime);
                consumer.onError(throwable);
            }

            public void onCompleted() {
                AsyncOxiaClientImpl.this.gaugePendingRangeScanRequests.decrement();
                AsyncOxiaClientImpl.this.counterRangeScanBytes.add(this.totalSize.longValue());
                AsyncOxiaClientImpl.this.histogramRangeScanLatency.recordSuccess(System.nanoTime() - this.startTime);
                consumer.onCompleted();
            }
        };
        try {
            this.checkIfClosed();
            Objects.requireNonNull(startKeyInclusive);
            Objects.requireNonNull(endKeyExclusive);
            Optional<String> partitionKey = OptionsUtils.getPartitionKey(options);
            Optional<String> secondaryIndexName = OptionsUtils.getSecondaryIndexName(options);
            if (partitionKey.isPresent()) {
                long shardId = this.shardManager.getShardForKey(partitionKey.get());
                this.internalShardRangeScan(shardId, startKeyInclusive, endKeyExclusive, secondaryIndexName, timedConsumer);
            } else {
                this.internalRangeScanMultiShards(startKeyInclusive, endKeyExclusive, secondaryIndexName, timedConsumer);
            }
        }
        catch (Exception e) {
            consumer.onError((Throwable)e);
        }
    }

    private void internalShardRangeScan(long shardId, String startKeyInclusive, String endKeyExclusive, Optional<String> secondaryIndexName, final RangeScanConsumer consumer) {
        String leader = this.shardManager.leader(shardId);
        OxiaStub stub = this.stubManager.getStub(leader);
        RangeScanRequest.Builder requestBuilder = RangeScanRequest.newBuilder().setShard(shardId).setStartInclusive(startKeyInclusive).setEndExclusive(endKeyExclusive);
        secondaryIndexName.ifPresent(requestBuilder::setSecondaryIndexName);
        RangeScanRequest request = requestBuilder.build();
        stub.async().rangeScan(request, new StreamObserver<RangeScanResponse>(){

            public void onNext(RangeScanResponse response) {
                for (int i = 0; i < response.getRecordsCount(); ++i) {
                    consumer.onNext(ProtoUtil.getResultFromProto("", response.getRecords(i)));
                }
            }

            public void onError(Throwable t) {
                consumer.onError(t);
            }

            public void onCompleted() {
                consumer.onCompleted();
            }
        });
    }

    private void internalRangeScanMultiShards(String startKeyInclusive, String endKeyExclusive, Optional<String> secondaryIndexName, RangeScanConsumer consumer) {
        Set<Long> shardIds = this.shardManager.allShardIds();
        SharedRangeScanConsumer multiShardConsumer = new SharedRangeScanConsumer(shardIds.size(), consumer);
        for (long shardId : shardIds) {
            this.internalShardRangeScan(shardId, startKeyInclusive, endKeyExclusive, secondaryIndexName, multiShardConsumer);
        }
    }

    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.readBatchManager.close();
        this.writeBatchManager.close();
        this.sessionManager.close();
        this.notificationManager.close();
        this.shardManager.close();
        this.stubManager.close();
        this.scheduledExecutor.shutdownNow();
    }

    private void checkIfClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client has been closed");
        }
    }

    static class SharedRangeScanConsumer
    implements RangeScanConsumer {
        private final RangeScanConsumer delegate;
        private int pendingCompletedRequests;
        private boolean completed = false;
        private Throwable completedException = null;

        SharedRangeScanConsumer(int shards, RangeScanConsumer delegate) {
            this.pendingCompletedRequests = shards;
            this.delegate = delegate;
        }

        public synchronized void onNext(GetResult result) {
            if (this.completed) {
                return;
            }
            this.delegate.onNext(result);
        }

        public synchronized void onError(Throwable throwable) {
            if (this.completedException == null) {
                this.completedException = throwable;
            } else {
                this.completedException.addSuppressed(throwable);
            }
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.delegate.onError(throwable);
        }

        public synchronized void onCompleted() {
            if (this.completed) {
                return;
            }
            --this.pendingCompletedRequests;
            if (this.pendingCompletedRequests == 0) {
                this.completed = true;
                this.delegate.onCompleted();
            }
        }
    }
}

