/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.bookkeeper.mledger.impl.cache.RangeCacheRemovalQueue;
import org.apache.bookkeeper.mledger.impl.cache.RangeEntryCacheManagerImpl;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RangeEntryCacheManagerEvictionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RangeEntryCacheManagerEvictionHandler.class);
    private final RangeEntryCacheManagerImpl manager;
    private final RangeCacheRemovalQueue rangeCacheRemovalQueue;

    public RangeEntryCacheManagerEvictionHandler(RangeEntryCacheManagerImpl manager, RangeCacheRemovalQueue rangeCacheRemovalQueue) {
        this.manager = manager;
        this.rangeCacheRemovalQueue = rangeCacheRemovalQueue;
    }

    public void invalidateEntriesBeforeTimestampNanos(long timestamp) {
        Pair<Integer, Long> evictedPair = this.rangeCacheRemovalQueue.evictLEntriesBeforeTimestamp(timestamp);
        this.manager.entriesRemoved((Long)evictedPair.getRight(), (Integer)evictedPair.getLeft());
    }

    public Pair<Integer, Long> evictEntries(long sizeToFree) {
        Preconditions.checkArgument((sizeToFree > 0L ? 1 : 0) != 0);
        Pair<Integer, Long> evicted = this.rangeCacheRemovalQueue.evictLeastAccessedEntries(sizeToFree);
        int evictedEntries = (Integer)evicted.getLeft();
        long evictedSize = (Long)evicted.getRight();
        if (log.isDebugEnabled()) {
            log.debug("Doing cache eviction of at least {} Mb -- Deleted {} entries - Total size deleted: {} Mb  -- Current Size: {} Mb", new Object[]{(double)sizeToFree / 1048576.0, evictedEntries, (double)evictedSize / 1048576.0, (double)this.manager.getSize() / 1048576.0});
        }
        this.manager.entriesRemoved(evictedSize, evictedEntries);
        return evicted;
    }

    @VisibleForTesting
    public Pair<Integer, Long> getNonEvictableSize() {
        return this.rangeCacheRemovalQueue.getNonEvictableSize();
    }
}

