/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import java.security.AccessController;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.management.plugin.controller.ConverterHelper;
import org.apache.qpid.server.management.plugin.servlet.rest.NotFoundException;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.OperationTimeoutException;
import org.apache.qpid.server.util.ExternalServiceException;
import org.apache.qpid.server.util.ExternalServiceTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementException
extends RuntimeException {
    private static final int SC_UNPROCESSABLE_ENTITY = 422;
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementException.class);
    private final int _statusCode;
    private final Map<String, String> _headers;

    private ManagementException(int statusCode, String message, Map<String, String> headers) {
        super(message);
        this._statusCode = statusCode;
        this._headers = headers;
    }

    private ManagementException(int statusCode, String message, Throwable cause, Map<String, String> headers) {
        super(message, cause);
        this._statusCode = statusCode;
        this._headers = headers;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    public static ManagementException createNotFoundManagementException(Exception e) {
        return new ManagementException(404, e.getMessage(), e, null);
    }

    public static ManagementException createNotFoundManagementException(String message) {
        return new ManagementException(404, message, null);
    }

    public static ManagementException createGoneManagementException(String message) {
        return new ManagementException(410, message, null);
    }

    public static ManagementException createUnprocessableManagementException(String message) {
        return new ManagementException(422, message, null);
    }

    public static ManagementException createUnprocessableManagementException(Exception e) {
        return new ManagementException(422, e.getMessage(), e, null);
    }

    private static ManagementException createConflictManagementException(Exception e) {
        return new ManagementException(409, e.getMessage(), e, null);
    }

    public static ManagementException createNotAllowedManagementException(String message, Map<String, String> headers) {
        return new ManagementException(405, message, headers);
    }

    public static ManagementException createForbiddenManagementException(String message) {
        return new ManagementException(403, message, null);
    }

    public static ManagementException createForbiddenManagementException(Exception e) {
        return new ManagementException(403, e.getMessage(), e, null);
    }

    public static ManagementException createInternalServerErrorManagementException(String message) {
        return new ManagementException(500, message, null);
    }

    public static ManagementException createInternalServerErrorManagementException(String message, Exception e) {
        return new ManagementException(500, message, e, null);
    }

    private static ManagementException createBadGatewayManagementException(String message, RuntimeException e) {
        return new ManagementException(502, message, e, null);
    }

    private static ManagementException createGatewayTimeoutManagementException(RuntimeException e) {
        return new ManagementException(504, e.getMessage(), e, null);
    }

    public static ManagementException createBadRequestManagementException(String message) {
        return new ManagementException(400, message, null);
    }

    public static ManagementException createBadRequestManagementException(String message, Throwable e) {
        return new ManagementException(400, message, e, null);
    }

    public static ManagementException toManagementException(RuntimeException e, String categoryMapping, List<String> path) {
        if (e instanceof SecurityException) {
            LOGGER.debug("{}, sending {}", new Object[]{e.getClass().getName(), 403, e});
            return ManagementException.createForbiddenManagementException(e);
        }
        if (e instanceof AbstractConfiguredObject.DuplicateIdException || e instanceof AbstractConfiguredObject.DuplicateNameException || e instanceof IntegrityViolationException || e instanceof IllegalStateTransitionException) {
            return ManagementException.createConflictManagementException(e);
        }
        if (e instanceof NotFoundException) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(e.getClass().getSimpleName() + " processing request", (Throwable)e);
            }
            return ManagementException.createNotFoundManagementException(e);
        }
        if (e instanceof IllegalConfigurationException || e instanceof IllegalArgumentException) {
            LOGGER.info("{} processing request {} from user '{}': {}", new Object[]{e.getClass().getSimpleName(), ManagementException.getRequestURI(path, categoryMapping), ManagementException.getRequestPrincipals(), e.getMessage()});
            Throwable t = e;
            int maxDepth = 10;
            while ((t = t.getCause()) != null && maxDepth-- != 0) {
                LOGGER.info("... caused by " + t.getClass().getSimpleName() + "  : " + t.getMessage());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getClass().getSimpleName() + " processing request", (Throwable)e);
            }
            return ManagementException.createUnprocessableManagementException(e);
        }
        if (e instanceof OperationTimeoutException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Timeout during processing of request {} from user '{}'", new Object[]{ManagementException.getRequestURI(path, categoryMapping), ManagementException.getRequestPrincipals(), e});
            } else {
                LOGGER.info("Timeout during processing of request {} from user '{}'", (Object)ManagementException.getRequestURI(path, categoryMapping), (Object)ManagementException.getRequestPrincipals());
            }
            return ManagementException.createBadGatewayManagementException("Timeout occurred", e);
        }
        if (e instanceof ExternalServiceTimeoutException) {
            LOGGER.warn("External request timeout ", (Throwable)e);
            return ManagementException.createGatewayTimeoutManagementException(e);
        }
        if (e instanceof ExternalServiceException) {
            LOGGER.warn("External request failed ", (Throwable)e);
            return ManagementException.createBadGatewayManagementException(e.getMessage(), e);
        }
        if (e instanceof ManagementException) {
            return (ManagementException)e;
        }
        LOGGER.warn("Unexpected Exception", (Throwable)e);
        return ManagementException.createInternalServerErrorManagementException("Unexpected Exception", e);
    }

    public static ManagementException handleError(Error e) {
        if (e instanceof NoClassDefFoundError) {
            LOGGER.warn("Unexpected exception processing request ", (Throwable)e);
            return ManagementException.createBadRequestManagementException("Not found: " + e.getMessage(), e);
        }
        throw e;
    }

    public static String getRequestURI(List<String> path, String categoryMapping) {
        return categoryMapping + (categoryMapping.endsWith("/") ? "" : "/") + path.stream().map(ConverterHelper::encode).collect(Collectors.joining("/"));
    }

    private static String getRequestPrincipals() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            return null;
        }
        Set<Principal> principalSet = subject.getPrincipals();
        return String.join((CharSequence)"/", principalSet.stream().map(Principal::getName).collect(Collectors.toCollection(TreeSet::new)));
    }
}

