/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import jakarta.servlet.http.HttpServletRequest;
import javax.security.auth.Subject;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestPreemptiveAuthenticator;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.manager.AnonymousAuthenticationManager;

@PluggableService
public class AnonymousPreemptiveAuthenticator
implements HttpRequestPreemptiveAuthenticator {
    private static final String ANONYMOUS = "Anonymous";

    @Override
    public Subject attemptAuthentication(HttpServletRequest request, HttpManagementConfiguration managementConfig) {
        Port<?> port = managementConfig.getPort(request);
        AuthenticationProvider authenticationProvider = managementConfig.getAuthenticationProvider(request);
        SubjectCreator subjectCreator = port.getSubjectCreator(request.isSecure(), request.getServerName());
        if (authenticationProvider instanceof AnonymousAuthenticationManager) {
            return subjectCreator.createResultWithGroups(((AnonymousAuthenticationManager)authenticationProvider).getAnonymousAuthenticationResult()).getSubject();
        }
        return null;
    }

    public String getType() {
        return ANONYMOUS;
    }
}

