/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Collection;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.config.RuleInspector;
import org.apache.qpid.server.security.access.config.RuleSetBuilder;

public interface RuleSet
extends EventLoggerProvider,
List<Rule>,
RuleInspector {
    @Override
    public Result check(Subject var1, LegacyOperation var2, ObjectType var3, ObjectProperties var4);

    default public Result getDefault() {
        return Result.DENIED;
    }

    public static Builder newBuilder(EventLoggerProvider eventLogger) {
        return new RuleSetBuilder(eventLogger);
    }

    public static RuleSet newInstance(EventLoggerProvider eventLogger, Collection<? extends Rule> rules, Result defaultResult) {
        return RuleSet.newBuilder(eventLogger).addAllRules(rules).setDefaultResult(defaultResult).build();
    }

    public static interface Builder {
        public Builder setDefaultResult(Result var1);

        public Builder addAllRules(Collection<? extends Rule> var1);

        public RuleSet build();
    }
}

