/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.AMQPFilterTypes;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.filter.selector.ParseException;
import org.apache.qpid.server.filter.selector.TokenMgrError;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.queue.QueueConsumer;

public class FilterSupport {
    private static final Map<String, WeakReference<JMSSelectorFilter>> _selectorCache = Collections.synchronizedMap(new WeakHashMap());

    static MessageFilter createJMSSelectorFilter(Map<String, Object> args) throws AMQInvalidArgumentException {
        String selectorString = (String)args.get(AMQPFilterTypes.JMS_SELECTOR.toString());
        return FilterSupport.getMessageFilter(selectorString);
    }

    private static MessageFilter getMessageFilter(String selectorString) throws AMQInvalidArgumentException {
        WeakReference<JMSSelectorFilter> selectorRef = _selectorCache.get(selectorString);
        JMSSelectorFilter selector = null;
        if (selectorRef == null || (selector = (JMSSelectorFilter)selectorRef.get()) == null) {
            try {
                selector = new JMSSelectorFilter(selectorString);
            }
            catch (SelectorParsingException | ParseException | TokenMgrError e) {
                throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + selectorString + "\"", e);
            }
            _selectorCache.put(selectorString, new WeakReference<JMSSelectorFilter>(selector));
        }
        return selector;
    }

    public static boolean argumentsContainFilter(Map<String, Object> args) {
        return FilterSupport.argumentsContainNoLocal(args) || FilterSupport.argumentsContainJMSSelector(args);
    }

    public static void removeFilters(Map<String, Object> args) {
        args.remove(AMQPFilterTypes.JMS_SELECTOR.toString());
        args.remove(AMQPFilterTypes.NO_LOCAL.toString());
    }

    static boolean argumentsContainNoLocal(Map<String, Object> args) {
        return args != null && args.containsKey(AMQPFilterTypes.NO_LOCAL.toString()) && Boolean.TRUE.equals(args.get(AMQPFilterTypes.NO_LOCAL.toString()));
    }

    static boolean argumentsContainJMSSelector(Map<String, Object> args) {
        return args != null && args.get(AMQPFilterTypes.JMS_SELECTOR.toString()) instanceof String && ((String)args.get(AMQPFilterTypes.JMS_SELECTOR.toString())).trim().length() != 0;
    }

    public static FilterManager createMessageFilter(Map<String, Object> args, MessageDestination queue) throws AMQInvalidArgumentException {
        FilterManager filterManager = null;
        if (FilterSupport.argumentsContainNoLocal(args) && queue instanceof Queue) {
            filterManager = new FilterManager();
            filterManager.add(AMQPFilterTypes.NO_LOCAL.toString(), new NoLocalFilter((Queue)queue));
        }
        if (FilterSupport.argumentsContainJMSSelector(args)) {
            if (filterManager == null) {
                filterManager = new FilterManager();
            }
            filterManager.add(AMQPFilterTypes.JMS_SELECTOR.toString(), FilterSupport.createJMSSelectorFilter(args));
        }
        return filterManager;
    }

    @PluggableService
    public static final class NoLocalFilter
    implements MessageFilter {
        private final Queue<?> _queue;

        private NoLocalFilter(Queue<?> queue) {
            this._queue = queue;
        }

        @Override
        public String getName() {
            return AMQPFilterTypes.NO_LOCAL.toString();
        }

        @Override
        public boolean matches(Filterable message) {
            Collection<QueueConsumer<?, ?>> consumers = this._queue.getConsumers();
            for (QueueConsumer<?, ?> c : consumers) {
                if (c.getSession().getConnectionReference() != message.getConnectionReference()) continue;
                return false;
            }
            return !consumers.isEmpty();
        }

        @Override
        public boolean startAtTail() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NoLocalFilter that = (NoLocalFilter)o;
            return this._queue == null ? that._queue == null : this._queue.equals(that._queue);
        }

        public int hashCode() {
            return this._queue != null ? this._queue.hashCode() : 0;
        }

        public String toString() {
            return "NoLocalFilter[]";
        }
    }
}

