/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.transport.NonBlockingConnection;
import org.apache.qpid.server.transport.NonBlockingConnectionDelegate;
import org.apache.qpid.server.transport.network.TransportEncryption;

public class NonBlockingConnectionUndecidedDelegate
implements NonBlockingConnectionDelegate {
    private static final int NUMBER_OF_BYTES_FOR_TLS_CHECK = 6;
    public final NonBlockingConnection _parent;
    private QpidByteBuffer _netInputBuffer;

    public NonBlockingConnectionUndecidedDelegate(NonBlockingConnection parent) {
        this._parent = parent;
        this._netInputBuffer = QpidByteBuffer.allocateDirect(6);
    }

    @Override
    public boolean readyForRead() {
        return true;
    }

    @Override
    public boolean processData() throws IOException {
        try (QpidByteBuffer buffer = this._netInputBuffer.duplicate();){
            boolean hasSufficientData;
            buffer.flip();
            boolean bl = hasSufficientData = buffer.remaining() >= 6;
            if (hasSufficientData) {
                byte[] headerBytes = new byte[6];
                buffer.get(headerBytes);
                if (this.looksLikeSSL(headerBytes)) {
                    this._parent.setTransportEncryption(TransportEncryption.TLS);
                } else {
                    this._parent.setTransportEncryption(TransportEncryption.NONE);
                }
            }
            boolean bl2 = hasSufficientData;
            return bl2;
        }
    }

    @Override
    public NonBlockingConnectionDelegate.WriteResult doWrite(Collection<QpidByteBuffer> buffers) throws IOException {
        return new NonBlockingConnectionDelegate.WriteResult(true, 0L);
    }

    @Override
    public Principal getPeerPrincipal() {
        return null;
    }

    @Override
    public Certificate getPeerCertificate() {
        return null;
    }

    @Override
    public boolean needsWork() {
        return false;
    }

    private boolean looksLikeSSL(byte[] headerBytes) {
        return this.looksLikeSSLv3ClientHello(headerBytes) || this.looksLikeSSLv2ClientHello(headerBytes);
    }

    private boolean looksLikeSSLv3ClientHello(byte[] headerBytes) {
        return headerBytes[0] == 22 && headerBytes[1] == 3 && (headerBytes[2] == 0 || headerBytes[2] == 1 || headerBytes[2] == 2 || headerBytes[2] == 3) && headerBytes[5] == 1;
    }

    private boolean looksLikeSSLv2ClientHello(byte[] headerBytes) {
        return headerBytes[0] == -128 && headerBytes[3] == 3 && (headerBytes[4] == 0 || headerBytes[4] == 1 || headerBytes[4] == 2 || headerBytes[4] == 3);
    }

    @Override
    public QpidByteBuffer getNetInputBuffer() {
        return this._netInputBuffer;
    }

    @Override
    public void shutdownInput() {
        if (this._netInputBuffer != null) {
            this._netInputBuffer.dispose();
            this._netInputBuffer = null;
        }
    }

    @Override
    public void shutdownOutput() {
    }

    @Override
    public String getTransportInfo() {
        return "";
    }
}

