/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsObjectMessageFacade;
import org.apache.qpid.jms.util.TypeConversionSupport;

public class AmqpJmsMessagePropertyIntercepter {
    private static final Map<String, PropertyIntercepter> PROPERTY_INTERCEPTERS = new HashMap<String, PropertyIntercepter>();

    public static Object getProperty(AmqpJmsMessageFacade message, String name) throws JMSException {
        Object value = null;
        PropertyIntercepter propertyExpression = PROPERTY_INTERCEPTERS.get(name);
        value = propertyExpression != null ? propertyExpression.getProperty(message) : message.getApplicationProperty(name);
        return value;
    }

    public static void setProperty(AmqpJmsMessageFacade message, String name, Object value) throws JMSException {
        PropertyIntercepter propertyExpression = PROPERTY_INTERCEPTERS.get(name);
        if (propertyExpression != null) {
            propertyExpression.setProperty(message, value);
        } else {
            message.setApplicationProperty(name, value);
        }
    }

    public static boolean propertyExists(AmqpJmsMessageFacade message, String name) throws JMSException {
        PropertyIntercepter propertyExpression = PROPERTY_INTERCEPTERS.get(name);
        if (propertyExpression != null) {
            return propertyExpression.propertyExists(message);
        }
        return message.applicationPropertyExists(name);
    }

    public static Set<String> getAllPropertyNames() {
        return PROPERTY_INTERCEPTERS.keySet();
    }

    public static Set<String> getPropertyNames(AmqpJmsMessageFacade message) {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry<String, PropertyIntercepter> entry : PROPERTY_INTERCEPTERS.entrySet()) {
            if (!entry.getValue().propertyExists(message)) continue;
            names.add(entry.getKey());
        }
        return message.getApplicationPropertyNames(names);
    }

    public static void clearProperties(AmqpJmsMessageFacade message) throws JMSException {
        for (Map.Entry<String, PropertyIntercepter> entry : PROPERTY_INTERCEPTERS.entrySet()) {
            entry.getValue().clearProperty(message);
        }
        message.clearAllApplicationProperties();
    }

    static {
        PROPERTY_INTERCEPTERS.put("JMS_AMQP_TTL", new PropertyIntercepter(){

            @Override
            public Object getProperty(AmqpJmsMessageFacade message) throws JMSException {
                if (message.hasAmqpTimeToLiveOverride()) {
                    return message.getAmqpTimeToLiveOverride();
                }
                return null;
            }

            @Override
            public void setProperty(AmqpJmsMessageFacade message, Object value) throws JMSException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new JMSException("Property JMS_AMQP_TTL cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setAmqpTimeToLiveOverride(rc);
            }

            @Override
            public boolean propertyExists(AmqpJmsMessageFacade message) {
                return message.hasAmqpTimeToLiveOverride();
            }

            @Override
            public void clearProperty(AmqpJmsMessageFacade message) throws JMSException {
                message.setAmqpTimeToLiveOverride(null);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMS_AMQP_REPLY_TO_GROUP_ID", new PropertyIntercepter(){

            @Override
            public Object getProperty(AmqpJmsMessageFacade message) throws JMSException {
                return message.getReplyToGroupId();
            }

            @Override
            public void setProperty(AmqpJmsMessageFacade message, Object value) throws JMSException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new JMSException("Property JMS_AMQP_REPLY_TO_GROUP_ID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.setReplyToGroupId(rc);
            }

            @Override
            public boolean propertyExists(AmqpJmsMessageFacade message) {
                String replyToGroupId = message.getReplyToGroupId();
                return replyToGroupId != null && !replyToGroupId.equals("");
            }

            @Override
            public void clearProperty(AmqpJmsMessageFacade message) throws JMSException {
                message.setReplyToGroupId(null);
            }
        });
        PROPERTY_INTERCEPTERS.put("JMS_AMQP_TYPED_ENCODING", new PropertyIntercepter(){

            @Override
            public Object getProperty(AmqpJmsMessageFacade message) throws JMSException {
                if (message instanceof AmqpJmsObjectMessageFacade) {
                    return ((AmqpJmsObjectMessageFacade)message).isAmqpTypedEncoding();
                }
                return null;
            }

            @Override
            public void setProperty(AmqpJmsMessageFacade message, Object value) throws JMSException {
                Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                if (rc == null) {
                    throw new JMSException("Property JMS_AMQP_TYPED_ENCODING cannot be set from a " + value.getClass().getName() + ".");
                }
                if (!(message instanceof AmqpJmsObjectMessageFacade)) {
                    throw new MessageFormatException("JMS_AMQP_TYPED_ENCODING is only applicable to ObjectMessage");
                }
                ((AmqpJmsObjectMessageFacade)message).setUseAmqpTypedEncoding(rc);
            }

            @Override
            public boolean propertyExists(AmqpJmsMessageFacade message) {
                if (message instanceof AmqpJmsObjectMessageFacade) {
                    return ((AmqpJmsObjectMessageFacade)message).isAmqpTypedEncoding();
                }
                return false;
            }

            @Override
            public void clearProperty(AmqpJmsMessageFacade message) throws JMSException {
            }
        });
    }

    static interface PropertyIntercepter {
        public Object getProperty(AmqpJmsMessageFacade var1) throws JMSException;

        public void setProperty(AmqpJmsMessageFacade var1, Object var2) throws JMSException;

        public boolean propertyExists(AmqpJmsMessageFacade var1);

        public void clearProperty(AmqpJmsMessageFacade var1) throws JMSException;
    }
}

