/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import jakarta.jms.ConnectionConsumer;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.ServerSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsMessageDispatcher;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.JmsMessageSupport;
import org.apache.qpid.jms.meta.JmsConsumerInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.policy.JmsRedeliveryPolicy;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.apache.qpid.jms.util.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConnectionConsumer
implements ConnectionConsumer,
JmsMessageDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(JmsConnectionConsumer.class);
    private static final long DEFAULT_DISPATCH_RETRY_DELAY = 1000L;
    private final JmsConnection connection;
    private final JmsConsumerInfo consumerInfo;
    private final ServerSessionPool sessionPool;
    private final MessageQueue messageQueue;
    private final Lock stateLock = new ReentrantLock();
    private final Lock dispatchLock = new ReentrantLock();
    private final ReadWriteLock deliveringLock = new ReentrantReadWriteLock(true);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicReference<Throwable> failureCause = new AtomicReference();
    private final ScheduledThreadPoolExecutor dispatcher;

    public JmsConnectionConsumer(final JmsConnection connection, final JmsConsumerInfo consumerInfo, MessageQueue messageQueue, ServerSessionPool sessionPool) throws JMSException {
        this.connection = connection;
        this.consumerInfo = consumerInfo;
        this.sessionPool = sessionPool;
        this.messageQueue = messageQueue;
        this.dispatcher = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
            final /* synthetic */ JmsConnectionConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Thread newThread(Runnable runner) {
                Thread serial = new Thread(runner);
                serial.setDaemon(true);
                serial.setName(this.getClass().getSimpleName() + ":(" + String.valueOf(consumerInfo.getId()) + ")");
                return serial;
            }
        });
        this.dispatcher.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.dispatcher.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        connection.createResource(consumerInfo, new ProviderSynchronization(){
            final /* synthetic */ JmsConnectionConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onPendingSuccess() {
                connection.addConnectionConsumer(consumerInfo, this.this$0);
            }

            @Override
            public void onPendingFailure(ProviderException cause) {
            }
        });
    }

    public JmsConnectionConsumer init() throws JMSException {
        this.getConnection().startResource(this.consumerInfo);
        return this;
    }

    @Override
    public void onInboundMessage(JmsInboundMessageDispatch envelope) {
        envelope.setConsumerInfo(this.consumerInfo);
        this.stateLock.lock();
        try {
            if (envelope.isEnqueueFirst()) {
                this.messageQueue.enqueueFirst(envelope);
            } else {
                this.messageQueue.enqueue(envelope);
            }
            if (this.messageQueue.isRunning()) {
                try {
                    this.dispatcher.execute(() -> this.deliverNextPending());
                }
                catch (RejectedExecutionException rje) {
                    LOG.debug("Rejected on attempt to queue message dispatch", (Throwable)rje);
                }
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void close() throws JMSException {
        if (!this.closed.get()) {
            this.doClose();
        }
    }

    protected void doClose() throws JMSException {
        this.deliveringLock.writeLock().lock();
        try {
            this.shutdown();
            this.connection.destroyResource(this.consumerInfo);
        }
        finally {
            this.deliveringLock.writeLock().unlock();
        }
    }

    protected void shutdown() throws JMSException {
        this.shutdown(null);
    }

    protected void shutdown(Throwable cause) throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.dispatchLock.lock();
            try {
                this.failureCause.set(cause);
                this.consumerInfo.setState(JmsResource.ResourceState.CLOSED);
                this.connection.removeConnectionConsumer(this.consumerInfo);
                this.stop(true);
                this.dispatcher.shutdown();
                try {
                    this.dispatcher.awaitTermination(this.connection.getCloseTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    LOG.trace("ConnectionConsumer shutdown of dispatcher was interupted");
                }
            }
            finally {
                this.dispatchLock.unlock();
            }
        }
    }

    public void start() {
        this.stateLock.lock();
        try {
            if (!this.messageQueue.isRunning()) {
                this.messageQueue.start();
                this.dispatcher.execute(new BoundedMessageDeliverTask(this.messageQueue.size()));
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void stop() {
        this.stop(false);
    }

    private void stop(boolean closeMessageQueue) {
        this.dispatchLock.lock();
        this.stateLock.lock();
        try {
            if (closeMessageQueue) {
                this.messageQueue.close();
            } else {
                this.messageQueue.stop();
            }
        }
        finally {
            this.stateLock.unlock();
            this.dispatchLock.unlock();
        }
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        this.checkClosed();
        return this.sessionPool;
    }

    JmsConnection getConnection() {
        return this.connection;
    }

    JmsConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    void setFailureCause(Throwable failureCause) {
        this.failureCause.set(failureCause);
    }

    Throwable getFailureCause() {
        return this.failureCause.get();
    }

    public String toString() {
        return "JmsConnectionConsumer { id=" + String.valueOf(this.consumerInfo.getId()) + " }";
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            IllegalStateException jmsEx = null;
            if (this.getFailureCause() == null) {
                jmsEx = new IllegalStateException("The ConnectionConsumer is closed");
            } else {
                jmsEx = new IllegalStateException("The ConnectionConsumer was closed due to an unrecoverable error.");
                jmsEx.initCause(this.getFailureCause());
            }
            throw jmsEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliverNextPending() {
        if (this.messageQueue.isRunning() && !this.messageQueue.isEmpty()) {
            this.dispatchLock.lock();
            try {
                ServerSession serverSession = this.getServerSessionPool().getServerSession();
                if (serverSession == null) {
                    this.dispatcher.schedule(new BoundedMessageDeliverTask(this.messageQueue.size()), 1000L, TimeUnit.MILLISECONDS);
                    boolean bl = false;
                    return bl;
                }
                Session session = serverSession.getSession();
                JmsInboundMessageDispatch envelope = this.messageQueue.dequeueNoWait();
                if (session instanceof JmsSession) {
                    ((JmsSession)session).enqueueInSession(new DeliveryTask(envelope));
                } else {
                    LOG.warn("ServerSession provided an unknown JMS Session type to this ConnectionConsumer: {}", (Object)session);
                }
                serverSession.start();
            }
            catch (JMSException e) {
                this.connection.onAsyncException(e);
                this.stop(true);
            }
            finally {
                this.dispatchLock.unlock();
            }
        }
        return !this.messageQueue.isEmpty();
    }

    private final class BoundedMessageDeliverTask
    implements Runnable {
        private final int deliveryCount;

        public BoundedMessageDeliverTask(int deliveryCount) {
            this.deliveryCount = deliveryCount;
        }

        @Override
        public void run() {
            int current = 0;
            while (JmsConnectionConsumer.this.messageQueue.isRunning() && current++ < this.deliveryCount) {
                if (JmsConnectionConsumer.this.deliverNextPending()) continue;
                return;
            }
        }
    }

    private final class DeliveryTask
    implements Consumer<JmsSession> {
        private final JmsInboundMessageDispatch envelope;

        public DeliveryTask(JmsInboundMessageDispatch envelope) {
            this.envelope = envelope;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(JmsSession session) {
            block14: {
                JmsConnectionConsumer.this.deliveringLock.readLock().lock();
                try {
                    if (JmsConnectionConsumer.this.closed.get()) {
                        return;
                    }
                    JmsMessage copy = null;
                    if (this.envelope.getMessage().isExpired()) {
                        LOG.trace("{} filtered expired message: {}", (Object)this.envelope.getConsumerId(), (Object)this.envelope);
                        session.acknowledge(this.envelope, ProviderConstants.ACK_TYPE.MODIFIED_FAILED_UNDELIVERABLE);
                        break block14;
                    }
                    if (session.redeliveryExceeded(this.envelope)) {
                        LOG.trace("{} filtered message with excessive redelivery count: {}", (Object)this.envelope.getConsumerId(), (Object)this.envelope);
                        JmsRedeliveryPolicy redeliveryPolicy = this.envelope.getConsumerInfo().getRedeliveryPolicy();
                        session.acknowledge(this.envelope, JmsMessageSupport.lookupAckTypeForDisposition(redeliveryPolicy.getOutcome(this.envelope.getConsumerInfo().getDestination())));
                        break block14;
                    }
                    boolean deliveryFailed = false;
                    copy = session.acknowledge(this.envelope, ProviderConstants.ACK_TYPE.DELIVERED).getMessage().copy();
                    session.clearSessionRecovered();
                    try {
                        session.getMessageListener().onMessage((Message)copy);
                    }
                    catch (RuntimeException rte) {
                        deliveryFailed = true;
                    }
                    if (!session.isSessionRecovered()) {
                        if (!deliveryFailed) {
                            session.acknowledge(this.envelope, ProviderConstants.ACK_TYPE.ACCEPTED);
                        } else {
                            session.acknowledge(this.envelope, ProviderConstants.ACK_TYPE.RELEASED);
                        }
                    }
                }
                catch (Exception e) {
                    JmsConnectionConsumer.this.getConnection().onAsyncException(e);
                }
                finally {
                    JmsConnectionConsumer.this.deliveringLock.readLock().unlock();
                }
            }
        }
    }
}

