/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.provider;

import java.lang.reflect.Constructor;
import org.apache.rocketmq.tieredstore.MessageStoreConfig;
import org.apache.rocketmq.tieredstore.MessageStoreExecutor;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.metadata.MetadataStore;
import org.apache.rocketmq.tieredstore.provider.FileSegment;

public class FileSegmentFactory {
    private final MetadataStore metadataStore;
    private final MessageStoreConfig storeConfig;
    private final MessageStoreExecutor executor;
    private final Constructor<? extends FileSegment> fileSegmentConstructor;

    public FileSegmentFactory(MetadataStore metadataStore, MessageStoreConfig storeConfig, MessageStoreExecutor executor) {
        try {
            this.storeConfig = storeConfig;
            this.metadataStore = metadataStore;
            this.executor = executor;
            Class<FileSegment> clazz = Class.forName(storeConfig.getTieredBackendServiceProvider()).asSubclass(FileSegment.class);
            this.fileSegmentConstructor = clazz.getConstructor(MessageStoreConfig.class, FileSegmentType.class, String.class, Long.TYPE, MessageStoreExecutor.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    public MessageStoreConfig getStoreConfig() {
        return this.storeConfig;
    }

    public FileSegment createSegment(FileSegmentType fileType, String filePath, long baseOffset) {
        try {
            return this.fileSegmentConstructor.newInstance(new Object[]{this.storeConfig, fileType, filePath, baseOffset, this.executor});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FileSegment createCommitLogFileSegment(String filePath, long baseOffset) {
        return this.createSegment(FileSegmentType.COMMIT_LOG, filePath, baseOffset);
    }

    public FileSegment createConsumeQueueFileSegment(String filePath, long baseOffset) {
        return this.createSegment(FileSegmentType.CONSUME_QUEUE, filePath, baseOffset);
    }

    public FileSegment createIndexServiceFileSegment(String filePath, long baseOffset) {
        return this.createSegment(FileSegmentType.INDEX, filePath, baseOffset);
    }
}

