/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventListener;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.ConnectionManager;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.ReconnectManager;
import com.alipay.remoting.Reconnector;
import com.alipay.remoting.Url;
import com.alipay.remoting.config.BoltClientOption;
import com.alipay.remoting.config.Configuration;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.RemotingUtil;
import com.alipay.remoting.util.StringUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class ConnectionEventHandler
extends ChannelDuplexHandler {
    private static final Logger logger = BoltLoggerFactory.getLogger("ConnectionEvent");
    private ConnectionManager connectionManager;
    private ConnectionEventListener eventListener;
    private ConnectionEventExecutor eventExecutor;
    private Reconnector reconnectManager;
    private Configuration configuration;

    public ConnectionEventHandler() {
    }

    public ConnectionEventHandler(Configuration configuration) {
        this.configuration = configuration;
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        if (logger.isInfoEnabled()) {
            String remote;
            String local = localAddress == null ? null : RemotingUtil.parseSocketAddressToString(localAddress);
            String string = remote = remoteAddress == null ? "UNKNOWN" : RemotingUtil.parseSocketAddressToString(remoteAddress);
            if (local == null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Try connect to {}", (Object)remote);
                }
            } else if (logger.isInfoEnabled()) {
                logger.info("Try connect from {} to {}", (Object)local, (Object)remote);
            }
        }
        super.connect(ctx, remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.infoLog("Connection disconnect to {}", RemotingUtil.parseRemoteAddress(ctx.channel()));
        super.disconnect(ctx, promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.infoLog("Connection closed: {}", RemotingUtil.parseRemoteAddress(ctx.channel()));
        Connection conn = (Connection)ctx.channel().attr(Connection.CONNECTION).get();
        if (conn != null) {
            conn.onClose();
        }
        super.close(ctx, promise);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.infoLog("Connection channel registered: {}", RemotingUtil.parseRemoteAddress(ctx.channel()));
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.infoLog("Connection channel unregistered: {}", RemotingUtil.parseRemoteAddress(ctx.channel()));
        super.channelUnregistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.infoLog("Connection channel active: {}", RemotingUtil.parseRemoteAddress(ctx.channel()));
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Connection conn;
        String remoteAddress = RemotingUtil.parseRemoteAddress(ctx.channel());
        this.infoLog("Connection channel inactive: {}", remoteAddress);
        super.channelInactive(ctx);
        Attribute attr = ctx.channel().attr(Connection.CONNECTION);
        if (null != attr && (conn = (Connection)attr.get()) != null) {
            this.userEventTriggered(ctx, (Object)ConnectionEventType.CLOSE);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof ConnectionEventType) {
            ConnectionEventType eventType = (ConnectionEventType)((Object)event);
            Channel channel = ctx.channel();
            if (channel == null) {
                logger.warn("channel null when handle user triggered event in ConnectionEventHandler! eventType: {}", (Object)eventType.name());
                return;
            }
            Connection connection = (Connection)channel.attr(Connection.CONNECTION).get();
            if (connection == null) {
                logger.error("[BUG]connection is null when handle user triggered event in ConnectionEventHandler! eventType: {}", (Object)eventType.name());
                return;
            }
            String remoteAddress = RemotingUtil.parseRemoteAddress(ctx.channel());
            String localAddress = RemotingUtil.parseLocalAddress(ctx.channel());
            logger.info("trigger user event, local[{}], remote[{}], event: {}", new Object[]{localAddress, remoteAddress, eventType.name()});
            switch (eventType) {
                case CONNECT: {
                    this.onEvent(connection, connection.getUrl().getOriginUrl(), ConnectionEventType.CONNECT);
                    break;
                }
                case CONNECT_FAILED: 
                case CLOSE: 
                case EXCEPTION: {
                    this.submitReconnectTaskIfNecessary(connection.getUrl());
                    this.onEvent(connection, connection.getUrl().getOriginUrl(), eventType);
                    break;
                }
                default: {
                    logger.error("[BUG]unknown event: {}", (Object)eventType.name());
                    break;
                }
            }
        } else {
            super.userEventTriggered(ctx, event);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String remoteAddress = RemotingUtil.parseRemoteAddress(ctx.channel());
        String localAddress = RemotingUtil.parseLocalAddress(ctx.channel());
        logger.warn("ExceptionCaught in connection: local[{}], remote[{}], close the connection! Cause[{}:{}]", new Object[]{localAddress, remoteAddress, cause.getClass().getSimpleName(), cause.getMessage()});
        ctx.channel().close();
    }

    private void submitReconnectTaskIfNecessary(Url url) {
        if (this.configuration.option(BoltClientOption.CONN_RECONNECT_SWITCH).booleanValue() && this.reconnectManager != null) {
            this.reconnectManager.reconnect(url);
        }
    }

    private void onEvent(final Connection conn, final String remoteAddress, final ConnectionEventType type) {
        if (this.eventListener != null) {
            this.eventExecutor.onEvent(new Runnable(){

                @Override
                public void run() {
                    ConnectionEventHandler.this.eventListener.onEvent(type, remoteAddress, conn);
                }
            });
        }
    }

    public ConnectionEventListener getConnectionEventListener() {
        return this.eventListener;
    }

    public void setConnectionEventListener(ConnectionEventListener listener) {
        if (listener != null) {
            this.eventListener = listener;
            if (this.eventExecutor == null) {
                this.eventExecutor = new ConnectionEventExecutor();
            }
        }
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Deprecated
    public void setReconnectManager(ReconnectManager reconnectManager) {
        this.reconnectManager = reconnectManager;
    }

    public void setReconnector(Reconnector reconnector) {
        this.reconnectManager = reconnector;
    }

    private void infoLog(String format, String addr) {
        if (logger.isInfoEnabled()) {
            if (StringUtils.isNotEmpty(addr)) {
                logger.info(format, (Object)addr);
            } else {
                logger.info(format, (Object)"UNKNOWN-ADDR");
            }
        }
    }

    public class ConnectionEventExecutor {
        Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
        ExecutorService executor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), new NamedThreadFactory("Bolt-conn-event-executor", true));

        public void onEvent(Runnable runnable) {
            try {
                this.executor.execute(runnable);
            }
            catch (Throwable t) {
                this.logger.error("Exception caught when execute connection event!", t);
            }
        }
    }
}

