/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.plugin.BrokerAttachedPlugin;
import org.apache.rocketmq.broker.schedule.DelayOffsetSerializeWrapper;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.BrokerSyncInfo;
import org.apache.rocketmq.remoting.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.remoting.protocol.body.ConsumerOffsetSerializeWrapper;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.ha.HAConnectionState;
import org.apache.rocketmq.store.ha.HAConnectionStateNotificationRequest;
import org.apache.rocketmq.store.timer.TimerCheckpoint;

public class BrokerPreOnlineService
extends ServiceThread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;
    private int waitBrokerIndex = 0;

    public BrokerPreOnlineService(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public String getServiceName() {
        if (this.brokerController != null && this.brokerController.getBrokerConfig().isInBrokerContainer()) {
            return this.brokerController.getBrokerIdentity().getIdentifier() + BrokerPreOnlineService.class.getSimpleName();
        }
        return BrokerPreOnlineService.class.getSimpleName();
    }

    public void run() {
        LOGGER.info(this.getServiceName() + " service started");
        while (!this.isStopped()) {
            if (!this.brokerController.isIsolated()) {
                LOGGER.info("broker {} is online", (Object)this.brokerController.getBrokerConfig().getCanonicalName());
                break;
            }
            try {
                boolean isSuccess = this.prepareForBrokerOnline();
                if (isSuccess) break;
                this.waitForRunning(1000L);
            }
            catch (Exception e) {
                LOGGER.error("Broker preOnline error, ", (Throwable)e);
            }
        }
        LOGGER.info(this.getServiceName() + " service end");
    }

    CompletableFuture<Boolean> waitForHaHandshakeComplete(String brokerAddr) {
        LOGGER.info("wait for handshake completion with {}", (Object)brokerAddr);
        HAConnectionStateNotificationRequest request = new HAConnectionStateNotificationRequest(HAConnectionState.TRANSFER, RemotingHelper.parseHostFromAddress((String)brokerAddr), true);
        if (this.brokerController.getMessageStore().getHaService() != null) {
            this.brokerController.getMessageStore().getHaService().putGroupConnectionStateRequest(request);
        } else {
            LOGGER.error("HAService is null, maybe broker config is wrong. For example, duplicationEnable is true");
            request.getRequestFuture().complete(false);
        }
        return request.getRequestFuture();
    }

    private boolean futureWaitAction(boolean result, BrokerMemberGroup brokerMemberGroup) {
        if (!result) {
            LOGGER.error("wait for handshake completion failed, HA connection lost");
            return false;
        }
        if (this.brokerController.getBrokerConfig().getBrokerId() != 0L) {
            LOGGER.info("slave preOnline complete, start service");
            long minBrokerId = this.getMinBrokerId(brokerMemberGroup.getBrokerAddrs());
            this.brokerController.startService(minBrokerId, (String)brokerMemberGroup.getBrokerAddrs().get(minBrokerId));
        }
        return true;
    }

    private boolean prepareForMasterOnline(BrokerMemberGroup brokerMemberGroup) {
        ArrayList brokerIdList = new ArrayList(brokerMemberGroup.getBrokerAddrs().keySet());
        Collections.sort(brokerIdList);
        while (true) {
            if (this.waitBrokerIndex >= brokerIdList.size()) {
                LOGGER.info("master preOnline complete, start service");
                this.brokerController.startService(0L, this.brokerController.getBrokerAddr());
                return true;
            }
            String brokerAddrToWait = (String)brokerMemberGroup.getBrokerAddrs().get(brokerIdList.get(this.waitBrokerIndex));
            try {
                this.brokerController.getBrokerOuterAPI().sendBrokerHaInfo(brokerAddrToWait, this.brokerController.getHAServerAddr(), this.brokerController.getMessageStore().getBrokerInitMaxOffset(), this.brokerController.getBrokerAddr());
            }
            catch (Exception e) {
                LOGGER.error("send ha address to {} exception, {}", (Object)brokerAddrToWait, (Object)e);
                return false;
            }
            CompletionStage haHandshakeFuture = this.waitForHaHandshakeComplete(brokerAddrToWait).thenApply(result -> this.futureWaitAction((boolean)result, brokerMemberGroup));
            try {
                if (!((Boolean)((CompletableFuture)haHandshakeFuture).get()).booleanValue()) {
                    return false;
                }
            }
            catch (Exception e) {
                LOGGER.error("Wait handshake completion exception, {}", (Throwable)e);
                return false;
            }
            if (!this.syncMetadataReverse(brokerAddrToWait)) break;
            ++this.waitBrokerIndex;
        }
        return false;
    }

    private boolean syncMetadataReverse(String brokerAddr) {
        try {
            LOGGER.info("Get metadata reverse from {}", (Object)brokerAddr);
            String delayOffset = this.brokerController.getBrokerOuterAPI().getAllDelayOffset(brokerAddr);
            DelayOffsetSerializeWrapper delayOffsetSerializeWrapper = (DelayOffsetSerializeWrapper)((Object)DelayOffsetSerializeWrapper.fromJson((String)delayOffset, DelayOffsetSerializeWrapper.class));
            ConsumerOffsetSerializeWrapper consumerOffsetSerializeWrapper = this.brokerController.getBrokerOuterAPI().getAllConsumerOffset(brokerAddr);
            TimerCheckpoint timerCheckpoint = this.brokerController.getBrokerOuterAPI().getTimerCheckPoint(brokerAddr);
            if (null != consumerOffsetSerializeWrapper && this.brokerController.getConsumerOffsetManager().getDataVersion().compare(consumerOffsetSerializeWrapper.getDataVersion()) <= 0) {
                LOGGER.info("{}'s consumerOffset data version is larger than master broker, {}'s consumerOffset will be used.", (Object)brokerAddr, (Object)brokerAddr);
                this.brokerController.getConsumerOffsetManager().getOffsetTable().putAll(consumerOffsetSerializeWrapper.getOffsetTable());
                this.brokerController.getConsumerOffsetManager().getDataVersion().assignNewOne(consumerOffsetSerializeWrapper.getDataVersion());
                this.brokerController.getConsumerOffsetManager().persist();
            }
            if (null != delayOffset && this.brokerController.getScheduleMessageService().getDataVersion().compare(delayOffsetSerializeWrapper.getDataVersion()) <= 0) {
                LOGGER.info("{}'s scheduleMessageService data version is larger than master broker, {}'s delayOffset will be used.", (Object)brokerAddr, (Object)brokerAddr);
                String fileName = StorePathConfigHelper.getDelayOffsetStorePath((String)this.brokerController.getMessageStoreConfig().getStorePathRootDir());
                try {
                    MixAll.string2File((String)delayOffset, (String)fileName);
                    this.brokerController.getScheduleMessageService().load();
                }
                catch (IOException e) {
                    LOGGER.error("Persist file Exception, {}", (Object)fileName, (Object)e);
                }
            }
            if (null != this.brokerController.getTimerCheckpoint() && this.brokerController.getTimerCheckpoint().getDataVersion().compare(timerCheckpoint.getDataVersion()) <= 0) {
                LOGGER.info("{}'s timerCheckpoint data version is larger than master broker, {}'s timerCheckpoint will be used.", (Object)brokerAddr, (Object)brokerAddr);
                this.brokerController.getTimerCheckpoint().setLastReadTimeMs(timerCheckpoint.getLastReadTimeMs());
                this.brokerController.getTimerCheckpoint().setMasterTimerQueueOffset(timerCheckpoint.getMasterTimerQueueOffset());
                this.brokerController.getTimerCheckpoint().getDataVersion().assignNewOne(timerCheckpoint.getDataVersion());
                this.brokerController.getTimerCheckpoint().flush();
            }
            for (BrokerAttachedPlugin brokerAttachedPlugin : this.brokerController.getBrokerAttachedPlugins()) {
                if (brokerAttachedPlugin == null) continue;
                brokerAttachedPlugin.syncMetadataReverse(brokerAddr);
            }
        }
        catch (Exception e) {
            LOGGER.error("GetMetadataReverse Failed", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean prepareForSlaveOnline(BrokerMemberGroup brokerMemberGroup) {
        BrokerSyncInfo brokerSyncInfo;
        try {
            brokerSyncInfo = this.brokerController.getBrokerOuterAPI().retrieveBrokerHaInfo((String)brokerMemberGroup.getBrokerAddrs().get(0L));
        }
        catch (Exception e) {
            LOGGER.error("retrieve master ha info exception, {}", (Throwable)e);
            return false;
        }
        if (this.brokerController.getMessageStore().getMasterFlushedOffset() == 0L && this.brokerController.getMessageStoreConfig().isSyncMasterFlushOffsetWhenStartup()) {
            LOGGER.info("Set master flush offset in slave to {}", (Object)brokerSyncInfo.getMasterFlushOffset());
            this.brokerController.getMessageStore().setMasterFlushedOffset(brokerSyncInfo.getMasterFlushOffset());
        }
        if (brokerSyncInfo.getMasterHaAddress() == null) {
            LOGGER.info("fetch master ha address return null, start service directly");
            long minBrokerId = this.getMinBrokerId(brokerMemberGroup.getBrokerAddrs());
            this.brokerController.startService(minBrokerId, (String)brokerMemberGroup.getBrokerAddrs().get(minBrokerId));
            return true;
        }
        this.brokerController.getMessageStore().updateHaMasterAddress(brokerSyncInfo.getMasterHaAddress());
        this.brokerController.getMessageStore().updateMasterAddress(brokerSyncInfo.getMasterAddress());
        CompletionStage haHandshakeFuture = this.waitForHaHandshakeComplete(brokerSyncInfo.getMasterHaAddress()).thenApply(result -> this.futureWaitAction((boolean)result, brokerMemberGroup));
        try {
            if (!((Boolean)((CompletableFuture)haHandshakeFuture).get()).booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("Wait handshake completion exception, {}", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean prepareForBrokerOnline() {
        BrokerMemberGroup brokerMemberGroup;
        try {
            brokerMemberGroup = this.brokerController.getBrokerOuterAPI().syncBrokerMemberGroup(this.brokerController.getBrokerConfig().getBrokerClusterName(), this.brokerController.getBrokerConfig().getBrokerName(), this.brokerController.getBrokerConfig().isCompatibleWithOldNameSrv());
        }
        catch (Exception e) {
            LOGGER.error("syncBrokerMemberGroup from namesrv error, start service failed, will try later, ", (Throwable)e);
            return false;
        }
        if (brokerMemberGroup != null && !brokerMemberGroup.getBrokerAddrs().isEmpty()) {
            long minBrokerId = this.getMinBrokerId(brokerMemberGroup.getBrokerAddrs());
            if (this.brokerController.getBrokerConfig().getBrokerId() == 0L) {
                return this.prepareForMasterOnline(brokerMemberGroup);
            }
            if (minBrokerId == 0L) {
                return this.prepareForSlaveOnline(brokerMemberGroup);
            }
            LOGGER.info("no master online, start service directly");
            this.brokerController.startService(minBrokerId, (String)brokerMemberGroup.getBrokerAddrs().get(minBrokerId));
        } else {
            LOGGER.info("no other broker online, will start service directly");
            this.brokerController.startService(this.brokerController.getBrokerConfig().getBrokerId(), this.brokerController.getBrokerAddr());
        }
        return true;
    }

    private long getMinBrokerId(Map<Long, String> brokerAddrMap) {
        HashMap<Long, String> brokerAddrMapCopy = new HashMap<Long, String>(brokerAddrMap);
        brokerAddrMapCopy.remove(this.brokerController.getBrokerConfig().getBrokerId());
        if (!brokerAddrMapCopy.isEmpty()) {
            return (Long)Collections.min(brokerAddrMapCopy.keySet());
        }
        return this.brokerController.getBrokerConfig().getBrokerId();
    }
}

