/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.kv;

import java.util.Objects;
import java.util.Optional;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.attribute.CleanupPolicy;
import org.apache.rocketmq.common.utils.CleanupPolicyUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.kv.CompactionStore;

public class CompactionService {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private final CompactionStore compactionStore;
    private final DefaultMessageStore defaultMessageStore;
    private final CommitLog commitLog;

    public CompactionService(CommitLog commitLog, DefaultMessageStore messageStore, CompactionStore compactionStore) {
        this.commitLog = commitLog;
        this.defaultMessageStore = messageStore;
        this.compactionStore = compactionStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRequest(DispatchRequest request) {
        if (request == null) {
            return;
        }
        String topic = request.getTopic();
        Optional<TopicConfig> topicConfig = this.defaultMessageStore.getTopicConfig(topic);
        CleanupPolicy policy = CleanupPolicyUtils.getDeletePolicy(topicConfig);
        if (Objects.equals(policy, CleanupPolicy.COMPACTION)) {
            SelectMappedBufferResult smr = null;
            try {
                smr = this.commitLog.getData(request.getCommitLogOffset());
                if (smr != null) {
                    this.compactionStore.doDispatch(request, smr);
                }
            }
            catch (Exception e) {
                log.error("putMessage into {}:{} compactionLog exception: ", new Object[]{request.getTopic(), request.getQueueId(), e});
            }
            finally {
                if (smr != null) {
                    smr.release();
                }
            }
        }
    }

    public boolean load(boolean exitOK) {
        try {
            this.compactionStore.load(exitOK);
            return true;
        }
        catch (Exception e) {
            log.error("load compaction store error ", (Throwable)e);
            return false;
        }
    }

    public void shutdown() {
        this.compactionStore.shutdown();
    }

    public void updateMasterAddress(String addr) {
        this.compactionStore.updateMasterAddress(addr);
    }
}

