/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v13;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.util.MinMaxHeapPool;
import ch.ethz.globis.phtree.v13.Node;
import ch.ethz.globis.phtree.v13.NodeIteratorFullNoGC;
import ch.ethz.globis.phtree.v13.PhTree13;
import java.util.NoSuchElementException;

public class PhIteratorKnn<T>
implements PhTree.PhKnnQuery<T> {
    private final PhTree13<T> pht;
    private final PhFilter filterFn = new PhFilter(){

        @Override
        public boolean isValid(long[] key) {
            return true;
        }

        @Override
        public boolean isValid(int bitsToIgnore, long[] prefix) {
            return true;
        }
    };
    private final NodeIteratorFullNoGC<T> nodeIter;
    private final PhEntry<T> tempResult;
    MinMaxHeapPool<NodeDistT> queueN;
    MinMaxHeapPool<PhEntryDist<T>> queueV;
    double maxNodeDist = Double.POSITIVE_INFINITY;
    private PhDistance distFn;
    private PhEntryDist<T> resultFree;
    private PhEntryDist<T> resultToReturn;
    private boolean isFinished = false;
    private int remaining;
    private long[] center;
    private double currentDistance;

    PhIteratorKnn(PhTree13<T> pht, int minResults, long[] center, PhDistance distFn) {
        this.distFn = distFn;
        this.pht = pht;
        int dim = pht.getDim();
        this.queueN = MinMaxHeapPool.create((t1, t2) -> t1.dist < t2.dist, () -> new NodeDistT(-1.0, null, new long[dim]));
        this.queueV = MinMaxHeapPool.create((t1, t2) -> t1.dist() < t2.dist(), () -> new PhEntryDist<Object>(new long[dim], null, -1.0));
        this.nodeIter = new NodeIteratorFullNoGC(dim, new long[dim]);
        this.resultFree = new PhEntryDist<Object>(new long[dim], null, 0.0);
        this.resultToReturn = new PhEntryDist<Object>(new long[dim], null, 0.0);
        this.tempResult = new PhEntry<Object>(new long[dim], null);
        this.reset(minResults, distFn, center);
    }

    @Override
    public PhTree.PhKnnQuery<T> reset(int minResults, PhDistance distFn, long ... center) {
        this.center = center;
        this.distFn = distFn == null ? this.distFn : distFn;
        this.currentDistance = Double.MAX_VALUE;
        this.remaining = minResults;
        this.maxNodeDist = Double.POSITIVE_INFINITY;
        this.isFinished = false;
        Node root = this.pht.getRoot();
        if (minResults <= 0 || root == null) {
            this.isFinished = true;
            return this;
        }
        this.queueN.clear();
        this.queueV.clear();
        this.queueN.push(this.createEntry(0.0, root, new long[this.pht.getDim()]));
        this.findNextElement();
        return this;
    }

    @Override
    public long[] nextKey() {
        return (long[])((PhEntry)this.nextEntryReuse()).getKey().clone();
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public PhEntryDist<T> nextEntry() {
        return new PhEntryDist(this.nextEntryReuse());
    }

    @Override
    public PhEntryDist<T> nextEntryReuse() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PhEntryDist<T> ret = this.resultToReturn;
        this.findNextElement();
        return ret;
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public T next() {
        return this.nextValue();
    }

    public double distance() {
        return this.currentDistance;
    }

    private void findNextElement() {
        while (!(this.remaining <= 0 || this.queueN.isEmpty() && this.queueV.isEmpty())) {
            boolean useV;
            boolean bl = useV = !this.queueV.isEmpty();
            if (useV && !this.queueN.isEmpty()) {
                boolean bl2 = useV = this.queueV.peekMin().dist() <= this.queueN.peekMin().dist;
            }
            if (useV) {
                PhEntryDist<T> result = this.queueV.peekMin();
                this.queueV.popMin();
                --this.remaining;
                PhEntryDist<T> dummy = this.resultFree;
                this.resultFree = this.resultToReturn;
                this.resultToReturn = dummy;
                this.resultToReturn.setCopyKey(result.getKey(), result.getValue(), result.dist());
                this.currentDistance = result.dist();
                return;
            }
            NodeDistT top = this.queueN.peekMin();
            this.queueN.popMin();
            Node node = top.node;
            double dNode = top.dist;
            if (dNode > this.maxNodeDist && this.queueV.size() >= this.remaining) continue;
            this.nodeIter.init(node, this.filterFn);
            this.nodeIter.setValTemplate(top.prefix);
            while (this.nodeIter.increment(this.tempResult)) {
                if (this.tempResult.hasNodeInternal()) {
                    Node sub = (Node)this.tempResult.getNodeInternal();
                    double dist = this.distToNode(this.nodeIter.getValTemplate(), sub.getPostLen() + 1);
                    if (!(dist <= this.maxNodeDist)) continue;
                    this.queueN.push(this.createEntry(dist, sub, this.nodeIter.getValTemplate()));
                    continue;
                }
                double d = this.distFn.dist(this.center, this.tempResult.getKey());
                if (!(d <= this.maxNodeDist)) continue;
                this.queueV.push(this.createEntry(this.tempResult.getKey(), this.tempResult.getValue(), d));
                if (this.queueV.size() < this.remaining) continue;
                if (this.queueV.size() > this.remaining) {
                    this.queueV.popMax();
                }
                double dMax = this.queueV.peekMax().dist();
                this.maxNodeDist = Math.min(this.maxNodeDist, dMax);
            }
        }
        this.isFinished = true;
        this.currentDistance = Double.MAX_VALUE;
    }

    private double distToNode(long[] prefix, int bitsToIgnore) {
        long maskMin = -1L << bitsToIgnore;
        long maskMax = maskMin ^ 0xFFFFFFFFFFFFFFFFL;
        long[] buf = new long[prefix.length];
        for (int i = 0; i < buf.length; ++i) {
            long min2 = prefix[i] & maskMin;
            long max = prefix[i] | maskMax;
            buf[i] = min2 > this.center[i] ? min2 : Math.min(max, this.center[i]);
        }
        return this.distFn.dist(this.center, buf);
    }

    private PhEntryDist<T> createEntry(long[] key, T val, double dist) {
        PhEntryDist<T> e = this.queueV.getObject();
        e.setCopyKey(key, val, dist);
        return e;
    }

    private NodeDistT createEntry(double dist, Node node, long[] prefix) {
        NodeDistT e = this.queueN.getObject();
        e.node = node;
        System.arraycopy(prefix, 0, e.prefix, 0, e.prefix.length);
        e.dist = dist;
        return e;
    }

    private static class NodeDistT {
        double dist;
        Node node;
        long[] prefix;

        NodeDistT(double dist, Node node, long[] prefix) {
            this.dist = dist;
            this.node = node;
            this.prefix = prefix;
        }
    }
}

