/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class JLazyMenu
extends JMenu {
    public JLazyMenu(String name) {
        this.setText(name);
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JLazyMenu.this.removeAll();
                for (final Runnable r : JLazyMenu.this.getEntries()) {
                    if (r instanceof SubMenu) {
                        JLazyMenu.this.add(((SubMenu)r).create());
                        continue;
                    }
                    JMenuItem item = new JMenuItem(r.toString());
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            r.run();
                        }
                    });
                    JLazyMenu.this.add(item);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    public abstract List<Runnable> getEntries();

    public abstract class SubMenu
    implements Runnable {
        public abstract JLazyMenu create();

        @Override
        public void run() {
            throw new UnsupportedOperationException("Nothing to run");
        }
    }
}

