/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.offset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.Tuple3d;
import org.twak.camp.Corner;
import org.twak.camp.CornerClone;
import org.twak.camp.Edge;
import org.twak.camp.HeightEvent;
import org.twak.camp.Machine;
import org.twak.camp.Output;
import org.twak.camp.Skeleton;
import org.twak.camp.debug.DebugDevice;
import org.twak.camp.offset.Offset;
import org.twak.camp.offset.OffsetMachine;
import org.twak.camp.ui.DirectionHeightEvent;
import org.twak.utils.Cache;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.ManyManyMap;
import org.twak.utils.collections.SetCorrespondence;

public class PerEdgeOffsetSkeleton {
    Offset output;
    LoopL<Corner> oldCorners;
    double step = 100.0;
    int machinesCount = 0;
    int machinesOutstanding = 0;
    int lastStep = -1;
    public SetCorrespondence<Corner, Corner> oldInputSegments;
    public Skeleton outputSkeleton;
    Cache<Double, OffsetMachine> machineGenerator = new Cache<Double, OffsetMachine>(){

        @Override
        public OffsetMachine create(Double speed) {
            OffsetMachine om = new OffsetMachine();
            om.currentAngle = Math.atan2(speed, PerEdgeOffsetSkeleton.this.step);
            om.addHeightEvent(new DirectionHeightEvent(om, 0.0, Math.atan2(speed, PerEdgeOffsetSkeleton.this.step)));
            return om;
        }
    };
    public Map<Corner, Double> inputCornerToSpeed = new HashMap<Corner, Double>();

    public PerEdgeOffsetSkeleton(LoopL<Corner> corners, LoopL<Double> speeds) {
        this.setup(corners);
        Iterator<Corner> cit = corners.eIterator().iterator();
        Iterator<Double> sit = speeds.eIterator().iterator();
        while (cit.hasNext()) {
            Corner c = cit.next();
            assert (sit.hasNext());
            double speed = sit.next();
            this.registerEdge(c, speed);
        }
    }

    public PerEdgeOffsetSkeleton(LoopL<Corner> corners, double speed) {
        this.setup(corners);
        for (Corner c : corners.eIterator()) {
            this.registerEdge(c, speed);
        }
    }

    public PerEdgeOffsetSkeleton(LoopL<Corner> corners) {
        this.setup(corners);
    }

    public PerEdgeOffsetSkeleton() {
    }

    public void setup(LoopL<Corner> inputCorners) {
        CornerClone cc = new CornerClone(inputCorners);
        this.oldCorners = cc.output;
        this.oldInputSegments = cc.nOSegments;
        for (Corner oldC : this.oldCorners.eIterator()) {
            oldC.nextL.machine = this.machineGenerator.get(new Double(0.0));
        }
    }

    public void registerEdge(Corner inputCorner, double speed) {
        this.inputCornerToSpeed.put(inputCorner, speed);
    }

    public Offset getResult() {
        for (Corner inputCorner : this.inputCornerToSpeed.keySet()) {
            double speed = this.inputCornerToSpeed.get(inputCorner);
            for (Corner oldC : this.oldInputSegments.getSetB(inputCorner)) {
                oldC.nextL.machine = this.machineGenerator.get(speed);
            }
        }
        for (Corner c : this.oldCorners.eIterator()) {
            c.z = 0.0;
        }
        this.outputSkeleton = new Skeleton(this.oldCorners);
        this.outputSkeleton.name = "offset";
        InstanceHeightEvent last = null;
        DebugDevice.dump("p/e offset skeleton (in)", this.oldCorners);
        last = new InstanceHeightEvent(this.step);
        this.outputSkeleton.qu.add(last);
        this.outputSkeleton.skeleton();
        DebugDevice.dump("p/e offset skeleton (out)", this.outputSkeleton);
        for (Corner newCorner : this.output.shape.eIterator()) {
            Machine original = null;
            for (Corner input : this.output.nOSegments.getNext(newCorner)) {
                if (original == null) {
                    original = input.nextL.machine;
                }
                assert (original == input.nextL.machine);
            }
            newCorner.nextL.machine = original;
        }
        return this.output;
    }

    public List<Corner> getInputEdge(Output.Face f) {
        Edge first = this.outputSkeleton.output.getGreatestGrandParent((Output.Face)f).edge;
        return new ArrayList<Corner>(this.oldInputSegments.getSetA(first.start));
    }

    public class InstanceHeightEvent
    implements HeightEvent {
        double height;
        boolean endHere = false;

        public InstanceHeightEvent(double height) {
            this.height = height;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean process(Skeleton skel) {
            ManyManyMap outputOldSegments;
            LoopL<Corner> copy = skel.capCopy(this.height);
            ManyManyMap<Corner, Corner> manyManyMap = skel.segmentMap;
            Objects.requireNonNull(manyManyMap);
            ManyManyMap manyManyMap2 = outputOldSegments = new ManyManyMap.ConvertInputCollection<Corner>(manyManyMap, skel.getSegmentOriginator()).get();
            Objects.requireNonNull(manyManyMap2);
            ManyManyMap<Corner, Corner> inputCapSegments = new ManyManyMap.ConvertInputCollection<Corner>(manyManyMap2, PerEdgeOffsetSkeleton.this.oldInputSegments.asCache()).get();
            inputCapSegments = inputCapSegments.getFlipShallow();
            PerEdgeOffsetSkeleton.this.output = new Offset(copy, inputCapSegments);
            for (Corner c : skel.liveCorners) {
                Corner top = skel.cornerMap.teg(c);
                skel.output.addOutputSideTo(c, (Tuple3d)top, c.nextL, c.prevL);
                skel.output.addOutputSideTo(true, (Tuple3d)top, top.nextC, c.nextL);
            }
            skel.liveEdges.clear();
            skel.liveCorners.clear();
            skel.qu.clearFaceEvents();
            return false;
        }
    }
}

