/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.critbit;

import java.util.Arrays;
import org.tinspin.index.critbit.BitTools;
import org.tinspin.index.critbit.CritBit;
import org.tinspin.index.critbit.CritBit1D;
import org.tinspin.index.critbit.CritBitKD;

public class Examples {
    public static void main(String[] args) {
        Examples.ex1D_32();
        Examples.ex1D_float();
        Examples.ex1D_256();
        Examples.ex4D();
    }

    private static void ex1D_32() {
        Examples.log("Testing 1D 32 bit tree");
        Examples.log("======================");
        CritBit1D<String> cb = CritBit.create1D(32);
        long[] key = new long[]{1234L};
        cb.put(key, "hello 32");
        Examples.log("contains() --> " + cb.contains(key));
        Examples.log("get() --> " + (String)cb.get(key));
        long[] min2 = new long[]{123L};
        long[] max = new long[]{12345L};
        CritBit.QueryIterator it = cb.query(min2, max);
        Examples.log("iterator val: " + (String)it.next());
        CritBit.QueryIterator it2 = cb.query(min2, max);
        Examples.log("iterator key: " + it2.nextKey()[0]);
        Examples.log("remove: " + (String)cb.remove(key));
    }

    private static void ex1D_float() {
        Examples.log("Testing 1D float tree");
        Examples.log("=====================");
        CritBit1D<String> cb = CritBit.create1D(64);
        long[] key = new long[]{BitTools.toSortableLong(12.34)};
        cb.put(key, "hello float");
        Examples.log("contains() --> " + cb.contains(key));
        Examples.log("get() --> " + (String)cb.get(key));
        long[] min2 = new long[]{BitTools.toSortableLong(1.0)};
        long[] max = new long[]{BitTools.toSortableLong(15.0)};
        CritBit.QueryIterator it = cb.query(min2, max);
        Examples.log("iterator val: " + (String)it.next());
        CritBit.QueryIterator it2 = cb.query(min2, max);
        Examples.log("iterator key: " + BitTools.toDouble(it2.nextKey()[0]));
        Examples.log("remove: " + (String)cb.remove(key));
    }

    private static void ex1D_256() {
        Examples.log("Testing 1D 256 bit tree");
        Examples.log("=======================");
        CritBit1D<String> cb = CritBit.create1D(256);
        long[] key = new long[]{123456789012L, 3456L, 4567L, 12345678901234L};
        cb.put(key, "hello 256");
        Examples.log("contains() --> " + cb.contains(key));
        Examples.log("get() --> " + (String)cb.get(key));
        long[] min2 = new long[]{0L, 0L, 0L, 0L};
        long[] max = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE};
        CritBit.QueryIterator it = cb.query(min2, max);
        Examples.log("iterator val: " + (String)it.next());
        CritBit.QueryIterator it2 = cb.query(min2, max);
        Examples.log("iterator key: " + it2.nextKey()[0]);
        Examples.log("remove: " + (String)cb.remove(key));
    }

    private static void ex4D() {
        Examples.log("Testing 4D tree");
        Examples.log("===============");
        CritBitKD<String> cb = CritBit.createKD(64, 4);
        long[] key = new long[]{123456789012L, 3456L, BitTools.toSortableLong(1234.5678), 12345678901234L};
        cb.putKD(key, "hello 4D");
        Examples.log("contains() --> " + cb.containsKD(key));
        Examples.log("get() --> " + (String)cb.getKD(key));
        long[] min2 = new long[]{0L, 0L, BitTools.toSortableLong(1.0), 0L};
        long[] max = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, BitTools.toSortableLong(Double.MAX_VALUE), Long.MAX_VALUE};
        CritBit.QueryIteratorKD it = cb.queryKD(min2, max);
        Examples.log("iterator val: " + (String)it.next());
        CritBit.QueryIteratorKD it2 = cb.queryKD(min2, max);
        Examples.log("iterator key: " + Arrays.toString(it2.nextKey()));
        Examples.log("remove: " + (String)cb.removeKD(key));
    }

    private static void log(String msg) {
        System.out.println(msg);
    }
}

