/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;

public class ResponseSizeAccessItem
implements AccessLogItem<RoutingContext> {
    private final String zeroBytes;

    public ResponseSizeAccessItem(String zeroBytesPlaceholder) {
        this.zeroBytes = zeroBytesPlaceholder;
    }

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        HttpServerResponse response = accessLogEvent.getRoutingContext().response();
        if (null == response || 0L == response.bytesWritten()) {
            builder.append(this.zeroBytes);
            return;
        }
        builder.append(response.bytesWritten());
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        builder.append(this.zeroBytes);
    }

    public String getZeroBytes() {
        return this.zeroBytes;
    }
}

