/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.ext;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import com.alipay.sofa.rpc.common.utils.ClassTypeUtils;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.context.RpcRunningState;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.Extensible;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExtensionLoader<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final String LOAD_FROM_CODE = "DYNAMIC LOAD EXTENSION BY CODE";
    protected final Class<T> interfaceClass;
    protected final String interfaceName;
    protected final Extensible extensible;
    protected final ConcurrentMap<String, ExtensionClass<T>> all;
    protected final ConcurrentMap<String, T> factory;
    protected final List<ExtensionLoaderListener<T>> listeners;

    public ExtensionLoader(Class<T> interfaceClass, ExtensionLoaderListener<T> listener) {
        this(interfaceClass, true, listener);
    }

    protected ExtensionLoader(Class<T> interfaceClass) {
        this(interfaceClass, true, null);
    }

    protected ExtensionLoader(Class<T> interfaceClass, boolean autoLoad, ExtensionLoaderListener<T> listener) {
        Extensible extensible;
        if (RpcRunningState.isShuttingDown()) {
            this.interfaceClass = null;
            this.interfaceName = null;
            this.listeners = null;
            this.factory = null;
            this.extensible = null;
            this.all = null;
            return;
        }
        if (interfaceClass == null || !interfaceClass.isInterface() && !Modifier.isAbstract(interfaceClass.getModifiers())) {
            throw new IllegalArgumentException("Extensible class must be interface or abstract class!");
        }
        this.interfaceClass = interfaceClass;
        this.interfaceName = ClassTypeUtils.getTypeStr(interfaceClass);
        this.listeners = new ArrayList<ExtensionLoaderListener<T>>();
        if (listener != null) {
            this.listeners.add(listener);
        }
        if ((extensible = interfaceClass.getAnnotation(Extensible.class)) == null) {
            throw new IllegalArgumentException("Error when load extensible interface " + this.interfaceName + ", must add annotation @Extensible.");
        }
        this.extensible = extensible;
        this.factory = extensible.singleton() ? new ConcurrentHashMap() : null;
        this.all = new ConcurrentHashMap<String, ExtensionClass<T>>();
        if (autoLoad) {
            List paths = RpcConfigs.getListValue("extension.load.path");
            for (String path : paths) {
                this.loadFromFile(path);
            }
        }
    }

    protected synchronized void loadFromFile(String path) {
        block3: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loading extension of extensible {} from path: {}", this.interfaceName, path);
            }
            String file = StringUtils.isBlank(this.extensible.file()) ? this.interfaceName : this.extensible.file().trim();
            String fullFileName = path + file;
            try {
                ClassLoader classLoader = ClassLoaderUtils.getClassLoader(this.getClass());
                this.loadFromClassLoader(classLoader, fullFileName);
            }
            catch (Throwable t) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Failed to load extension of extensible " + this.interfaceName + " from path:" + fullFileName, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromClassLoader(ClassLoader classLoader, String fullFileName) throws Throwable {
        Enumeration<URL> urls;
        Enumeration<URL> enumeration = urls = classLoader != null ? classLoader.getResources(fullFileName) : ClassLoader.getSystemResources(fullFileName);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Loading extension of extensible {} from classloader: {} and file: {}", this.interfaceName, classLoader, url);
                }
                try (BufferedReader reader = null;){
                    String line;
                    reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                    while ((line = reader.readLine()) != null) {
                        this.readLine(url, line);
                    }
                }
            }
        }
    }

    protected void readLine(URL url, String line) {
        Class tmp;
        String[] aliasAndClassName = this.parseAliasAndClassName(line);
        if (aliasAndClassName == null || aliasAndClassName.length != 2) {
            return;
        }
        String alias = aliasAndClassName[0];
        String className = aliasAndClassName[1];
        try {
            tmp = ClassUtils.forName(className, false);
        }
        catch (Throwable e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Extension {} of extensible {} is disabled, cause by: {}", className, this.interfaceName, ExceptionUtils.toShortString(e, 2));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Extension " + className + " of extensible " + this.interfaceName + " is disabled.", e);
            }
            return;
        }
        this.loadExtension(alias, tmp, StringUtils.toString(url), className);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadExtension(String alias, Class loadedClazz, String location, String className) {
        if (!this.interfaceClass.isAssignableFrom(loadedClazz)) {
            throw new IllegalArgumentException("Error when load extension of extensible " + this.interfaceName + " from file:" + location + ", " + className + " is not subtype of interface.");
        }
        Class implClass = loadedClazz;
        Extension extension = implClass.getAnnotation(Extension.class);
        if (extension == null) {
            throw new IllegalArgumentException("Error when load extension of extensible " + this.interfaceName + " from file:" + location + ", " + className + " must add annotation @Extension.");
        }
        String aliasInCode = extension.value();
        if (StringUtils.isBlank(aliasInCode)) {
            throw new IllegalArgumentException("Error when load extension of extensible " + this.interfaceClass + " from file:" + location + ", " + className + "'s alias of @Extension is blank");
        }
        if (alias == null) {
            alias = aliasInCode;
        } else if (!aliasInCode.equals(alias)) {
            throw new IllegalArgumentException("Error when load extension of extensible " + this.interfaceName + " from file:" + location + ", aliases of " + className + " are not equal between " + aliasInCode + "(code) and " + alias + "(file).");
        }
        if (this.extensible.coded() && extension.code() < 0) {
            throw new IllegalArgumentException("Error when load extension of extensible " + this.interfaceName + " from file:" + location + ", code of @Extension must >=0 at " + className + ".");
        }
        if ("default".equals(alias) || "*".equals(alias)) {
            throw new IllegalArgumentException("Error when load extension of extensible " + this.interfaceName + " from file:" + location + ", alias of @Extension must not \"default\" and \"*\" at " + className + ".");
        }
        ExtensionClass old = (ExtensionClass)this.all.get(alias);
        ExtensionClass<T> extensionClass = null;
        if (old != null) {
            if (extension.override()) {
                if (extension.order() < old.getOrder()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Extension of extensible {} with alias {} override from {} to {} failure, cause by: order of old extension is higher", this.interfaceName, alias, old.getClazz(), implClass);
                    }
                } else {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Extension of extensible {} with alias {}: {} has been override to {}", this.interfaceName, alias, old.getClazz(), implClass);
                    }
                    extensionClass = this.buildClass(extension, implClass, alias);
                }
            } else {
                if (!old.isOverride() || old.getOrder() < extension.order()) throw new IllegalStateException("Error when load extension of extensible " + this.interfaceClass + " from file:" + location + ", Duplicate class with same alias: " + alias + ", " + old.getClazz() + " and " + implClass);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Extension of extensible {} with alias {}: {} has been loaded, ignore origin {}", this.interfaceName, alias, old.getClazz(), implClass);
                }
            }
        } else {
            extensionClass = this.buildClass(extension, implClass, alias);
        }
        if (extensionClass == null) return;
        for (Map.Entry entry : this.all.entrySet()) {
            Object[] rejection;
            ExtensionClass existed = (ExtensionClass)entry.getValue();
            if (extensionClass.getOrder() >= existed.getOrder()) {
                rejection = extensionClass.getRejection();
                if (!CommonUtils.isNotEmpty(rejection)) continue;
                for (Object rej : rejection) {
                    ExtensionClass removed;
                    existed = (ExtensionClass)this.all.get(rej);
                    if (existed == null || extensionClass.getOrder() < existed.getOrder() || (removed = (ExtensionClass)this.all.remove(rej)) == null || !LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("Extension of extensible {} with alias {}: {} has been reject by new {}", this.interfaceName, removed.getAlias(), removed.getClazz(), implClass);
                }
                continue;
            }
            rejection = existed.getRejection();
            if (!CommonUtils.isNotEmpty(rejection)) continue;
            for (Object rej : rejection) {
                if (!((String)rej).equals(extensionClass.getAlias()) || !LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Extension of extensible {} with alias {}: {} has been reject by old {}", this.interfaceName, alias, implClass, existed.getClazz());
                return;
            }
        }
        this.loadSuccess(alias, extensionClass);
    }

    private ExtensionClass<T> buildClass(Extension extension, Class<? extends T> implClass, String alias) {
        ExtensionClass<T> extensionClass = new ExtensionClass<T>(implClass, alias);
        extensionClass.setCode(extension.code());
        extensionClass.setSingleton(this.extensible.singleton());
        extensionClass.setOrder(extension.order());
        extensionClass.setOverride(extension.override());
        extensionClass.setRejection(extension.rejection());
        return extensionClass;
    }

    private void loadSuccess(String alias, ExtensionClass<T> extensionClass) {
        if (this.listeners != null) {
            for (ExtensionLoaderListener<T> listener : this.listeners) {
                try {
                    listener.onLoad(extensionClass);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Error when load extension of extensible " + this.interfaceClass + " with alias: " + alias + ".", e);
                }
            }
        }
        this.all.put(alias, extensionClass);
    }

    protected String[] parseAliasAndClassName(String line) {
        String className;
        if (StringUtils.isBlank(line)) {
            return null;
        }
        int i0 = (line = line.trim()).indexOf(35);
        if (i0 == 0 || line.length() == 0) {
            return null;
        }
        if (i0 > 0) {
            line = line.substring(0, i0).trim();
        }
        String alias = null;
        int i = line.indexOf(61);
        if (i > 0) {
            alias = line.substring(0, i).trim();
            className = line.substring(i + 1).trim();
        } else {
            className = line;
        }
        if (className.length() == 0) {
            return null;
        }
        return new String[]{alias, className};
    }

    public ConcurrentMap<String, ExtensionClass<T>> getAllExtensions() {
        return this.all;
    }

    public ExtensionClass<T> getExtensionClass(String alias) {
        return this.all == null ? null : (ExtensionClass)this.all.get(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String alias) {
        ExtensionClass<T> extensionClass = this.getExtensionClass(alias);
        if (extensionClass == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010030006", this.interfaceName, alias));
        }
        if (this.extensible.singleton() && this.factory != null) {
            Object t = this.factory.get(alias);
            if (t == null) {
                ExtensionLoader extensionLoader = this;
                synchronized (extensionLoader) {
                    t = this.factory.get(alias);
                    if (t == null) {
                        t = extensionClass.getExtInstance();
                        this.factory.put(alias, t);
                    }
                }
            }
            return (T)t;
        }
        return extensionClass.getExtInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String alias, Class[] argTypes, Object[] args) {
        ExtensionClass<T> extensionClass = this.getExtensionClass(alias);
        if (extensionClass == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010030006", this.interfaceName, alias));
        }
        if (this.extensible.singleton() && this.factory != null) {
            Object t = this.factory.get(alias);
            if (t == null) {
                ExtensionLoader extensionLoader = this;
                synchronized (extensionLoader) {
                    t = this.factory.get(alias);
                    if (t == null) {
                        t = extensionClass.getExtInstance(argTypes, args);
                        this.factory.put(alias, t);
                    }
                }
            }
            return (T)t;
        }
        return extensionClass.getExtInstance(argTypes, args);
    }

    public void loadExtension(Class loadedClass) {
        if (loadedClass == null) {
            throw new IllegalArgumentException("Can not load extension of null");
        }
        this.loadExtension(null, loadedClass, LOAD_FROM_CODE, loadedClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ExtensionLoaderListener<T> listener) {
        ExtensionLoader extensionLoader = this;
        synchronized (extensionLoader) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                for (ExtensionClass value : this.all.values()) {
                    try {
                        listener.onLoad(value);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("Error when notify listener  of extensible " + this.interfaceClass + " with alias: " + value.getAlias() + ".", e);
                    }
                }
            }
        }
    }
}

