/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.apm.network.common.v3.KeyIntValuePair;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent;
import org.apache.skywalking.apm.network.language.agent.v3.SpanType;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SWSpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventTraceType;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TraceQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyNumericValue;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.LogEntity;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Ref;
import org.apache.skywalking.oap.server.core.query.type.RefType;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.SpanAttachedEvent;
import org.apache.skywalking.oap.server.core.query.type.Trace;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.query.type.trace.v2.TraceList;
import org.apache.skywalking.oap.server.core.query.type.trace.v2.TraceV2;
import org.apache.skywalking.oap.server.core.query.type.trace.v2.TracesQueryResult;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryV2DAO;
import org.apache.skywalking.oap.server.core.storage.query.proto.Source;
import org.apache.skywalking.oap.server.core.storage.query.proto.SpanWrapper;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class TraceQueryService
implements Service {
    private final ModuleManager moduleManager;
    private ITraceQueryDAO traceQueryDAO;
    private ISpanAttachedEventQueryDAO spanAttachedEventQueryDAO;
    private IComponentLibraryCatalogService componentLibraryCatalogService;
    private boolean supportTraceV2 = false;

    public TraceQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    protected ITraceQueryDAO getTraceQueryDAO() {
        if (this.traceQueryDAO == null) {
            this.traceQueryDAO = (ITraceQueryDAO)this.moduleManager.find("storage").provider().getService(ITraceQueryDAO.class);
            if (ITraceQueryV2DAO.class.isAssignableFrom(this.traceQueryDAO.getClass())) {
                this.supportTraceV2 = true;
            }
        }
        return this.traceQueryDAO;
    }

    private ISpanAttachedEventQueryDAO getSpanAttachedEventQueryDAO() {
        if (this.spanAttachedEventQueryDAO == null) {
            this.spanAttachedEventQueryDAO = (ISpanAttachedEventQueryDAO)this.moduleManager.find("storage").provider().getService(ISpanAttachedEventQueryDAO.class);
        }
        return this.spanAttachedEventQueryDAO;
    }

    protected IComponentLibraryCatalogService getComponentLibraryCatalogService() {
        if (this.componentLibraryCatalogService == null) {
            this.componentLibraryCatalogService = (IComponentLibraryCatalogService)this.moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
        }
        return this.componentLibraryCatalogService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceBrief queryBasicTraces(String serviceId, String serviceInstanceId, String endpointId, String traceId, int minTraceDuration, int maxTraceDuration, TraceState traceState, QueryOrder queryOrder, Pagination paging, Duration duration, List<Tag> tags) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                StringBuilder msg = new StringBuilder();
                span = traceContext.createSpan("Query Service: queryBasicTraces");
                msg.append("Condition: ServiceId: ").append(serviceId).append(", ServiceInstanceId: ").append(serviceInstanceId).append(", EndpointId: ").append(endpointId).append(", TraceId: ").append(traceId).append(", MinTraceDuration: ").append(minTraceDuration).append(", MaxTraceDuration: ").append(maxTraceDuration).append(", TraceState: ").append((Object)traceState).append(", QueryOrder: ").append((Object)queryOrder).append(", Pagination: ").append(paging).append(", Duration: ").append(duration).append(", Tags: ").append(tags);
                span.setMsg(msg.toString());
            }
            PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(paging);
            TraceBrief traceBrief = this.getTraceQueryDAO().queryBasicTracesDebuggable(duration, minTraceDuration, maxTraceDuration, serviceId, serviceInstanceId, endpointId, traceId, page.getLimit(), page.getFrom(), traceState, queryOrder, tags);
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            return traceBrief;
        }
        catch (Throwable throwable) {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trace queryTrace(String traceId, @Nullable Duration duration) throws IOException {
        Trace trace;
        DebuggingSpan span;
        DebuggingTraceContext traceContext;
        block7: {
            traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
            span = null;
            try {
                if (traceContext != null) {
                    StringBuilder msg = new StringBuilder();
                    span = traceContext.createSpan("Query Service: queryTrace");
                    msg.append("Condition: TraceId: ").append(traceId);
                    span.setMsg(msg.toString());
                }
                this.getTraceQueryDAO();
                if (!this.supportTraceV2) break block7;
                trace = this.invokeQueryTraceV2(traceId, duration);
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                return trace;
            }
            catch (Throwable throwable) {
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                throw throwable;
            }
        }
        trace = this.invokeQueryTrace(traceId, duration);
        if (traceContext != null && span != null) {
            traceContext.stopSpan(span);
        }
        return trace;
    }

    public TraceList queryTraces(TraceQueryCondition condition) throws IOException {
        block6: {
            DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
            DebuggingSpan span = null;
            try {
                if (traceContext != null) {
                    StringBuilder msg = new StringBuilder();
                    span = traceContext.createSpan("Query Service: queryTraces");
                    msg.append("Condition: TraceQueryCondition: ").append(condition);
                    span.setMsg(msg.toString());
                }
                this.getTraceQueryDAO();
                if (!this.supportTraceV2) break block6;
                TraceList traceList = this.invokeQueryTraces(condition);
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                return traceList;
            }
            catch (Throwable throwable) {
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                throw throwable;
            }
        }
        throw new UnsupportedOperationException("Only BanyanDB storage support Trace V2 query now.");
    }

    public boolean hasQueryTracesV2Support() {
        this.getTraceQueryDAO();
        return this.isSupportTraceV2();
    }

    private Trace invokeQueryTrace(String traceId, @Nullable Duration duration) throws IOException {
        Trace trace = new Trace();
        List<SegmentRecord> segmentRecords = this.getTraceQueryDAO().queryByTraceIdDebuggable(traceId, duration);
        if (segmentRecords.isEmpty()) {
            trace.getSpans().addAll(this.getTraceQueryDAO().doFlexibleTraceQuery(traceId));
        } else {
            for (SegmentRecord segment : segmentRecords) {
                if (!Objects.nonNull(segment)) continue;
                SegmentObject segmentObject = SegmentObject.parseFrom((byte[])segment.getDataBinary());
                trace.getSpans().addAll(this.buildSpanList(segmentObject));
            }
        }
        List<Span> sortedSpans = this.sortSpans(trace.getSpans());
        if (CollectionUtils.isNotEmpty(sortedSpans)) {
            List<SWSpanAttachedEventRecord> spanAttachedEvents = this.getSpanAttachedEventQueryDAO().querySWSpanAttachedEventsDebuggable(SpanAttachedEventTraceType.SKYWALKING, Arrays.asList(traceId), duration);
            ArrayList<org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent> events = new ArrayList<org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent>();
            for (SWSpanAttachedEventRecord record : spanAttachedEvents) {
                events.add(org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent.parseFrom((byte[])record.getDataBinary()));
            }
            this.appendAttachedEventsToSpanDebuggable(sortedSpans, events);
        }
        trace.getSpans().clear();
        trace.getSpans().addAll(sortedSpans);
        return trace;
    }

    private Trace invokeQueryTraceV2(String traceId, @Nullable Duration duration) throws IOException {
        Trace trace = new Trace();
        List<SpanWrapper> spanWrappers = ((ITraceQueryV2DAO)this.getTraceQueryDAO()).queryByTraceIdV2(traceId, duration);
        if (CollectionUtils.isNotEmpty(spanWrappers)) {
            ArrayList<org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent> events = new ArrayList<org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent>();
            for (SpanWrapper spanWrapper : spanWrappers) {
                if (spanWrapper.getSource().equals((Object)Source.SKYWALKING)) {
                    SegmentObject segmentObject = SegmentObject.parseFrom((ByteString)spanWrapper.getSpan());
                    trace.getSpans().addAll(this.buildSpanList(segmentObject));
                    continue;
                }
                if (!spanWrapper.getSource().equals((Object)Source.SKYWALKING_EVENT)) continue;
                org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent event = org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent.parseFrom((ByteString)spanWrapper.getSpan());
                events.add(event);
            }
            List<Span> sortedSpans = this.sortSpans(trace.getSpans());
            this.appendAttachedEventsToSpanDebuggable(sortedSpans, events);
            trace.getSpans().clear();
            trace.getSpans().addAll(sortedSpans);
        }
        return trace;
    }

    private TraceList invokeQueryTraces(TraceQueryCondition condition) throws IOException {
        TracesQueryResult tracesResult = ((ITraceQueryV2DAO)this.getTraceQueryDAO()).queryTracesDebuggable(condition);
        TraceList traceList = new TraceList(tracesResult.getRetrievedTimeRange());
        ArrayList<TraceV2> traces = new ArrayList<TraceV2>();
        for (List<SpanWrapper> spans : tracesResult.getTraces()) {
            TraceV2 trace = new TraceV2();
            ArrayList<org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent> events = new ArrayList<org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent>();
            for (SpanWrapper spanWrapper : spans) {
                if (spanWrapper.getSource().equals((Object)Source.SKYWALKING)) {
                    SegmentObject segmentObject = SegmentObject.parseFrom((ByteString)spanWrapper.getSpan());
                    trace.getSpans().addAll(this.buildSpanList(segmentObject));
                    continue;
                }
                if (!spanWrapper.getSource().equals((Object)Source.SKYWALKING_EVENT)) continue;
                org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent event = org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent.parseFrom((ByteString)spanWrapper.getSpan());
                events.add(event);
            }
            List<Span> sortedSpans = this.sortSpans(trace.getSpans());
            trace.getSpans().clear();
            trace.getSpans().addAll(sortedSpans);
            this.appendAttachedEventsToSpanDebuggable(sortedSpans, events);
            traces.add(trace);
        }
        traceList.getTraces().addAll(traces);
        return traceList;
    }

    private List<Span> buildSpanList(SegmentObject segmentObject) {
        ArrayList<Span> spans = new ArrayList<Span>();
        segmentObject.getSpansList().forEach(spanObject -> {
            Span span = new Span();
            span.setTraceId(segmentObject.getTraceId());
            span.setSegmentId(segmentObject.getTraceSegmentId());
            span.setSpanId(spanObject.getSpanId());
            span.setParentSpanId(spanObject.getParentSpanId());
            span.setStartTime(spanObject.getStartTime());
            span.setEndTime(spanObject.getEndTime());
            span.setError(spanObject.getIsError());
            span.setLayer(spanObject.getSpanLayer().name());
            span.setType(spanObject.getSpanType().name());
            String segmentSpanId = segmentObject.getTraceSegmentId() + "S" + spanObject.getSpanId();
            span.setSegmentSpanId(segmentSpanId);
            String segmentParentSpanId = segmentObject.getTraceSegmentId() + "S" + spanObject.getParentSpanId();
            span.setSegmentParentSpanId(segmentParentSpanId);
            span.setPeer(spanObject.getPeer());
            span.setEndpointName(spanObject.getOperationName());
            span.setServiceCode(segmentObject.getService());
            span.setServiceInstanceName(segmentObject.getServiceInstance());
            span.setComponent(this.getComponentLibraryCatalogService().getComponentName(spanObject.getComponentId()));
            spanObject.getRefsList().forEach(reference -> {
                Ref ref = new Ref();
                ref.setTraceId(reference.getTraceId());
                ref.setParentSegmentId(reference.getParentTraceSegmentId());
                switch (reference.getRefType()) {
                    case CrossThread: {
                        ref.setType(RefType.CROSS_THREAD);
                        break;
                    }
                    case CrossProcess: {
                        ref.setType(RefType.CROSS_PROCESS);
                    }
                }
                ref.setParentSpanId(reference.getParentSpanId());
                span.setSegmentParentSpanId(ref.getParentSegmentId() + "S" + ref.getParentSpanId());
                span.getRefs().add(ref);
            });
            spanObject.getTagsList().forEach(tag -> {
                KeyValue keyValue = new KeyValue();
                keyValue.setKey(tag.getKey());
                keyValue.setValue(tag.getValue());
                span.getTags().add(keyValue);
            });
            spanObject.getLogsList().forEach(log -> {
                LogEntity logEntity = new LogEntity();
                logEntity.setTime(log.getTime());
                log.getDataList().forEach(data -> {
                    KeyValue keyValue = new KeyValue();
                    keyValue.setKey(data.getKey());
                    keyValue.setValue(data.getValue());
                    logEntity.getData().add(keyValue);
                });
                span.getLogs().add(logEntity);
            });
            spans.add(span);
        });
        return spans;
    }

    private List<Span> sortSpans(List<Span> spans) {
        List<Span> rootSpans;
        LinkedList<Span> sortedSpans = new LinkedList<Span>();
        if (CollectionUtils.isNotEmpty(spans) && CollectionUtils.isNotEmpty(rootSpans = this.findRoot(spans))) {
            rootSpans.forEach(span -> {
                ArrayList<Span> childrenSpan = new ArrayList<Span>();
                childrenSpan.add((Span)span);
                this.findChildren(spans, (Span)span, (List<Span>)childrenSpan);
                sortedSpans.addAll(childrenSpan);
            });
        }
        return sortedSpans;
    }

    private List<Span> findRoot(List<Span> spans) {
        ArrayList<Span> rootSpans = new ArrayList<Span>();
        spans.forEach(span -> {
            String segmentParentSpanId = span.getSegmentParentSpanId();
            boolean hasParent = false;
            for (Span subSpan : spans) {
                if (!segmentParentSpanId.equals(subSpan.getSegmentSpanId())) continue;
                hasParent = true;
                break;
            }
            if (!hasParent) {
                span.setRoot(true);
                rootSpans.add((Span)span);
            }
        });
        rootSpans.sort(Comparator.comparing(Span::getStartTime));
        return rootSpans;
    }

    private void findChildren(List<Span> spans, Span parentSpan, List<Span> childrenSpan) {
        spans.forEach(span -> {
            if (span.getSegmentParentSpanId().equals(parentSpan.getSegmentSpanId())) {
                childrenSpan.add((Span)span);
                this.findChildren(spans, (Span)span, childrenSpan);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAttachedEventsToSpanDebuggable(List<Span> spans, List<org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent> events) throws InvalidProtocolBufferException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan debuggingSpan = null;
        try {
            if (traceContext != null) {
                debuggingSpan = traceContext.createSpan("Query Service : appendAttachedEventsToSpan");
            }
            this.appendAttachedEventsToSpan(spans, events);
        }
        finally {
            if (traceContext != null && debuggingSpan != null) {
                traceContext.stopSpan(debuggingSpan);
            }
        }
    }

    private void appendAttachedEventsToSpan(List<Span> spans, List<org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent> events) throws InvalidProtocolBufferException {
        if (CollectionUtils.isEmpty(events)) {
            return;
        }
        events.sort((e1, e2) -> {
            int second = Long.compare(e1.getStartTime().getSeconds(), e2.getStartTime().getSeconds());
            if (second == 0) {
                return Long.compare(e1.getStartTime().getNanos(), e2.getStartTime().getNanos());
            }
            return second;
        });
        HashMap<CallSite, Span> spanMatcher = new HashMap<CallSite, Span>();
        for (org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent event : events) {
            if (!StringUtils.isNumeric((CharSequence)event.getTraceContext().getSpanId())) continue;
            SpanAttachedEvent.SpanReference spanReference = event.getTraceContext();
            String spanMatcherKey = spanReference.getTraceSegmentId() + "_" + spanReference.getSpanId();
            Span span = (Span)spanMatcher.get(spanMatcherKey);
            if (span == null) {
                int eventSpanId = Integer.parseInt(spanReference.getSpanId());
                span = spans.stream().filter(s -> Objects.equals(s.getSegmentId(), spanReference.getTraceSegmentId()) && s.getSpanId() == eventSpanId).findFirst().orElse(null);
                if (span == null) continue;
                String direction = this.getSpanAttachedEventTagValue(event.getTagsList(), "data_direction");
                String type = this.getSpanAttachedEventTagValue(event.getTagsList(), "data_type");
                if ("request".equals(type) && "inbound".equals(direction) || "response".equals(type) && "outbound".equals(direction)) {
                    String parentSpanId = span.getSegmentSpanId();
                    span = spans.stream().filter(s -> s.getSegmentParentSpanId().equals(parentSpanId) && Objects.equals(s.getType(), SpanType.Entry.name())).findFirst().orElse(span);
                }
                spanMatcher.put((CallSite)((Object)spanMatcherKey), span);
            }
            span.getAttachedEvents().add(this.parseEvent(event));
        }
    }

    private String getSpanAttachedEventTagValue(List<KeyStringValuePair> values, String tagKey) {
        for (KeyStringValuePair pair : values) {
            if (!Objects.equals(pair.getKey(), tagKey)) continue;
            return pair.getValue();
        }
        return null;
    }

    private SpanAttachedEvent parseEvent(org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent event) {
        SpanAttachedEvent result = new SpanAttachedEvent();
        result.getStartTime().setSeconds(event.getStartTime().getSeconds());
        result.getStartTime().setNanos(event.getStartTime().getNanos());
        result.getEndTime().setSeconds(event.getEndTime().getSeconds());
        result.getEndTime().setNanos(event.getEndTime().getNanos());
        result.setEvent(event.getEvent());
        for (KeyStringValuePair tag : event.getTagsList()) {
            result.getTags().add(new KeyValue(tag.getKey(), tag.getValue()));
        }
        for (KeyIntValuePair pair : event.getSummaryList()) {
            result.getSummary().add(new KeyNumericValue(pair.getKey(), pair.getValue()));
        }
        return result;
    }

    @Generated
    public boolean isSupportTraceV2() {
        return this.supportTraceV2;
    }
}

