/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.graphql.protocol;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.graphql.protocol.DefaultGraphqlRequest;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@UnstableApi
public interface GraphqlRequest {
    public static GraphqlRequest of(String query) {
        return GraphqlRequest.of(query, null, (Map<String, Object>)ImmutableMap.of(), (Map<String, Object>)ImmutableMap.of());
    }

    public static GraphqlRequest of(String query, @Nullable String operationName, Map<String, Object> variables, Map<String, Object> extensions) {
        Objects.requireNonNull(query, "query");
        Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query is empty");
        Objects.requireNonNull(variables, "variables");
        Objects.requireNonNull(extensions, "extensions");
        return new DefaultGraphqlRequest(query, operationName, variables, extensions);
    }

    public String query();

    @Nullable
    public String operationName();

    public Map<String, Object> variables();

    public Map<String, Object> extensions();
}

