/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config.annotations;

import java.util.Map;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.annotations.TypedConfig;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface ConfigCollection {
    public Stream<TypedConfig> stream();

    default public <T> Stream<TypedConfig<T>> stream(@NotNull Class<T> configType) {
        return this.stream().flatMap(entry -> entry.stream(configType));
    }

    default public <T> Stream<T> configStream(@NotNull Class<T> configType) {
        return this.stream().flatMap(entry -> entry.configStream(configType));
    }

    default public <T> T firstConfig(@NotNull Class<T> configType) {
        return this.configStream(configType).findFirst().orElseThrow();
    }

    default public <T> Map<String, Object> firstConfigMap(@NotNull Class<T> configType) {
        return this.stream(configType).findFirst().orElseThrow().getConfigMap();
    }
}

