/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.variant.VariantCastArgs;
import org.apache.spark.sql.catalyst.expressions.variant.VariantGet$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader$;
import org.apache.spark.sql.execution.datasources.parquet.SparkShreddedRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.types.variant.ShreddingUtils;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantBuilder;
import org.apache.spark.types.variant.VariantSchema;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\t\u0013\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005U!A1\u0007\u0001BC\u0002\u0013\u0005A\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u00036\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\u001d\u0003A\u0011\u0001%\t\u000b9\u0003A\u0011A(\t\u000b\u0005\u0004A\u0011\u00032\t\u000b\u0015\u0004AQ\u00034\t\u000b1\u0004AQC7\b\u000bA\u0014\u0002\u0012A9\u0007\u000bE\u0011\u0002\u0012\u0001:\t\u000b\u001dkA\u0011A:\t\u000bQlA\u0011A;\t\u000fyl\u0011\u0013!C\u0001\u007f\n!\u0002+\u0019:rk\u0016$h+\u0019:jC:$(+Z1eKJT!a\u0005\u000b\u0002\u000fA\f'/];fi*\u0011QCF\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u00181\u0005IQ\r_3dkRLwN\u001c\u0006\u00033i\t1a]9m\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017AB:dQ\u0016l\u0017-F\u0001+!\tY\u0003'D\u0001-\u0015\tic&A\u0004wCJL\u0017M\u001c;\u000b\u0005=R\u0012!\u0002;za\u0016\u001c\u0018BA\u0019-\u000551\u0016M]5b]R\u001c6\r[3nC\u000691o\u00195f[\u0006\u0004\u0013A\u0003;be\u001e,G\u000fV=qKV\tQ\u0007\u0005\u00027q5\tqG\u0003\u000201%\u0011\u0011h\u000e\u0002\t\t\u0006$\u0018\rV=qK\u0006YA/\u0019:hKR$\u0016\u0010]3!\u0003!\u0019\u0017m\u001d;Be\u001e\u001cX#A\u001f\u0011\u0005y\"U\"A \u000b\u00055\u0002%BA!C\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\rC\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005\u0015{$a\u0004,be&\fg\u000e^\"bgR\f%oZ:\u0002\u0013\r\f7\u000f^!sON\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003J\u00172k\u0005C\u0001&\u0001\u001b\u0005\u0011\u0002\"\u0002\u0015\b\u0001\u0004Q\u0003\"B\u001a\b\u0001\u0004)\u0004\"B\u001e\b\u0001\u0004i\u0014\u0001\u0002:fC\u0012$2\u0001U*Z!\t\u0019\u0013+\u0003\u0002SI\t\u0019\u0011I\\=\t\u000bQC\u0001\u0019A+\u0002\u0007I|w\u000f\u0005\u0002W/6\t!)\u0003\u0002Y\u0005\nY\u0011J\u001c;fe:\fGNU8x\u0011\u0015Q\u0006\u00021\u0001\\\u0003A!x\u000e\u001d'fm\u0016dW*\u001a;bI\u0006$\u0018\rE\u0002$9zK!!\u0018\u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\rz\u0016B\u00011%\u0005\u0011\u0011\u0015\u0010^3\u0002\u001bI,\u0017\r\u001a$s_6$\u0016\u0010]3e)\r\u00016\r\u001a\u0005\u0006)&\u0001\r!\u0016\u0005\u00065&\u0001\raW\u0001\u000fe\u0016\u0014W/\u001b7e-\u0006\u0014\u0018.\u00198u)\r9'n\u001b\t\u0003W!L!!\u001b\u0017\u0003\u000fY\u000b'/[1oi\")AK\u0003a\u0001+\")!L\u0003a\u00017\u0006Y\u0011N\u001c<bY&$7)Y:u)\r\u0001fn\u001c\u0005\u0006).\u0001\r!\u0016\u0005\u00065.\u0001\raW\u0001\u0015!\u0006\u0014\u0018/^3u-\u0006\u0014\u0018.\u00198u%\u0016\fG-\u001a:\u0011\u0005)k1CA\u0007#)\u0005\t\u0018!B1qa2LH#B%wobL\b\"\u0002\u0015\u0010\u0001\u0004Q\u0003\"B\u001a\u0010\u0001\u0004)\u0004\"B\u001e\u0010\u0001\u0004i\u0004b\u0002>\u0010!\u0003\u0005\ra_\u0001\u0015SN$v\u000e\u001d'fm\u0016dWK\\:ie\u0016$G-\u001a3\u0011\u0005\rb\u0018BA?%\u0005\u001d\u0011un\u001c7fC:\fq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0003Q3a_A\u0002W\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u0013Ut7\r[3dW\u0016$'bAA\bI\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0011\u0011\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ParquetVariantReader {
    private final VariantSchema schema;
    private final DataType targetType;
    private final VariantCastArgs castArgs;

    public static boolean apply$default$4() {
        return ParquetVariantReader$.MODULE$.apply$default$4();
    }

    public static ParquetVariantReader apply(VariantSchema schema, DataType targetType, VariantCastArgs castArgs, boolean isTopLevelUnshredded) {
        return ParquetVariantReader$.MODULE$.apply(schema, targetType, castArgs, isTopLevelUnshredded);
    }

    public VariantSchema schema() {
        return this.schema;
    }

    public DataType targetType() {
        return this.targetType;
    }

    public VariantCastArgs castArgs() {
        return this.castArgs;
    }

    public Object read(InternalRow row, byte[] topLevelMetadata) {
        if (this.schema().typedIdx < 0 || row.isNullAt(this.schema().typedIdx)) {
            if (this.schema().variantIdx < 0 || row.isNullAt(this.schema().variantIdx)) {
                throw QueryExecutionErrors$.MODULE$.malformedVariant();
            }
            Variant v = new Variant(row.getBinary(this.schema().variantIdx), topLevelMetadata);
            return VariantGet$.MODULE$.cast(v, this.targetType(), this.castArgs());
        }
        return this.readFromTyped(row, topLevelMetadata);
    }

    public Object readFromTyped(InternalRow row, byte[] topLevelMetadata) {
        throw QueryExecutionErrors$.MODULE$.unreachableError(QueryExecutionErrors$.MODULE$.unreachableError$default$1());
    }

    public final Variant rebuildVariant(InternalRow row, byte[] topLevelMetadata) {
        VariantBuilder builder = new VariantBuilder(false);
        ShreddingUtils.rebuild((ShreddingUtils.ShreddedRow)new SparkShreddedRow((SpecializedGetters)row), (byte[])topLevelMetadata, (VariantSchema)this.schema(), (VariantBuilder)builder);
        return builder.result();
    }

    public final Object invalidCast(InternalRow row, byte[] topLevelMetadata) {
        if (this.castArgs().failOnError()) {
            throw QueryExecutionErrors$.MODULE$.invalidVariantCast(this.rebuildVariant(row, topLevelMetadata).toJson(this.castArgs().zoneId()), this.targetType());
        }
        return null;
    }

    public ParquetVariantReader(VariantSchema schema, DataType targetType, VariantCastArgs castArgs) {
        this.schema = schema;
        this.targetType = targetType;
        this.castArgs = castArgs;
    }
}

