/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.LineageItem;
import org.apache.spark.util.NextIterator;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005}b!\u0002\n\u0014\u0003\u0003\u0011\u0003\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011-\u0003!\u0011!Q\u0001\n1C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\u00067\u0002!\t\u0001\u0018\u0005\bC\u0002\u0011\r\u0011b\u0001c\u0011\u0019I\u0007\u0001)A\u0005G\")!\u000e\u0001C\u0005W\"AQ\u000f\u0001EC\u0002\u0013%a\u000fC\u0004{\u0001\t\u0007I\u0011C>\t\rq\u0004\u0001\u0015!\u0003m\u0011\u0015i\b\u0001\"\u0005\u007f\u0011\u001d\t)\u0002\u0001C\t\u0003/Aq!a\b\u0001\t\u0013\t\t\u0003\u0003\u0006\u0002,\u0001A)\u0019!C\u0001\u0003[Aq!a\f\u0001\r\u0003\t\t\u0004C\u0004\u0002:\u0001!\t&a\u0006\t\u000f\u0005m\u0002A\"\u0011\u0002>\tI2\u000b^1uKN#xN]3DQ\u0006tw-\u001a7pOJ+\u0017\rZ3s\u0015\t!R#A\u0003ti\u0006$XM\u0003\u0002\u0017/\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00031e\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005iY\u0012aA:rY*\u0011A$H\u0001\u0006gB\f'o\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019c\bE\u0002%O%j\u0011!\n\u0006\u0003Mm\tA!\u001e;jY&\u0011\u0001&\n\u0002\r\u001d\u0016DH/\u0013;fe\u0006$xN\u001d\t\u0006U5z\u0003\bO\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1A+\u001e9mKN\u0002\"\u0001\r\u001b\u000f\u0005E\u0012T\"A\n\n\u0005M\u001a\u0012A\u0003*fG>\u0014H\rV=qK&\u0011QG\u000e\u0002\u0006-\u0006dW/Z\u0005\u0003o-\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]B\u0019!&O\u001e\n\u0005iZ#!B!se\u0006L\bC\u0001\u0016=\u0013\ti4F\u0001\u0003CsR,\u0007CA C\u001b\u0005\u0001%BA!\u001c\u0003!Ig\u000e^3s]\u0006d\u0017BA\"A\u0005\u001daunZ4j]\u001e\f!AZ7\u0011\u0005\u0019KU\"A$\u000b\u0005!+\u0012!D2iK\u000e\\\u0007o\\5oi&tw-\u0003\u0002K\u000f\n)2\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014\u0018A\u00034jY\u0016$vNU3bIB\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0003MNT!!U\u000f\u0002\r!\fGm\\8q\u0013\t\u0019fJ\u0001\u0003QCRD\u0017\u0001E2p[B\u0014Xm]:j_:\u001cu\u000eZ3d!\t1\u0016,D\u0001X\u0015\tA6$\u0001\u0002j_&\u0011!l\u0016\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000e\fa\u0001P5oSRtD\u0003B/_?\u0002\u0004\"!\r\u0001\t\u000b\u0011#\u0001\u0019A#\t\u000b-#\u0001\u0019\u0001'\t\u000bQ#\u0001\u0019A+\u0002\u000f\u0019|'/\\1ugV\t1\r\u0005\u0002eO6\tQM\u0003\u0002g?\u00051!n]8oiML!\u0001[3\u0003\u000f\u0019{'/\\1ug\u0006Aam\u001c:nCR\u001c\b%\u0001\teK\u000e|W\u000e\u001d:fgN\u001cFO]3b[R\u0011An\u001d\t\u0003[Fl\u0011A\u001c\u0006\u00031>T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s]\nyA)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003u\u000f\u0001\u0007A.A\u0006j]B,Ho\u0015;sK\u0006l\u0017\u0001D:pkJ\u001cWm\u0015;sK\u0006lW#A<\u0011\u00055C\u0018BA=O\u0005E15\u000bR1uC&s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0006S:\u0004X\u000f^\u000b\u0002Y\u00061\u0011N\u001c9vi\u0002\n1B]3bIZ+'o]5p]R\tq\u0010\u0005\u0003\u0002\u0002\u0005=a\u0002BA\u0002\u0003\u0017\u00012!!\u0002,\u001b\t\t9AC\u0002\u0002\n\u0005\na\u0001\u0010:p_Rt\u0014bAA\u0007W\u00051\u0001K]3eK\u001aLA!!\u0005\u0002\u0014\t11\u000b\u001e:j]\u001eT1!!\u0004,\u000351XM]5gsZ+'o]5p]R\u0011\u0011\u0011\u0004\t\u0004U\u0005m\u0011bAA\u000fW\t!QK\\5u\u0003-\u0011X-\u00193MS:,\u0017mZ3\u0015\u0005\u0005\r\u0002\u0003\u0002\u0016:\u0003K\u00012!MA\u0014\u0013\r\tIc\u0005\u0002\f\u0019&tW-Y4f\u0013R,W.A\u0004mS:,\u0017mZ3\u0016\u0005\u0005\r\u0012a\u0002<feNLwN\\\u000b\u0003\u0003g\u00012AKA\u001b\u0013\r\t9d\u000b\u0002\u0006'\"|'\u000f^\u0001\u0006G2|7/Z\u0001\bO\u0016$h*\u001a=u)\u0005I\u0003")
public abstract class StateStoreChangelogReader
extends NextIterator<Tuple3<Enumeration.Value, byte[], byte[]>>
implements Logging {
    private FSDataInputStream sourceStream;
    private LineageItem[] lineage;
    private final CheckpointFileManager fm;
    private final Path fileToRead;
    private final CompressionCodec compressionCodec;
    private final Formats formats;
    private final DataInputStream input;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Formats formats() {
        return this.formats;
    }

    private DataInputStream decompressStream(DataInputStream inputStream) {
        InputStream compressed = this.compressionCodec.compressedInputStream((InputStream)inputStream);
        return new DataInputStream(compressed);
    }

    private FSDataInputStream sourceStream$lzycompute() {
        StateStoreChangelogReader stateStoreChangelogReader = this;
        synchronized (stateStoreChangelogReader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sourceStream = this.liftedTree3$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sourceStream;
    }

    private FSDataInputStream sourceStream() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sourceStream$lzycompute();
        }
        return this.sourceStream;
    }

    public DataInputStream input() {
        return this.input;
    }

    public String readVersion() {
        return this.input().readUTF();
    }

    public void verifyVersion() {
        String changelogVersionStr;
        String string = changelogVersionStr = this.readVersion();
        String string2 = "v" + this.version();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Changelog version mismatch: " + changelogVersionStr + " != v" + this.version());
    }

    private LineageItem[] readLineage() {
        Predef$.MODULE$.assert(this.version() >= 3, (Function0 & Serializable)() -> "readLineage should only be invoked with state store checkpoint id enabled (version >= 3)");
        String lineageStr = this.input().readUTF();
        return (LineageItem[])Serialization$.MODULE$.read(lineageStr, this.formats(), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(LineageItem.class)));
    }

    private LineageItem[] lineage$lzycompute() {
        StateStoreChangelogReader stateStoreChangelogReader = this;
        synchronized (stateStoreChangelogReader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.lineage = this.readLineage();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.lineage;
    }

    public LineageItem[] lineage() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.lineage$lzycompute();
        }
        return this.lineage;
    }

    public abstract short version();

    public void close() {
        if (this.input() != null) {
            this.input().close();
            return;
        }
    }

    public abstract Tuple3<Enumeration.Value, byte[], byte[]> getNext();

    private final /* synthetic */ FSDataInputStream liftedTree3$1() {
        FSDataInputStream fSDataInputStream;
        try {
            fSDataInputStream = this.fm.open(this.fileToRead);
        }
        catch (FileNotFoundException f) {
            throw QueryExecutionErrors$.MODULE$.failedToReadStreamingStateFileError(this.fileToRead, (Throwable)f);
        }
        return fSDataInputStream;
    }

    public StateStoreChangelogReader(CheckpointFileManager fm, Path fileToRead, CompressionCodec compressionCodec) {
        this.fm = fm;
        this.fileToRead = fileToRead;
        this.compressionCodec = compressionCodec;
        Logging.$init$((Logging)this);
        this.formats = DefaultFormats$.MODULE$;
        this.input = this.decompressStream((DataInputStream)this.sourceStream());
    }
}

