/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;

public class DeleteFieldManager
extends AbstractFieldManager {
    private final ObjectProvider op;
    private boolean manageRelationships = false;

    public DeleteFieldManager(ObjectProvider op) {
        this(op, false);
    }

    public DeleteFieldManager(ObjectProvider op, boolean manageRelationships) {
        this.op = op;
        this.manageRelationships = manageRelationships;
    }

    protected void processPersistable(Object pc) {
        ObjectProvider pcOP = this.op.getExecutionContext().findObjectProvider(pc);
        if (pcOP != null && (pcOP.isDeleting() || pcOP.becomingDeleted())) {
            return;
        }
        this.op.getExecutionContext().deleteObjectInternal(pc);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        block9: {
            ApiAdapter api;
            AbstractMemberMetaData mmd;
            block15: {
                block13: {
                    RelationType relationType;
                    ExecutionContext ec;
                    block14: {
                        block10: {
                            AbstractMemberMetaData relMmd;
                            ObjectProvider valueOP;
                            block12: {
                                block11: {
                                    if (value == null) break block9;
                                    mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                                    relationType = mmd.getRelationType((ec = this.op.getExecutionContext()).getClassLoaderResolver());
                                    if (!RelationType.isRelationSingleValued(relationType)) break block10;
                                    if (!mmd.isDependent()) break block11;
                                    this.processPersistable(value);
                                    break block9;
                                }
                                if (!this.manageRelationships || !RelationType.isBidirectional(relationType) || mmd.isEmbedded() || (valueOP = ec.findObjectProvider(value)) == null || valueOP.getLifecycleState().isDeleted() || valueOP.isDeleting()) break block9;
                                relMmd = mmd.getRelatedMemberMetaData(ec.getClassLoaderResolver())[0];
                                if (relationType != RelationType.ONE_TO_ONE_BI) break block12;
                                valueOP.replaceFieldMakeDirty(relMmd.getAbsoluteFieldNumber(), null);
                                valueOP.flush();
                                break block9;
                            }
                            if (relationType != RelationType.MANY_TO_ONE_BI) break block9;
                            valueOP.loadField(relMmd.getAbsoluteFieldNumber());
                            Object relValue = valueOP.provideField(relMmd.getAbsoluteFieldNumber());
                            if (relValue != null && relValue instanceof Collection) {
                                ((Collection)relValue).remove(this.op.getObject());
                            }
                            break block9;
                        }
                        if (!RelationType.isRelationMultiValued(relationType)) break block9;
                        api = ec.getApiAdapter();
                        if (!(value instanceof Collection)) break block13;
                        boolean dependent = mmd.getCollection().isDependentElement();
                        if (mmd.isCascadeRemoveOrphans()) {
                            dependent = true;
                        }
                        if (!dependent) break block14;
                        Collection coll = (Collection)value;
                        for (Object element : coll) {
                            if (!api.isPersistable(element)) continue;
                            this.processPersistable(element);
                        }
                        break block9;
                    }
                    if (!this.manageRelationships || !RelationType.isBidirectional(relationType) || mmd.isEmbedded() || mmd.getCollection().isEmbeddedElement() || relationType != RelationType.ONE_TO_MANY_BI) break block9;
                    Collection coll = (Collection)value;
                    for (Object element : coll) {
                        ObjectProvider elementOP;
                        if (!api.isPersistable(element) || (elementOP = ec.findObjectProvider(element)) == null || elementOP.getLifecycleState().isDeleted() || elementOP.isDeleting()) continue;
                        AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(ec.getClassLoaderResolver())[0];
                        elementOP.replaceFieldMakeDirty(relMmd.getAbsoluteFieldNumber(), null);
                        elementOP.flush();
                    }
                    break block9;
                }
                if (!(value instanceof Map)) break block15;
                Map map = (Map)value;
                if (mmd.hasMap() && mmd.getMap().isDependentKey()) {
                    Set keys = map.keySet();
                    for (Object mapKey : keys) {
                        if (!api.isPersistable(mapKey)) continue;
                        this.processPersistable(mapKey);
                    }
                }
                if (!mmd.hasMap() || !mmd.getMap().isDependentValue()) break block9;
                Collection values = map.values();
                for (Object mapValue : values) {
                    if (!api.isPersistable(mapValue)) continue;
                    this.processPersistable(mapValue);
                }
                break block9;
            }
            if (value instanceof Object[] && mmd.hasArray() && mmd.getArray().isDependentElement()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    if (!api.isPersistable(element)) continue;
                    this.processPersistable(element);
                }
            }
        }
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
    }
}

