/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TryMakeTimestampNTZExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(year, month, day, hour, min, sec) - Try to create local date-time from year, month, day, hour, min, sec fields. The function returns NULL on invalid inputs.\n\n    _FUNC_(date, time) - Create a local date-time from date and time fields.\n    ", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from\n              0 to 60. If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * date - a date to represent, from 0001-01-01 to 9999-12-31\n      * time - a local time to represent, from 00:00:00 to 23:59:59.999999\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n      > SELECT _FUNC_(2024, 13, 22, 15, 30, 0);\n       NULL\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887');\n       2014-12-28 06:30:45.887\n  ", group="datetime_funcs", since="4.0.0")
@ScalaSignature(bytes="\u0006\u0005Q;Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\nA\u0005\u0016:z\u001b\u0006\\W\rV5nKN$\u0018-\u001c9O)j+\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM\u001d\u0006\u0003\r\u001d\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001\"C\u0001\tG\u0006$\u0018\r\\=ti*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001A\u00111#A\u0007\u0002\u000b\t!CK]=NC.,G+[7fgR\fW\u000e\u001d(U5\u0016C\bO]3tg&|gNQ;jY\u0012,'oE\u0002\u0002-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f!\u001b\u0005q\"BA\u0010\b\u0003!\tg.\u00197zg&\u001c\u0018BA\u0011\u001f\u0005E)\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\tQAY;jY\u0012$2AJ\u00157!\t\u0019r%\u0003\u0002)\u000b\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000b)\u001a\u0001\u0019A\u0016\u0002\u0011\u0019,hn\u0019(b[\u0016\u0004\"\u0001L\u001a\u000f\u00055\n\u0004C\u0001\u0018\u0019\u001b\u0005y#B\u0001\u0019\u0012\u0003\u0019a$o\\8u}%\u0011!\u0007G\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u000231!)aa\u0001a\u0001oA\u0019\u0001(\u0010\u0014\u000f\u0005eZdB\u0001\u0018;\u0013\u0005I\u0012B\u0001\u001f\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!AP \u0003\u0007M+\u0017O\u0003\u0002=1!b\u0011!\u0011#F\u000f\"S5*\u0014(Q#B\u00111CQ\u0005\u0003\u0007\u0016\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-I\u0001G\u0003\u0005](\u0002\t\u0011!A}3UKT\"`Qe,\u0017M\u001d\u0017![>tG\u000f\u001b\u0017!I\u0006LH\u0006\t5pkJd\u0003%\\5oY\u0001\u001aXmY\u0015![\u0001\"&/\u001f\u0011u_\u0002\u001a'/Z1uK\u0002bwnY1mA\u0011\fG/Z\u0017uS6,\u0007E\u001a:p[\u0002JX-\u0019:-A5|g\u000e\u001e5-A\u0011\f\u0017\u0010\f\u0011i_V\u0014H\u0006I7j]2\u00023/Z2!M&,G\u000eZ:/AQCW\r\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA9+F\n\u0014\u0011p]\u0002JgN^1mS\u0012\u0004\u0013N\u001c9viNt#B\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0017\r^3-AQLW.Z\u0015![\u0001\u001a%/Z1uK\u0002\n\u0007\u0005\\8dC2\u0004C-\u0019;f[QLW.\u001a\u0011ge>l\u0007\u0005Z1uK\u0002\ng\u000e\u001a\u0011uS6,\u0007EZ5fY\u0012\u001chF\u0003\u0011!A\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0003%\u000bQQ\u000e\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+Ae,\u0017M\u001d\u0011.AQDW\rI=fCJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002Co\u001c\u0011:seJ$\u0002\t\u0011!A\u0001\u0002#\u0006I7p]RD\u0007%\f\u0011uQ\u0016\u0004Sn\u001c8uQ6zg-L=fCJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002\u0003FS1ok\u0006\u0014\u00180\u000b\u0011u_\u0002\n$\u0007\t\u0015EK\u000e,WNY3sS)\u0001\u0003\u0005\t\u0011!A)\u0002C-Y=![\u0001\"\b.\u001a\u0011eCflsNZ\u0017n_:$\b\u000e\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAM\n$\u0002\t\u0011!A\u0001\u0002#\u0006\t5pkJ\u0004S\u0006\t;iK\u0002Bw.\u001e:._\u001alC-Y=!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000e\t\u0019!i>\u0004#g\r\u0006!A\u0001\u0002\u0003\u0005\t\u0016![&t\u0007%\f\u0011uQ\u0016\u0004S.\u001b8vi\u0016lsNZ\u0017i_V\u0014\b\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\u0002\u0004\u0005^8!keR\u0001\u0005\t\u0011!A\u0001R\u0003e]3dA5\u0002C\u000f[3!g\u0016\u001cwN\u001c3._\u001alS.\u001b8vi\u0016\u0004\u0013M\u001c3!SR\u001c\b%\\5de>lcM]1di&|g\u000e\t;pAI,\u0007O]3tK:$H\u0006\t4s_6T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0007\t;pAY\u0002d\u0006I%gAQDW\rI:fG\u0002\n'oZ;nK:$\b%Z9vC2\u001c\b\u0005^8!mAb\u0003\u0005\u001e5fAM,7m\u001c8eg\u00022\u0017.\u001a7eA%\u001c\be]3u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQ|\u0007\u0005\r\u0011b]\u0012\u0004\u0013\u0007I7j]V$X\rI5tA\u0005$G-\u001a3!i>\u0004C\u000f[3!M&t\u0017\r\u001c\u0011uS6,7\u000f^1na:R\u0001\u0005\t\u0011!A\u0001R\u0003\u0005Z1uK\u0002j\u0003%\u0019\u0011eCR,\u0007\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\u0002\u0004\u0007M\u0019.aEj\u0003'\r\u0011u_\u0002J\u0014(O\u001d.cIj3'\r\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lW\rI\u0017!C\u0002bwnY1mAQLW.\u001a\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007\u0005\r\u0019;aAR\u0004\u0007\r\u0011u_\u0002\u00124GO\u001b:uUJd&O\u001d:seJ$\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f\u0013\u0001T\u0001\u0004\u0004)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u00195Y\u0001\n$\u0007\f\u00113q1\u0002c\u0007\f\u00114a1\u0002C'\u000e\u00189q]J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cQj\u0013GM\u00173q\u0001\u0002dGO\u001a1uQ*d\u0006\u000f\u001d8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0004'M\u001d-AYb\u0003e\r\u0019-AI\u001aD\u0006I\u001b:Y\u00012\u0004'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\n\u0014(\f\u00198[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]VdG\u000e\f\u00118Y\u0001\u0012$\u0007\f\u00112k1\u00023\u0007\r\u0017!a%Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007\r\u001a5Y\u0001\n4\u0007\f\u00113e1\u0002\u0013'\u000e\u0017!gAb\u0003\u0005M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\t\u0006#Vi\n\u001a1cQj\u0013GM\u00173q\u001db\u0003\u0005V%N\u000b\u001e2$h\r\u0019;iUr\u0003\bO\u001c(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00195[E\u0012TF\r\u001d!aYR4\u0007\r\u001e5k9B\u0004h\u000e\u0006!A\u0005)qM]8va\u0006\nq*\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0003I\u000bQ\u0001\u000e\u00181]ABC\u0002A!E\u000b\u001eC%jS'O!F\u0003")
public final class TryMakeTimestampNTZExpressionBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return TryMakeTimestampNTZExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return TryMakeTimestampNTZExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return TryMakeTimestampNTZExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }

    public static Option<FunctionSignature> functionSignature() {
        return TryMakeTimestampNTZExpressionBuilder$.MODULE$.functionSignature();
    }
}

