/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unhex$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Converts hexadecimal `expr` to binary.", examples="\n    Examples:\n      > SELECT decode(_FUNC_('537061726B2053514C'), 'UTF-8');\n       Spark SQL\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001\u0002\u0012$\u0001BB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005V\u0001\tE\t\u0015!\u0003S\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015Y\u0006\u0001\"\u0011R\u0011\u0015a\u0006\u0001\"\u0011R\u0011\u00151\u0006\u0001\"\u0001^\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015Y\u0007\u0001\"\u0011R\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015\t\b\u0001\"\u0015s\u0011\u0015A\b\u0001\"\u0015z\u0011\u001d\ty\u0001\u0001C)\u0003#A\u0011\"a\u0006\u0001\u0003\u0003%\t!!\u0007\t\u0013\u0005}\u0001!%A\u0005\u0002\u0005\u0005\u0002\"CA\u001c\u0001E\u0005I\u0011AA\u001d\u0011%\ti\u0004AA\u0001\n\u0003\ny\u0004C\u0005\u0002R\u0001\t\t\u0011\"\u0001\u0002T!I\u00111\f\u0001\u0002\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003G\u0002\u0011\u0011!C!\u0003KB\u0011\"a\u001d\u0001\u0003\u0003%\t!!\u001e\t\u0013\u0005e\u0004!!A\u0005B\u0005m\u0004\"CA@\u0001\u0005\u0005I\u0011IAA\u000f%\t)kIA\u0001\u0012\u0003\t9K\u0002\u0005#G\u0005\u0005\t\u0012AAU\u0011\u00191&\u0004\"\u0001\u0002B\"I\u00111\u0019\u000e\u0002\u0002\u0013\u0015\u0013Q\u0019\u0005\n\u0003\u000fT\u0012\u0011!CA\u0003\u0013D\u0011\"a4\u001b#\u0003%\t!!\u000f\t\u0013\u0005E'$!A\u0005\u0002\u0006M\u0007\"CAs5E\u0005I\u0011AA\u001d\u0011%\t9OGA\u0001\n\u0013\tIOA\u0003V]\",\u0007P\u0003\u0002%K\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1s%\u0001\u0005dCR\fG._:u\u0015\tA\u0013&A\u0002tc2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011'\u000e\u001d?!\t\u00114'D\u0001$\u0013\t!4EA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0011d'\u0003\u00028G\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$HA\u0004Qe>$Wo\u0019;\u0011\u0005}:eB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u0019u&\u0001\u0004=e>|GOP\u0005\u0002w%\u0011aIO\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Gu\u0005)1\r[5mIV\tA\n\u0005\u00023\u001b&\u0011aj\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%A\u0006gC&dwJ\\#se>\u0014X#\u0001*\u0011\u0005e\u001a\u0016B\u0001+;\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtDc\u0001-Z5B\u0011!\u0007\u0001\u0005\u0006\u0015\u0016\u0001\r\u0001\u0014\u0005\b!\u0016\u0001\n\u00111\u0001S\u00039qW\u000f\u001c7J]R|G.\u001a:b]R\f!dY8oi\u0016DH/\u00138eKB,g\u000eZ3oi\u001a{G\u000eZ1cY\u0016$\"\u0001\u00170\t\u000b}C\u0001\u0019\u0001'\u0002\t\u0015D\bO]\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00012\u0011\u0007}\u001aW-\u0003\u0002e\u0013\n\u00191+Z9\u0011\u0005\u0019LW\"A4\u000b\u0005!<\u0013!\u0002;za\u0016\u001c\u0018B\u00016h\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f\u0003!!\u0017\r^1UsB,W#\u00018\u0011\u0005\u0019|\u0017B\u00019h\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCA:w!\tID/\u0003\u0002vu\t\u0019\u0011I\\=\t\u000b]d\u0001\u0019A:\u0002\u00079,X.A\u0005e_\u001e+gnQ8eKR)!0!\u0001\u0002\fA\u00111P`\u0007\u0002y*\u0011QpI\u0001\bG>$WmZ3o\u0013\tyHP\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\u0019!\u0004a\u0001\u0003\u000b\t1a\u0019;y!\rY\u0018qA\u0005\u0004\u0003\u0013a(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u001bi\u0001\u0019\u0001>\u0002\u0005\u00154\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002Y\u0003'Aa!!\u0006\u000f\u0001\u0004a\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u00061\u0006m\u0011Q\u0004\u0005\b\u0015>\u0001\n\u00111\u0001M\u0011\u001d\u0001v\u0002%AA\u0002I\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002$)\u001aA*!\n,\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\r;\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\tYCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002<)\u001a!+!\n\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u0005\u0005\u0003\u0002D\u00055SBAA#\u0015\u0011\t9%!\u0013\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0017\nAA[1wC&!\u0011qJA#\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u000b\t\u0004s\u0005]\u0013bAA-u\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191/a\u0018\t\u0013\u0005\u0005D#!AA\u0002\u0005U\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002hA)\u0011\u0011NA8g6\u0011\u00111\u000e\u0006\u0004\u0003[R\u0014AC2pY2,7\r^5p]&!\u0011\u0011OA6\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007I\u000b9\b\u0003\u0005\u0002bY\t\t\u00111\u0001t\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u0005\u0013Q\u0010\u0005\n\u0003C:\u0012\u0011!a\u0001\u0003+\na!Z9vC2\u001cHc\u0001*\u0002\u0004\"A\u0011\u0011\r\r\u0002\u0002\u0003\u00071\u000fK\n\u0001\u0003\u000f\u000bi)a$\u0002\u0014\u0006U\u0015\u0011TAN\u0003?\u000b\t\u000bE\u00023\u0003\u0013K1!a#$\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!%\u0002k}3UKT\"`Q\u0015D\bO]\u0015![\u0001\u001auN\u001c<feR\u001c\b\u0005[3yC\u0012,7-[7bY\u0002\u0002W\r\u001f9sA\u0002\"x\u000e\t2j]\u0006\u0014\u0018PL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qS\u0001a\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\"WmY8eK\"zf)\u0016(D?\":SgM\u001c1mE:$G\u000e\"3aU\u001aT'\r\u001bDO%b\u0003eJ+U\r6Bt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!'B\f'o\u001b\u0011T#2S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003;\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!a)\u0002\u00155\fG\u000f[0gk:\u001c7/A\u0003V]\",\u0007\u0010\u0005\u000235M)!$a+\u00028B9\u0011QVAZ\u0019JCVBAAX\u0015\r\t\tLO\u0001\beVtG/[7f\u0013\u0011\t),a,\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002:\u0006}VBAA^\u0015\u0011\ti,!\u0013\u0002\u0005%|\u0017b\u0001%\u0002<R\u0011\u0011qU\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011I\u0001\u0006CB\u0004H.\u001f\u000b\u00061\u0006-\u0017Q\u001a\u0005\u0006\u0015v\u0001\r\u0001\u0014\u0005\b!v\u0001\n\u00111\u0001S\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003+\f\t\u000fE\u0003:\u0003/\fY.C\u0002\u0002Zj\u0012aa\u00149uS>t\u0007#B\u001d\u0002^2\u0013\u0016bAApu\t1A+\u001e9mKJB\u0001\"a9 \u0003\u0003\u0005\r\u0001W\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002lB!\u00111IAw\u0013\u0011\ty/!\u0012\u0003\r=\u0013'.Z2u\u0001")
public class Unhex
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$2() {
        return Unhex$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Unhex x$0) {
        return Unhex$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Unhex$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Unhex> tupled() {
        return Unhex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Unhex>> curried() {
        return Unhex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object num) {
        byte[] byArray;
        try {
            byArray = Hex$.MODULE$.unhex(((UTF8String)num).getBytes());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!this.failOnError()) {
                byArray = null;
            }
            throw QueryExecutionErrors$.MODULE$.invalidInputInConversionError((DataType)BinaryType$.MODULE$, (UTF8String)num, UTF8String.fromString((String)"HEX"), "try_to_binary");
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return byArray;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String expr = ctx.addReferenceObj("this", this, ctx.addReferenceObj$default$3());
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)input -> "\n        " + ev.value() + " = (byte[]) " + expr + ".nullSafeEval(" + input + ");\n        " + ev.isNull() + " = " + ev.value() + " == null;\n      ");
    }

    @Override
    public Unhex withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.failOnError());
    }

    public Unhex copy(Expression child, boolean failOnError) {
        return new Unhex(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Unhex";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Unhex;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Unhex)) return false;
        boolean bl = true;
        if (!bl) return false;
        Unhex unhex = (Unhex)x$1;
        if (this.failOnError() != unhex.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = unhex.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!unhex.canEqual(this)) return false;
        return true;
    }

    public Unhex(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public Unhex(Expression expr) {
        this(expr, false);
    }
}

