/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.FinalizedSketch;
import org.apache.spark.sql.catalyst.expressions.aggregate.ThetaSketchState;
import org.apache.spark.sql.catalyst.expressions.aggregate.ThetaUnionAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.UnionAggregationBuffer;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ThetaSketchUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, lgNomEntries) - Returns the ThetaSketch's Compact binary representation.\n      `lgNomEntries` (optional) the log-base-2 of Nominal Entries, with Nominal Entries deciding\n      the number buckets or slots for the ThetaSketch.", examples="\n    Examples:\n      > SELECT theta_sketch_estimate(_FUNC_(sketch)) FROM (SELECT theta_sketch_agg(col) as sketch FROM VALUES (1) tab(col) UNION ALL SELECT theta_sketch_agg(col, 20) as sketch FROM VALUES (1) tab(col));\n       1\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0005e\u0001\u0002\u00180\u0001zB\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000e\u0001BK\u0002\u0013\u0005a\r\u0003\u0005j\u0001\tE\t\u0015!\u0003M\u0011!Q\u0007A!f\u0001\n\u0003Z\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011A\u0004!Q3A\u0005B-D\u0001\"\u001d\u0001\u0003\u0012\u0003\u0006I\u0001\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\ts\u0002A)\u0019!C\u0001W\")!\u000f\u0001C\u0001u\")!\u000f\u0001C\u0001{\"1!\u000f\u0001C\u0001\u0003\u0003Aq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005]\u0001\u0001\"\u0015\u0002\u001a!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\t9\u0006\u0001C!\u00033Bq!!\u0019\u0001\t\u0003\n\u0019\u0007C\u0004\u0002f\u0001!\t%a\u001a\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003C\u0003A\u0011IAR\u0011%\tI\u000bAA\u0001\n\u0003\tY\u000bC\u0005\u00026\u0002\t\n\u0011\"\u0001\u00028\"I\u0011Q\u001a\u0001\u0012\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003\u001f\u0004\u0011\u0013!C\u0001\u0003#D\u0011\"!6\u0001#\u0003%\t!!5\t\u0013\u0005]\u0007!!A\u0005B\u0005e\u0007\u0002CAu\u0001\u0005\u0005I\u0011A6\t\u0013\u0005-\b!!A\u0005\u0002\u00055\b\"CAz\u0001\u0005\u0005I\u0011IA{\u0011%\u0011\u0019\u0001AA\u0001\n\u0003\u0011)\u0001C\u0005\u0003\n\u0001\t\t\u0011\"\u0011\u0003\f!I!q\u0002\u0001\u0002\u0002\u0013\u0005#\u0011C\u0004\n\u0005ky\u0013\u0011!E\u0001\u0005o1\u0001BL\u0018\u0002\u0002#\u0005!\u0011\b\u0005\u0007e\"\"\tA!\u0015\t\u0013\tM\u0003&!A\u0005F\tU\u0003\"\u0003B,Q\u0005\u0005I\u0011\u0011B-\u0011%\u0011\u0019\u0007KA\u0001\n\u0003\u0013)\u0007C\u0005\u0003x!\n\t\u0011\"\u0003\u0003z\tiA\u000b[3uCVs\u0017n\u001c8BO\u001eT!\u0001M\u0019\u0002\u0013\u0005<wM]3hCR,'B\u0001\u001a4\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005Q*\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005Y:\u0014aA:rY*\u0011\u0001(O\u0001\u0006gB\f'o\u001b\u0006\u0003um\na!\u00199bG\",'\"\u0001\u001f\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001yd\tU*Z!\r\u0001\u0015iQ\u0007\u0002_%\u0011!i\f\u0002\u0019)f\u0004X\rZ%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007C\u0001!E\u0013\t)uF\u0001\tUQ\u0016$\u0018mU6fi\u000eD7\u000b^1uKB\u0019qI\u0013'\u000e\u0003!S!!S\u001a\u0002\u000bQ\u0014X-Z:\n\u0005-C%A\u0003\"j]\u0006\u0014\u0018\u0010T5lKB\u0011QJT\u0007\u0002c%\u0011q*\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA'R\u0013\t\u0011\u0016GA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"\u0001V,\u000e\u0003US\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002[E:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=v\na\u0001\u0010:p_Rt\u0014\"\u0001,\n\u0005\u0005,\u0016a\u00029bG.\fw-Z\u0005\u0003G\u0012\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!!Y+\u0002\t1,g\r^\u000b\u0002\u0019\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u000b\u0002YB\u0011A+\\\u0005\u0003]V\u00131!\u00138u\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003\u0019a\u0014N\\5u}Q)A/\u001e<xqB\u0011\u0001\t\u0001\u0005\u0006K&\u0001\r\u0001\u0014\u0005\u0006Q&\u0001\r\u0001\u0014\u0005\u0006U&\u0001\r\u0001\u001c\u0005\u0006a&\u0001\r\u0001\\\u0001\rY\u001etu.\\#oiJLWm\u001d\u000b\u0003inDQ\u0001`\u0006A\u00021\u000bQa\u00195jY\u0012$2\u0001\u001e@\u0000\u0011\u0015aH\u00021\u0001M\u0011\u0015IH\u00021\u0001M)\u0015!\u00181AA\u0003\u0011\u0015aX\u00021\u0001M\u0011\u0015IX\u00021\u0001m\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$Hc\u0001;\u0002\f!1\u0011Q\u0002\bA\u00021\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2\u0001^A\n\u0011\u0019\t)b\u0004a\u0001Y\u00069b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$R\u0001^A\u000e\u0003?Aa!!\b\u0011\u0001\u0004a\u0015a\u00028fo2+g\r\u001e\u0005\u0007\u0003C\u0001\u0002\u0019\u0001'\u0002\u00119,wOU5hQR\f!\u0002\u001d:fiRLh*Y7f+\t\t9\u0003\u0005\u0003\u0002*\u0005Eb\u0002BA\u0016\u0003[\u0001\"\u0001X+\n\u0007\u0005=R+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\t)D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_)\u0016AC5oaV$H+\u001f9fgV\u0011\u00111\b\t\u00065\u0006u\u0012\u0011I\u0005\u0004\u0003\u007f!'aA*fcB!\u00111IA%\u001b\t\t)EC\u0002\u0002HU\nQ\u0001^=qKNLA!a\u0013\u0002F\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011\u0011\u000b\t\u0005\u0003\u0007\n\u0019&\u0003\u0003\u0002V\u0005\u0015#\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\"!a\u0017\u0011\u0007Q\u000bi&C\u0002\u0002`U\u0013qAQ8pY\u0016\fg.A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\t1)\u0001\u0004va\u0012\fG/\u001a\u000b\u0006\u0007\u0006%\u0014Q\u000e\u0005\u0007\u0003W2\u0002\u0019A\"\u0002\u0017Ut\u0017n\u001c8Ck\u001a4WM\u001d\u0005\b\u0003_2\u0002\u0019AA9\u0003\u0015Ig\u000e];u!\u0011\t\u0019(!\u001e\u000e\u0003MJ1!a\u001e4\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b5,'oZ3\u0015\u000b\r\u000bi(a \t\r\u0005-t\u00031\u0001D\u0011\u0019\tyg\u0006a\u0001\u0007\u0006!QM^1m)\u0011\t))a#\u0011\u0007Q\u000b9)C\u0002\u0002\nV\u00131!\u00118z\u0011\u0019\ti\t\u0007a\u0001\u0007\u0006Y1o[3uG\"\u001cF/\u0019;f\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002\u0014\u0006}\u0005#\u0002+\u0002\u0016\u0006e\u0015bAAL+\n)\u0011I\u001d:bsB\u0019A+a'\n\u0007\u0005uUK\u0001\u0003CsR,\u0007BBAG3\u0001\u00071)A\u0006eKN,'/[1mSj,GcA\"\u0002&\"9\u0011q\u0015\u000eA\u0002\u0005M\u0015A\u00022vM\u001a,'/\u0001\u0003d_BLH#\u0003;\u0002.\u0006=\u0016\u0011WAZ\u0011\u001d)7\u0004%AA\u00021Cq\u0001[\u000e\u0011\u0002\u0003\u0007A\nC\u0004k7A\u0005\t\u0019\u00017\t\u000fA\\\u0002\u0013!a\u0001Y\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA]U\ra\u00151X\u0016\u0003\u0003{\u0003B!a0\u0002J6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-A\u0005v]\u000eDWmY6fI*\u0019\u0011qY+\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002L\u0006\u0005'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003'T3\u0001\\A^\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAn!\u0011\ti.a:\u000e\u0005\u0005}'\u0002BAq\u0003G\fA\u0001\\1oO*\u0011\u0011Q]\u0001\u0005U\u00064\u0018-\u0003\u0003\u00024\u0005}\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000b\u000by\u000f\u0003\u0005\u0002r\n\n\t\u00111\u0001m\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001f\t\u0007\u0003s\fy0!\"\u000e\u0005\u0005m(bAA\u007f+\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u0005\u00111 \u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\\\t\u001d\u0001\"CAyI\u0005\u0005\t\u0019AAC\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m'Q\u0002\u0005\t\u0003c,\u0013\u0011!a\u0001Y\u00061Q-];bYN$B!a\u0017\u0003\u0014!I\u0011\u0011\u001f\u0014\u0002\u0002\u0003\u0007\u0011Q\u0011\u0015\u0014\u0001\t]!Q\u0004B\u0010\u0005G\u0011)C!\u000b\u0003,\t=\"\u0011\u0007\t\u0004\u001b\ne\u0011b\u0001B\u000ec\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u0011\u0003\u0005\u0015(\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO\u001d\u0017!Y\u001etu.\\#oiJLWm]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!)\",G/Y*lKR\u001c\u0007nJ:!\u0007>l\u0007/Y2uA\tLg.\u0019:zAI,\u0007O]3tK:$\u0018\r^5p]:R\u0001\u0005\t\u0011!A\u0001\u0002Gn\u001a(p[\u0016sGO]5fg\u0002\u0004\u0003f\u001c9uS>t\u0017\r\\\u0015!i\",\u0007\u0005\\8h[\t\f7/Z\u00173A=4\u0007ET8nS:\fG\u000eI#oiJLWm\u001d\u0017!o&$\b\u000e\t(p[&t\u0017\r\u001c\u0011F]R\u0014\u0018.Z:!I\u0016\u001c\u0017\u000eZ5oO*\u0001\u0003\u0005\t\u0011!AQDW\r\t8v[\n,'\u000f\t2vG.,Go\u001d\u0011pe\u0002\u001aHn\u001c;tA\u0019|'\u000f\t;iK\u0002\"\u0006.\u001a;b'.,Go\u00195/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B\u0014\u0003\u0005-'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;iKR\fwl]6fi\u000eDw,Z:uS6\fG/\u001a\u0015`\rVs5i\u0018\u0015tW\u0016$8\r[\u0015*A\u0019\u0013v*\u0014\u0011)'\u0016cUi\u0011+!i\",G/Y0tW\u0016$8\r[0bO\u001eD3m\u001c7*A\u0005\u001c\be]6fi\u000eD\u0007E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013'\u000b\u0011uC\nD3m\u001c7*AUs\u0015j\u0014(!\u00032c\u0005eU#M\u000b\u000e#\u0006\u0005\u001e5fi\u0006|6o[3uG\"|\u0016mZ4)G>dG\u0006\t\u001a1S\u0001\n7\u000fI:lKR\u001c\u0007\u000e\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&M\u0015!i\u0006\u0014\u0007fY8mS%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u0006!A\u0005)qM]8va\u0006\u0012!QF\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#Aa\r\u0002\u000bQr\u0013G\f\u0019\u0002\u001bQCW\r^1V]&|g.Q4h!\t\u0001\u0005fE\u0003)\u0005w\u00119\u0005E\u0005\u0003>\t\rC\n\u00147mi6\u0011!q\b\u0006\u0004\u0005\u0003*\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u000b\u0012yDA\tBEN$(/Y2u\rVt7\r^5p]R\u0002BA!\u0013\u0003P5\u0011!1\n\u0006\u0005\u0005\u001b\n\u0019/\u0001\u0002j_&\u00191Ma\u0013\u0015\u0005\t]\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0017!B1qa2LH#\u0003;\u0003\\\tu#q\fB1\u0011\u0015)7\u00061\u0001M\u0011\u0015A7\u00061\u0001M\u0011\u0015Q7\u00061\u0001m\u0011\u0015\u00018\u00061\u0001m\u0003\u001d)h.\u00199qYf$BAa\u001a\u0003tA)AK!\u001b\u0003n%\u0019!1N+\u0003\r=\u0003H/[8o!\u001d!&q\u000e'MY2L1A!\u001dV\u0005\u0019!V\u000f\u001d7fi!A!Q\u000f\u0017\u0002\u0002\u0003\u0007A/A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u001f\u0011\t\u0005u'QP\u0005\u0005\u0005\u007f\nyN\u0001\u0004PE*,7\r\u001e")
public class ThetaUnionAgg
extends TypedImperativeAggregate<ThetaSketchState>
implements BinaryLike<Expression>,
ExpectsInputTypes,
Serializable {
    private int lgNomEntries;
    private final Expression left;
    private final Expression right;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(ThetaUnionAgg x$0) {
        return ThetaUnionAgg$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, ThetaUnionAgg> tupled() {
        return ThetaUnionAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, ThetaUnionAgg>>>> curried() {
        return ThetaUnionAgg$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ThetaUnionAgg thetaUnionAgg = this;
        synchronized (thetaUnionAgg) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    /*
     * WARNING - void declaration
     */
    private int lgNomEntries$lzycompute() {
        ThetaUnionAgg thetaUnionAgg = this;
        synchronized (thetaUnionAgg) {
            if (!this.bitmap$0) {
                void var2_2;
                if (!this.right().foldable()) {
                    throw QueryExecutionErrors$.MODULE$.thetaLgNomEntriesMustBeConstantError(this.prettyName());
                }
                int lgNomEntriesInput = BoxesRunTime.unboxToInt((Object)this.right().eval(this.right().eval$default$1()));
                ThetaSketchUtils$.MODULE$.checkLgNomLongs(lgNomEntriesInput, this.prettyName());
                this.lgNomEntries = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.lgNomEntries;
    }

    public int lgNomEntries() {
        if (!this.bitmap$0) {
            return this.lgNomEntries$lzycompute();
        }
        return this.lgNomEntries;
    }

    @Override
    public ThetaUnionAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public ThetaUnionAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public ThetaUnionAgg withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public String prettyName() {
        return "theta_union_agg";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public ThetaSketchState createAggregationBuffer() {
        return new UnionAggregationBuffer(SetOperation.builder().setLogNominalEntries(this.lgNomEntries()).buildUnion());
    }

    @Override
    public ThetaSketchState update(ThetaSketchState unionBuffer, InternalRow input) {
        Object v = this.left().eval(input);
        if (v == null) {
            return unionBuffer;
        }
        DataType dataType = this.left().dataType();
        if (!BinaryType$.MODULE$.equals(dataType)) {
            throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(this.prettyName());
        }
        byte[] sketchBytes = (byte[])v;
        CompactSketch inputSketch = ThetaSketchUtils$.MODULE$.wrapCompactSketch(sketchBytes, this.prettyName());
        ThetaSketchState thetaSketchState = unionBuffer;
        if (!(thetaSketchState instanceof UnionAggregationBuffer)) {
            throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(this.prettyName());
        }
        UnionAggregationBuffer unionAggregationBuffer = (UnionAggregationBuffer)thetaSketchState;
        Union existingUnionBuffer = unionAggregationBuffer.union();
        Union union = existingUnionBuffer;
        union.union((Sketch)inputSketch);
        return new UnionAggregationBuffer(union);
    }

    @Override
    public ThetaSketchState merge(ThetaSketchState unionBuffer, ThetaSketchState input) {
        Tuple2 tuple2 = new Tuple2((Object)unionBuffer, (Object)input);
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState2 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof UnionAggregationBuffer) {
                UnionAggregationBuffer unionAggregationBuffer = (UnionAggregationBuffer)thetaSketchState;
                Union unionLeft = unionAggregationBuffer.union();
                if (thetaSketchState2 instanceof UnionAggregationBuffer) {
                    UnionAggregationBuffer unionAggregationBuffer2 = (UnionAggregationBuffer)thetaSketchState2;
                    Union unionRight = unionAggregationBuffer2.union();
                    unionLeft.union((Sketch)unionRight.getResult());
                    return new UnionAggregationBuffer(unionLeft);
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState3 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof UnionAggregationBuffer) {
                UnionAggregationBuffer unionAggregationBuffer = (UnionAggregationBuffer)thetaSketchState;
                Union union = unionAggregationBuffer.union();
                if (thetaSketchState3 instanceof FinalizedSketch) {
                    FinalizedSketch finalizedSketch = (FinalizedSketch)thetaSketchState3;
                    CompactSketch sketch = finalizedSketch.sketch();
                    union.union((Sketch)sketch);
                    return new UnionAggregationBuffer(union);
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState4 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof FinalizedSketch) {
                FinalizedSketch finalizedSketch = (FinalizedSketch)thetaSketchState;
                CompactSketch sketch1 = finalizedSketch.sketch();
                if (thetaSketchState4 instanceof FinalizedSketch) {
                    FinalizedSketch finalizedSketch2 = (FinalizedSketch)thetaSketchState4;
                    CompactSketch sketch2 = finalizedSketch2.sketch();
                    Union union = SetOperation.builder().setLogNominalEntries(this.lgNomEntries()).buildUnion();
                    union.union((Sketch)sketch1);
                    union.union((Sketch)sketch2);
                    return new UnionAggregationBuffer(union);
                }
            }
        }
        if (tuple2 != null) {
            ThetaSketchState thetaSketchState = (ThetaSketchState)tuple2._1();
            ThetaSketchState thetaSketchState5 = (ThetaSketchState)tuple2._2();
            if (thetaSketchState instanceof FinalizedSketch) {
                FinalizedSketch finalizedSketch = (FinalizedSketch)thetaSketchState;
                CompactSketch sketch = finalizedSketch.sketch();
                if (thetaSketchState5 instanceof UnionAggregationBuffer) {
                    UnionAggregationBuffer unionAggregationBuffer = (UnionAggregationBuffer)thetaSketchState5;
                    Union union = unionAggregationBuffer.union();
                    union.union((Sketch)sketch);
                    return new UnionAggregationBuffer(union);
                }
            }
        }
        throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(this.prettyName());
    }

    @Override
    public Object eval(ThetaSketchState sketchState) {
        return sketchState.eval();
    }

    @Override
    public byte[] serialize(ThetaSketchState sketchState) {
        return sketchState.serialize();
    }

    @Override
    public ThetaSketchState deserialize(byte[] buffer) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(buffer))) {
            return new FinalizedSketch(CompactSketch.heapify((Memory)Memory.wrap((byte[])buffer)));
        }
        return this.createAggregationBuffer();
    }

    public ThetaUnionAgg copy(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ThetaUnionAgg(left, right, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ThetaUnionAgg";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ThetaUnionAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ThetaUnionAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        ThetaUnionAgg thetaUnionAgg = (ThetaUnionAgg)x$1;
        if (this.mutableAggBufferOffset() != thetaUnionAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != thetaUnionAgg.inputAggBufferOffset()) return false;
        Expression expression = this.left();
        Expression expression2 = thetaUnionAgg.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = thetaUnionAgg.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!thetaUnionAgg.canEqual(this)) return false;
        return true;
    }

    public ThetaUnionAgg(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.left = left;
        this.right = right;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        BinaryLike.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public ThetaUnionAgg(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)12)), 0, 0);
    }

    public ThetaUnionAgg(Expression child, Expression lgNomEntries) {
        this(child, lgNomEntries, 0, 0);
    }

    public ThetaUnionAgg(Expression child, int lgNomEntries) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)lgNomEntries)), 0, 0);
    }
}

