/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.spark.sql.catalyst.expressions.json.SharedFactory;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.unsafe.types.UTF8String;

public class JsonExpressionUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Integer lengthOfJsonArray(UTF8String json) {
        try (JsonParser jsonParser = CreateJacksonParser.utf8String(SharedFactory.jsonFactory(), json);){
            if (jsonParser.nextToken() == null) {
                Integer n = null;
                return n;
            }
            if (jsonParser.currentToken() != JsonToken.START_ARRAY) {
                Integer n = null;
                return n;
            }
            int length = 0;
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                ++length;
                jsonParser.skipChildren();
            }
            Integer n = length;
            return n;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GenericArrayData jsonObjectKeys(UTF8String json) {
        try (JsonParser jsonParser = CreateJacksonParser.utf8String(SharedFactory.jsonFactory(), json);){
            if (jsonParser.nextToken() == null || jsonParser.currentToken() != JsonToken.START_OBJECT) {
                GenericArrayData genericArrayData2 = null;
                return genericArrayData2;
            }
            ArrayList<UTF8String> arrayBufferOfKeys = new ArrayList<UTF8String>();
            while (jsonParser.nextValue() != null && jsonParser.currentName() != null) {
                arrayBufferOfKeys.add(UTF8String.fromString((String)jsonParser.currentName()));
                jsonParser.skipChildren();
            }
            GenericArrayData genericArrayData = new GenericArrayData(arrayBufferOfKeys.toArray());
            return genericArrayData;
        }
        catch (IOException e) {
            return null;
        }
    }
}

