/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.logging;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.common.FlowStatus;
import org.apache.spark.sql.pipelines.common.FlowStatus$COMPLETED$;
import org.apache.spark.sql.pipelines.common.FlowStatus$EXCLUDED$;
import org.apache.spark.sql.pipelines.common.FlowStatus$FAILED$;
import org.apache.spark.sql.pipelines.common.FlowStatus$IDLE$;
import org.apache.spark.sql.pipelines.common.FlowStatus$PLANNING$;
import org.apache.spark.sql.pipelines.common.FlowStatus$QUEUED$;
import org.apache.spark.sql.pipelines.common.FlowStatus$RUNNING$;
import org.apache.spark.sql.pipelines.common.FlowStatus$SKIPPED$;
import org.apache.spark.sql.pipelines.common.FlowStatus$STARTING$;
import org.apache.spark.sql.pipelines.common.FlowStatus$STOPPED$;
import org.apache.spark.sql.pipelines.graph.FlowExecution;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.ResolutionCompletedFlow;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.logging.ConstructPipelineEvent$;
import org.apache.spark.sql.pipelines.logging.EventLevel;
import org.apache.spark.sql.pipelines.logging.EventLevel$ERROR$;
import org.apache.spark.sql.pipelines.logging.EventLevel$INFO$;
import org.apache.spark.sql.pipelines.logging.EventLevel$WARN$;
import org.apache.spark.sql.pipelines.logging.FlowProgress;
import org.apache.spark.sql.pipelines.logging.PipelineEvent;
import org.apache.spark.sql.pipelines.logging.PipelineEventOrigin;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.StringContext;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\u000b\u0017\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006w\u0001!\t\u0001\u0010\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019\u0011\u0006\u0001)A\u0005\u0003\"91\u000b\u0001b\u0001\n\u0013!\u0006B\u0002/\u0001A\u0003%Q\u000bC\u0003^\u0001\u0011\u0005a\fC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0003l\u0001\u0011\u0005A\u000eC\u0003s\u0001\u0011\u00051\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0005\u00022\u0001\t\n\u0011\"\u0001\u00024!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003+\u0002A\u0011AA,\u0011\u001d\tY\u0006\u0001C\u0001\u0003;B\u0011\"a\u001b\u0001#\u0003%\t!a\r\t\u0013\u00055\u0004!%A\u0005\u0002\u0005=\u0004bBA:\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003s\u0002A\u0011AA>\u0005]1En\\<Qe><'/Z:t\u000bZ,g\u000e\u001e'pO\u001e,'O\u0003\u0002\u00181\u00059An\\4hS:<'BA\r\u001b\u0003%\u0001\u0018\u000e]3mS:,7O\u0003\u0002\u001c9\u0005\u00191/\u001d7\u000b\u0005uq\u0012!B:qCJ\\'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016/\u001b\u0005a#BA\u0017\u001d\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0018-\u0005\u001daunZ4j]\u001e\fQ\"\u001a<f]R\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003B\u00133iaJ!a\r\u0014\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u001b7\u001b\u00051\u0012BA\u001c\u0017\u00055\u0001\u0016\u000e]3mS:,WI^3oiB\u0011Q%O\u0005\u0003u\u0019\u0012A!\u00168ji\u00061A(\u001b8jiz\"\"!\u0010 \u0011\u0005U\u0002\u0001\"\u0002\u0019\u0003\u0001\u0004\t\u0014\u0001\u0004:v]:Lgn\u001a$m_^\u001cX#A!\u0011\t\t;\u0015jT\u0007\u0002\u0007*\u0011A)R\u0001\u000bG>t7-\u001e:sK:$(B\u0001$'\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0011\u000e\u00131!T1q!\tQU*D\u0001L\u0015\ta%$\u0001\u0005dCR\fG._:u\u0013\tq5JA\bUC\ndW-\u00133f]RLg-[3s!\t)\u0003+\u0003\u0002RM\t9!i\\8mK\u0006t\u0017!\u0004:v]:Lgn\u001a$m_^\u001c\b%\u0001\bl]><h.\u00133mK\u001acwn^:\u0016\u0003U\u0003BAQ$J-B\u0011qKW\u0007\u00021*\u0011\u0011\fG\u0001\u0007G>lWn\u001c8\n\u0005mC&A\u0003$m_^\u001cF/\u0019;vg\u0006y1N\\8x]&#G.\u001a$m_^\u001c\b%\u0001\u0007sK\u000e|'\u000fZ)vKV,G\r\u0006\u00029?\")\u0001m\u0002a\u0001C\u0006!a\r\\8x!\t\u0011W-D\u0001d\u0015\t!\u0007$A\u0003he\u0006\u0004\b.\u0003\u0002gG\na!+Z:pYZ,GM\u00127po\u0006Q\"/Z2pe\u0012\u0004F.\u00198oS:<gi\u001c:CCR\u001c\u0007N\u00127poR\u0011\u0001(\u001b\u0005\u0006U\"\u0001\r!Y\u0001\nE\u0006$8\r\u001b$m_^\f1B]3d_J$7\u000b^1siR\u0011\u0001(\u001c\u0005\u0006]&\u0001\ra\\\u0001\u000eM2|w/\u0012=fGV$\u0018n\u001c8\u0011\u0005\t\u0004\u0018BA9d\u000551En\\<Fq\u0016\u001cW\u000f^5p]\u0006i!/Z2pe\u0012\u0014VO\u001c8j]\u001e$\"\u0001\u000f;\t\u000b\u0001T\u0001\u0019A1\u0002\u0019I,7m\u001c:e\r\u0006LG.\u001a3\u0015\u000fa:80a\u0005\u0002\u0018!)\u0001m\u0003a\u0001qB\u0011!-_\u0005\u0003u\u000e\u0014qCU3t_2,H/[8o\u0007>l\u0007\u000f\\3uK\u00124En\\<\t\u000bq\\\u0001\u0019A?\u0002\u0013\u0015D8-\u001a9uS>t\u0007c\u0001@\u0002\u000e9\u0019q0!\u0003\u000f\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002#\u0003\u0019a$o\\8u}%\tq%C\u0002\u0002\f\u0019\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0010\u0005E!!\u0003+ie><\u0018M\u00197f\u0015\r\tYA\n\u0005\u0007\u0003+Y\u0001\u0019A(\u0002\u00131|w-Q:XCJt\u0007\"CA\r\u0017A\u0005\t\u0019AA\u000e\u0003)iWm]:bO\u0016|\u0005\u000f\u001e\t\u0006K\u0005u\u0011\u0011E\u0005\u0004\u0003?1#AB(qi&|g\u000e\u0005\u0003\u0002$\u0005-b\u0002BA\u0013\u0003O\u00012!!\u0001'\u0013\r\tICJ\u0001\u0007!J,G-\u001a4\n\t\u00055\u0012q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%b%\u0001\fsK\u000e|'\u000f\u001a$bS2,G\r\n3fM\u0006,H\u000e\u001e\u00135+\t\t)D\u000b\u0003\u0002\u001c\u0005]2FAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rc%\u0001\u0006b]:|G/\u0019;j_:LA!a\u0012\u0002>\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002=I,7m\u001c:e'.L\u0007\u000f]3e\u001f:,\u0006o\u0015;sK\u0006lg)Y5mkJ,Gc\u0001\u001d\u0002N!)\u0001-\u0004a\u0001C\u0006i!/Z2pe\u0012\u001c6.\u001b9qK\u0012$2\u0001OA*\u0011\u0015\u0001g\u00021\u0001b\u00039\u0011XmY8sI\u0016C8\r\\;eK\u0012$2\u0001OA-\u0011\u0015\u0001w\u00021\u0001b\u0003)\u0011XmY8sIN#x\u000e\u001d\u000b\bq\u0005}\u0013\u0011MA3\u0011\u0015\u0001\u0007\u00031\u0001b\u0011%\t\u0019\u0007\u0005I\u0001\u0002\u0004\tY\"A\u0004nKN\u001c\u0018mZ3\t\u0013\u0005\u001d\u0004\u0003%AA\u0002\u0005%\u0014!B2bkN,\u0007\u0003B\u0013\u0002\u001eu\fAC]3d_J$7\u000b^8qI\u0011,g-Y;mi\u0012\u0012\u0014\u0001\u0006:fG>\u0014Hm\u0015;pa\u0012\"WMZ1vYR$3'\u0006\u0002\u0002r)\"\u0011\u0011NA\u001c\u0003)\u0011XmY8sI&#G.\u001a\u000b\u0004q\u0005]\u0004\"\u00021\u0014\u0001\u0004\t\u0017\u0001\u0005:fG>\u0014HmQ8na2,G/[8o)\rA\u0014Q\u0010\u0005\u0006AR\u0001\r!\u0019")
public class FlowProgressEventLogger
implements Logging {
    private final Function1<PipelineEvent, BoxedUnit> eventCallback;
    private final scala.collection.concurrent.Map<TableIdentifier, Object> runningFlows;
    private final scala.collection.concurrent.Map<TableIdentifier, FlowStatus> knownIdleFlows;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private scala.collection.concurrent.Map<TableIdentifier, Object> runningFlows() {
        return this.runningFlows;
    }

    private scala.collection.concurrent.Map<TableIdentifier, FlowStatus> knownIdleFlows() {
        return this.knownIdleFlows;
    }

    public synchronized void recordQueued(ResolvedFlow flow) {
        Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
        None$ x$2 = None$.MODULE$;
        Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
        this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow " + flow.displayName() + " is QUEUED.", new FlowProgress(FlowStatus$QUEUED$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
    }

    public void recordPlanningForBatchFlow(ResolvedFlow batchFlow) {
        block4: {
            FlowProgressEventLogger flowProgressEventLogger = this;
            synchronized (flowProgressEventLogger) {
                block3: {
                    if (batchFlow.df().isStreaming()) break block3;
                    Option x$1 = Option$.MODULE$.apply((Object)batchFlow.displayName());
                    None$ x$2 = None$.MODULE$;
                    Option x$3 = Option$.MODULE$.apply((Object)batchFlow.origin());
                    this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow " + batchFlow.displayName() + " is PLANNING.", new FlowProgress(FlowStatus$PLANNING$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
                    this.knownIdleFlows().remove((Object)batchFlow.identifier());
                    break block4;
                }
                return;
            }
        }
    }

    public void recordStart(FlowExecution flowExecution) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flowExecution.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flowExecution.getOrigin());
            this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow " + flowExecution.displayName() + " is STARTING.", new FlowProgress(FlowStatus$STARTING$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.knownIdleFlows().remove((Object)flowExecution.identifier());
        }
    }

    public void recordRunning(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow " + flow.displayName() + " is RUNNING.", new FlowProgress(FlowStatus$RUNNING$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.runningFlows().put((Object)flow.identifier(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public void recordFailed(ResolutionCompletedFlow flow, Throwable exception, boolean logAsWarn, Option<String> messageOpt) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            String eventLogMessage = (String)messageOpt.getOrElse((Function0 & Serializable)() -> "Flow '" + flow.displayName() + "' has FAILED.");
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), (EventLevel)(logAsWarn ? EventLevel$WARN$.MODULE$ : EventLevel$ERROR$.MODULE$), eventLogMessage, new FlowProgress(FlowStatus$FAILED$.MODULE$), (Option<Throwable>)Option$.MODULE$.apply((Object)exception), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.runningFlows().remove((Object)flow.identifier());
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public Option<String> recordFailed$default$4() {
        return None$.MODULE$;
    }

    public void recordSkippedOnUpStreamFailure(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$WARN$.MODULE$, "Flow '" + flow.displayName() + "' SKIPPED due to upstream failure(s).", new FlowProgress(FlowStatus$SKIPPED$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.runningFlows().remove((Object)flow.identifier());
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public void recordSkipped(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow '" + flow.displayName() + "' has been processed by a previous iteration and will not be rerun.", new FlowProgress(FlowStatus$SKIPPED$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.knownIdleFlows().put((Object)flow.identifier(), (Object)FlowStatus$SKIPPED$.MODULE$);
        }
    }

    public void recordExcluded(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow '" + flow.displayName() + "' is EXCLUDED.", new FlowProgress(FlowStatus$EXCLUDED$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public void recordStop(ResolvedFlow flow, Option<String> message, Option<Throwable> cause) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, (String)message.getOrElse((Function0 & Serializable)() -> "Flow '" + flow.displayName() + "' has STOPPED."), new FlowProgress(FlowStatus$STOPPED$.MODULE$), cause, ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.runningFlows().remove((Object)flow.identifier());
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public Option<String> recordStop$default$2() {
        return None$.MODULE$;
    }

    public Option<Throwable> recordStop$default$3() {
        return None$.MODULE$;
    }

    public void recordIdle(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow '" + flow.displayName() + "' is IDLE, waiting for new data.", new FlowProgress(FlowStatus$IDLE$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.knownIdleFlows().put((Object)flow.identifier(), (Object)FlowStatus$IDLE$.MODULE$);
        }
    }

    public void recordCompletion(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventCallback.apply((Object)ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow " + flow.displayName() + " has COMPLETED.", new FlowProgress(FlowStatus$COMPLETED$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public FlowProgressEventLogger(Function1<PipelineEvent, BoxedUnit> eventCallback) {
        this.eventCallback = eventCallback;
        Logging.$init$((Logging)this);
        this.runningFlows = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.knownIdleFlows = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    }
}

